/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.ValueSource;
import org.apache.lucene.util.ToStringUtils;

public class ValueSourceQuery
extends Query {
    ValueSource valSrc;

    public ValueSourceQuery(ValueSource valueSource) {
        this.valSrc = valueSource;
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        return this;
    }

    @Override
    public void extractTerms(Set<Term> set) {
    }

    @Override
    public Weight createWeight(Searcher searcher) {
        return new ValueSourceWeight(searcher);
    }

    @Override
    public String toString(String string) {
        return this.valSrc.toString() + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ValueSourceQuery valueSourceQuery = (ValueSourceQuery)object;
        return this.getBoost() == valueSourceQuery.getBoost() && this.valSrc.equals(valueSourceQuery.valSrc);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.valSrc.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    private class ValueSourceScorer
    extends Scorer {
        private final float qWeight;
        private final DocValues vals;
        private final TermDocs termDocs;
        private int doc;

        private ValueSourceScorer(Similarity similarity, IndexReader indexReader, ValueSourceWeight valueSourceWeight) throws IOException {
            super(similarity, valueSourceWeight);
            this.doc = -1;
            this.qWeight = valueSourceWeight.getValue();
            this.vals = ValueSourceQuery.this.valSrc.getValues(indexReader);
            this.termDocs = indexReader.termDocs(null);
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.termDocs.next() ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int advance(int n) throws IOException {
            this.doc = this.termDocs.skipTo(n) ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }

        @Override
        public float score() throws IOException {
            return this.qWeight * this.vals.floatVal(this.termDocs.doc());
        }
    }

    class ValueSourceWeight
    extends Weight {
        Similarity similarity;
        float queryNorm;
        float queryWeight;

        public ValueSourceWeight(Searcher searcher) {
            this.similarity = ValueSourceQuery.this.getSimilarity(searcher);
        }

        @Override
        public Query getQuery() {
            return ValueSourceQuery.this;
        }

        @Override
        public float getValue() {
            return this.queryWeight;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ValueSourceQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            return new ValueSourceScorer(this.similarity, indexReader, this);
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            DocValues docValues = ValueSourceQuery.this.valSrc.getValues(indexReader);
            float f = this.queryWeight * docValues.floatVal(n);
            ComplexExplanation complexExplanation = new ComplexExplanation(true, f, ValueSourceQuery.this.toString() + ", product of:");
            complexExplanation.addDetail(docValues.explain(n));
            complexExplanation.addDetail(new Explanation(ValueSourceQuery.this.getBoost(), "boost"));
            complexExplanation.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            return complexExplanation;
        }
    }
}

