/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.function.CustomScoreProvider;
import org.apache.lucene.search.function.ValueSourceQuery;
import org.apache.lucene.util.ToStringUtils;

public class CustomScoreQuery
extends Query {
    private Query subQuery;
    private ValueSourceQuery[] valSrcQueries;
    private boolean strict;

    public CustomScoreQuery(Query query) {
        this(query, new ValueSourceQuery[0]);
    }

    public CustomScoreQuery(Query query, ValueSourceQuery valueSourceQuery) {
        ValueSourceQuery[] valueSourceQueryArray;
        if (valueSourceQuery != null) {
            ValueSourceQuery[] valueSourceQueryArray2 = new ValueSourceQuery[1];
            valueSourceQueryArray = valueSourceQueryArray2;
            valueSourceQueryArray2[0] = valueSourceQuery;
        } else {
            valueSourceQueryArray = new ValueSourceQuery[]{};
        }
        this(query, valueSourceQueryArray);
    }

    public CustomScoreQuery(Query query, ValueSourceQuery ... valueSourceQueryArray) {
        this.strict = false;
        this.subQuery = query;
        ValueSourceQuery[] valueSourceQueryArray2 = this.valSrcQueries = valueSourceQueryArray != null ? valueSourceQueryArray : new ValueSourceQuery[]{};
        if (query == null) {
            throw new IllegalArgumentException("<subquery> must not be null!");
        }
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        CustomScoreQuery customScoreQuery = null;
        Query query = this.subQuery.rewrite(indexReader);
        if (query != this.subQuery) {
            customScoreQuery = (CustomScoreQuery)this.clone();
            customScoreQuery.subQuery = query;
        }
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            ValueSourceQuery valueSourceQuery = (ValueSourceQuery)this.valSrcQueries[i].rewrite(indexReader);
            if (valueSourceQuery == this.valSrcQueries[i]) continue;
            if (customScoreQuery == null) {
                customScoreQuery = (CustomScoreQuery)this.clone();
            }
            customScoreQuery.valSrcQueries[i] = valueSourceQuery;
        }
        return customScoreQuery == null ? this : customScoreQuery;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        this.subQuery.extractTerms(set);
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            this.valSrcQueries[i].extractTerms(set);
        }
    }

    @Override
    public Object clone() {
        CustomScoreQuery customScoreQuery = (CustomScoreQuery)super.clone();
        customScoreQuery.subQuery = (Query)this.subQuery.clone();
        customScoreQuery.valSrcQueries = new ValueSourceQuery[this.valSrcQueries.length];
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            customScoreQuery.valSrcQueries[i] = (ValueSourceQuery)this.valSrcQueries[i].clone();
        }
        return customScoreQuery;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.name()).append("(");
        stringBuilder.append(this.subQuery.toString(string));
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            stringBuilder.append(", ").append(this.valSrcQueries[i].toString(string));
        }
        stringBuilder.append(")");
        stringBuilder.append(this.strict ? " STRICT" : "");
        return stringBuilder.toString() + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CustomScoreQuery customScoreQuery = (CustomScoreQuery)object;
        if (this.getBoost() != customScoreQuery.getBoost() || !this.subQuery.equals(customScoreQuery.subQuery) || this.strict != customScoreQuery.strict || this.valSrcQueries.length != customScoreQuery.valSrcQueries.length) {
            return false;
        }
        return Arrays.equals(this.valSrcQueries, customScoreQuery.valSrcQueries);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.subQuery.hashCode() + Arrays.hashCode(this.valSrcQueries) ^ Float.floatToIntBits(this.getBoost()) ^ (this.strict ? 1234 : 4321);
    }

    protected CustomScoreProvider getCustomScoreProvider(IndexReader indexReader) throws IOException {
        return new CustomScoreProvider(indexReader);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new CustomWeight(searcher);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public String name() {
        return "custom";
    }

    private class CustomScorer
    extends Scorer {
        private final float qWeight;
        private Scorer subQueryScorer;
        private Scorer[] valSrcScorers;
        private final CustomScoreProvider provider;
        private float[] vScores;

        private CustomScorer(Similarity similarity, IndexReader indexReader, CustomWeight customWeight, Scorer scorer, Scorer[] scorerArray) throws IOException {
            super(similarity, customWeight);
            this.qWeight = customWeight.getValue();
            this.subQueryScorer = scorer;
            this.valSrcScorers = scorerArray;
            this.vScores = new float[scorerArray.length];
            this.provider = CustomScoreQuery.this.getCustomScoreProvider(indexReader);
        }

        @Override
        public int nextDoc() throws IOException {
            int n = this.subQueryScorer.nextDoc();
            if (n != Integer.MAX_VALUE) {
                for (int i = 0; i < this.valSrcScorers.length; ++i) {
                    this.valSrcScorers[i].advance(n);
                }
            }
            return n;
        }

        @Override
        public int docID() {
            return this.subQueryScorer.docID();
        }

        @Override
        public float score() throws IOException {
            for (int i = 0; i < this.valSrcScorers.length; ++i) {
                this.vScores[i] = this.valSrcScorers[i].score();
            }
            return this.qWeight * this.provider.customScore(this.subQueryScorer.docID(), this.subQueryScorer.score(), this.vScores);
        }

        @Override
        public int advance(int n) throws IOException {
            int n2 = this.subQueryScorer.advance(n);
            if (n2 != Integer.MAX_VALUE) {
                for (int i = 0; i < this.valSrcScorers.length; ++i) {
                    this.valSrcScorers[i].advance(n2);
                }
            }
            return n2;
        }
    }

    private class CustomWeight
    extends Weight {
        Similarity similarity;
        Weight subQueryWeight;
        Weight[] valSrcWeights;
        boolean qStrict;

        public CustomWeight(Searcher searcher) throws IOException {
            this.similarity = CustomScoreQuery.this.getSimilarity(searcher);
            this.subQueryWeight = CustomScoreQuery.this.subQuery.createWeight(searcher);
            this.valSrcWeights = new Weight[CustomScoreQuery.this.valSrcQueries.length];
            for (int i = 0; i < CustomScoreQuery.this.valSrcQueries.length; ++i) {
                this.valSrcWeights[i] = CustomScoreQuery.this.valSrcQueries[i].createWeight(searcher);
            }
            this.qStrict = CustomScoreQuery.this.strict;
        }

        @Override
        public Query getQuery() {
            return CustomScoreQuery.this;
        }

        @Override
        public float getValue() {
            return CustomScoreQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float f = this.subQueryWeight.sumOfSquaredWeights();
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                if (this.qStrict) {
                    this.valSrcWeights[i].sumOfSquaredWeights();
                    continue;
                }
                f += this.valSrcWeights[i].sumOfSquaredWeights();
            }
            return f *= CustomScoreQuery.this.getBoost() * CustomScoreQuery.this.getBoost();
        }

        @Override
        public void normalize(float f) {
            this.subQueryWeight.normalize(f *= CustomScoreQuery.this.getBoost());
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                if (this.qStrict) {
                    this.valSrcWeights[i].normalize(1.0f);
                    continue;
                }
                this.valSrcWeights[i].normalize(f);
            }
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            Scorer scorer = this.subQueryWeight.scorer(indexReader, true, false);
            if (scorer == null) {
                return null;
            }
            Scorer[] scorerArray = new Scorer[this.valSrcWeights.length];
            for (int i = 0; i < scorerArray.length; ++i) {
                scorerArray[i] = this.valSrcWeights[i].scorer(indexReader, true, bl2);
            }
            return new CustomScorer(this.similarity, indexReader, this, scorer, scorerArray);
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            Explanation explanation = this.doExplain(indexReader, n);
            return explanation == null ? new Explanation(0.0f, "no matching docs") : explanation;
        }

        private Explanation doExplain(IndexReader indexReader, int n) throws IOException {
            Explanation explanation = this.subQueryWeight.explain(indexReader, n);
            if (!explanation.isMatch()) {
                return explanation;
            }
            Explanation[] explanationArray = new Explanation[this.valSrcWeights.length];
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                explanationArray[i] = this.valSrcWeights[i].explain(indexReader, n);
            }
            Explanation explanation2 = CustomScoreQuery.this.getCustomScoreProvider(indexReader).customExplain(n, explanation, explanationArray);
            float f = this.getValue() * explanation2.getValue();
            ComplexExplanation complexExplanation = new ComplexExplanation(true, f, CustomScoreQuery.this.toString() + ", product of:");
            complexExplanation.addDetail(explanation2);
            complexExplanation.addDetail(new Explanation(this.getValue(), "queryBoost"));
            return complexExplanation;
        }

        @Override
        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

