/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;

public class CustomScoreProvider {
    protected final IndexReader reader;

    public CustomScoreProvider(IndexReader indexReader) {
        this.reader = indexReader;
    }

    public float customScore(int n, float f, float[] fArray) throws IOException {
        if (fArray.length == 1) {
            return this.customScore(n, f, fArray[0]);
        }
        if (fArray.length == 0) {
            return this.customScore(n, f, 1.0f);
        }
        float f2 = f;
        for (int i = 0; i < fArray.length; ++i) {
            f2 *= fArray[i];
        }
        return f2;
    }

    public float customScore(int n, float f, float f2) throws IOException {
        return f * f2;
    }

    public Explanation customExplain(int n, Explanation explanation, Explanation[] explanationArray) throws IOException {
        if (explanationArray.length == 1) {
            return this.customExplain(n, explanation, explanationArray[0]);
        }
        if (explanationArray.length == 0) {
            return explanation;
        }
        float f = 1.0f;
        for (int i = 0; i < explanationArray.length; ++i) {
            f *= explanationArray[i].getValue();
        }
        Explanation explanation2 = new Explanation(f * explanation.getValue(), "custom score: product of:");
        explanation2.addDetail(explanation);
        for (int i = 0; i < explanationArray.length; ++i) {
            explanation2.addDetail(explanationArray[i]);
        }
        return explanation2;
    }

    public Explanation customExplain(int n, Explanation explanation, Explanation explanation2) throws IOException {
        float f = 1.0f;
        if (explanation2 != null) {
            f *= explanation2.getValue();
        }
        Explanation explanation3 = new Explanation(f * explanation.getValue(), "custom score: product of:");
        explanation3.addDetail(explanation);
        explanation3.addDetail(explanation2);
        return explanation3;
    }
}

