/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.ThreadInterruptedException;

public class TimeLimitingCollector
extends Collector {
    private long t0 = Long.MIN_VALUE;
    private long timeout = Long.MIN_VALUE;
    private final Collector collector;
    private final Counter clock;
    private final long ticksAllowed;
    private boolean greedy = false;
    private int docBase;

    public TimeLimitingCollector(Collector collector, Counter counter, long l) {
        this.collector = collector;
        this.clock = counter;
        this.ticksAllowed = l;
    }

    public void setBaseline(long l) {
        this.t0 = l;
        this.timeout = this.t0 + this.ticksAllowed;
    }

    public void setBaseline() {
        this.setBaseline(this.clock.get());
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean bl) {
        this.greedy = bl;
    }

    @Override
    public void collect(int n) throws IOException {
        long l = this.clock.get();
        if (this.timeout < l) {
            if (this.greedy) {
                this.collector.collect(n);
            }
            throw new TimeExceededException(this.timeout - this.t0, l - this.t0, this.docBase + n);
        }
        this.collector.collect(n);
    }

    @Override
    public void setNextReader(IndexReader indexReader, int n) throws IOException {
        this.collector.setNextReader(indexReader, n);
        this.docBase = n;
        if (Long.MIN_VALUE == this.t0) {
            this.setBaseline();
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }

    public static Counter getGlobalCounter() {
        return TimerThreadHolder.THREAD.counter;
    }

    public static TimerThread getGlobalTimerThread() {
        return TimerThreadHolder.THREAD;
    }

    public static final class TimerThread
    extends Thread {
        public static final String THREAD_NAME = "TimeLimitedCollector timer thread";
        public static final int DEFAULT_RESOLUTION = 20;
        private volatile long time = 0L;
        private volatile boolean stop = false;
        private volatile long resolution;
        final Counter counter;

        public TimerThread(long l, Counter counter) {
            super(THREAD_NAME);
            this.resolution = l;
            this.counter = counter;
            this.setDaemon(true);
        }

        public TimerThread(Counter counter) {
            this(20L, counter);
        }

        @Override
        public void run() {
            while (!this.stop) {
                this.counter.addAndGet(this.resolution);
                try {
                    Thread.sleep(this.resolution);
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException);
                }
            }
        }

        public long getMilliseconds() {
            return this.time;
        }

        public void stopTimer() {
            this.stop = true;
        }

        public long getResolution() {
            return this.resolution;
        }

        public void setResolution(long l) {
            this.resolution = Math.max(l, 5L);
        }
    }

    private static final class TimerThreadHolder {
        static final TimerThread THREAD = new TimerThread(Counter.newCounter(true));

        private TimerThreadHolder() {
        }

        static {
            THREAD.start();
        }
    }

    public static class TimeExceededException
    extends RuntimeException {
        private long timeAllowed;
        private long timeElapsed;
        private int lastDocCollected;

        private TimeExceededException(long l, long l2, int n) {
            super("Elapsed time: " + l2 + "Exceeded allowed search time: " + l + " ms.");
            this.timeAllowed = l;
            this.timeElapsed = l2;
            this.lastDocCollected = n;
        }

        public long getTimeAllowed() {
            return this.timeAllowed;
        }

        public long getTimeElapsed() {
            return this.timeElapsed;
        }

        public int getLastDocCollected() {
            return this.lastDocCollected;
        }
    }
}

