/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class TermScorer
extends Scorer {
    private final TermDocs termDocs;
    private final byte[] norms;
    private float weightValue;
    private int doc = -1;
    private int freq;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private final float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs termDocs, Similarity similarity, byte[] byArray) {
        super(similarity, weight);
        this.termDocs = termDocs;
        this.norms = byArray;
        this.weightValue = weight.getValue();
        for (int i = 0; i < 32; ++i) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
        }
    }

    @Override
    public void score(Collector collector) throws IOException {
        this.score(collector, Integer.MAX_VALUE, this.nextDoc());
    }

    @Override
    protected boolean score(Collector collector, int n, int n2) throws IOException {
        collector.setScorer(this);
        while (this.doc < n) {
            collector.collect(this.doc);
            if (++this.pointer >= this.pointerMax) {
                this.pointerMax = this.termDocs.read(this.docs, this.freqs);
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.termDocs.close();
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
            }
            this.doc = this.docs[this.pointer];
            this.freq = this.freqs[this.pointer];
        }
        return true;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float freq() {
        return this.freq;
    }

    @Override
    public int nextDoc() throws IOException {
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.termDocs.read(this.docs, this.freqs);
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.termDocs.close();
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
        }
        this.doc = this.docs[this.pointer];
        this.freq = this.freqs[this.pointer];
        return this.doc;
    }

    @Override
    public float score() {
        assert (this.doc != -1);
        float f = this.freq < 32 ? this.scoreCache[this.freq] : this.getSimilarity().tf(this.freq) * this.weightValue;
        return this.norms == null ? f : f * this.getSimilarity().decodeNormValue(this.norms[this.doc]);
    }

    @Override
    public int advance(int n) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] >= n) {
                this.freq = this.freqs[this.pointer];
                this.doc = this.docs[this.pointer];
                return this.doc;
            }
            ++this.pointer;
        }
        boolean bl = this.termDocs.skipTo(n);
        if (bl) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.termDocs.doc();
            this.freqs[this.pointer] = this.freq = this.termDocs.freq();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

