/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherWarmer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;

public final class SearcherManager {
    private volatile IndexSearcher currentSearcher;
    private final ExecutorService es;
    private final SearcherWarmer warmer;
    private final Semaphore reopenLock = new Semaphore(1);

    public SearcherManager(IndexWriter indexWriter, boolean bl, final SearcherWarmer searcherWarmer, final ExecutorService executorService) throws IOException {
        this.es = executorService;
        this.warmer = searcherWarmer;
        this.currentSearcher = new IndexSearcher(IndexReader.open(indexWriter, bl));
        if (searcherWarmer != null) {
            indexWriter.getConfig().setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

                @Override
                public void warm(IndexReader indexReader) throws IOException {
                    searcherWarmer.warm(new IndexSearcher(indexReader, executorService));
                }
            });
        }
    }

    public SearcherManager(Directory directory, SearcherWarmer searcherWarmer, ExecutorService executorService) throws IOException {
        this.es = executorService;
        this.warmer = searcherWarmer;
        this.currentSearcher = new IndexSearcher(IndexReader.open(directory, true), executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeReopen() throws IOException {
        this.ensureOpen();
        if (this.reopenLock.tryAcquire()) {
            try {
                IndexReader indexReader = IndexReader.openIfChanged(this.currentSearcher.getIndexReader());
                if (indexReader != null) {
                    IndexSearcher indexSearcher = new IndexSearcher(indexReader, this.es);
                    boolean bl = false;
                    try {
                        if (this.warmer != null) {
                            this.warmer.warm(indexSearcher);
                        }
                        this.swapSearcher(indexSearcher);
                        bl = true;
                    }
                    finally {
                        if (!bl) {
                            this.release(indexSearcher);
                        }
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.reopenLock.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSearcherCurrent() throws CorruptIndexException, IOException {
        IndexSearcher indexSearcher = this.acquire();
        try {
            boolean bl = indexSearcher.getIndexReader().isCurrent();
            return bl;
        }
        finally {
            this.release(indexSearcher);
        }
    }

    public void release(IndexSearcher indexSearcher) throws IOException {
        assert (indexSearcher != null);
        indexSearcher.getIndexReader().decRef();
    }

    public synchronized void close() throws IOException {
        if (this.currentSearcher != null) {
            this.swapSearcher(null);
        }
    }

    public IndexSearcher acquire() {
        IndexSearcher indexSearcher;
        do {
            if ((indexSearcher = this.currentSearcher) != null) continue;
            throw new AlreadyClosedException("this SearcherManager is closed");
        } while (!indexSearcher.getIndexReader().tryIncRef());
        return indexSearcher;
    }

    private void ensureOpen() {
        if (this.currentSearcher == null) {
            throw new AlreadyClosedException("this SearcherManager is closed");
        }
    }

    private synchronized void swapSearcher(IndexSearcher indexSearcher) throws IOException {
        this.ensureOpen();
        IndexSearcher indexSearcher2 = this.currentSearcher;
        this.currentSearcher = indexSearcher;
        this.release(indexSearcher2);
    }
}

