/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public class QueryWrapperFilter
extends Filter {
    private Query query;

    public QueryWrapperFilter(Query query) {
        this.query = query;
    }

    @Override
    public DocIdSet getDocIdSet(final IndexReader indexReader) throws IOException {
        final Weight weight = new IndexSearcher(indexReader).createNormalizedWeight(this.query);
        return new DocIdSet(){

            @Override
            public DocIdSetIterator iterator() throws IOException {
                return weight.scorer(indexReader, true, false);
            }

            @Override
            public boolean isCacheable() {
                return false;
            }
        };
    }

    public String toString() {
        return "QueryWrapperFilter(" + this.query + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof QueryWrapperFilter)) {
            return false;
        }
        return this.query.equals(((QueryWrapperFilter)object).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x923F64B9;
    }
}

