/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixTermEnum;
import org.apache.lucene.util.ToStringUtils;

public class PrefixQuery
extends MultiTermQuery {
    private Term prefix;

    public PrefixQuery(Term term) {
        this.prefix = term;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader indexReader) throws IOException {
        return new PrefixTermEnum(indexReader, this.prefix);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.prefix.field().equals(string)) {
            stringBuilder.append(this.prefix.field());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.prefix.text());
        stringBuilder.append('*');
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.prefix == null ? 0 : this.prefix.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrefixQuery prefixQuery = (PrefixQuery)object;
        return !(this.prefix == null ? prefixQuery.prefix != null : !this.prefix.equals(prefixQuery.prefix));
    }
}

