/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoringRewrite;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopTermsRewrite;

public abstract class MultiTermQuery
extends Query {
    protected RewriteMethod rewriteMethod = CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    transient int numberOfTerms = 0;
    public static final RewriteMethod CONSTANT_SCORE_FILTER_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) {
            ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery(new MultiTermQueryWrapperFilter<MultiTermQuery>(multiTermQuery));
            constantScoreQuery.setBoost(multiTermQuery.getBoost());
            return constantScoreQuery;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_FILTER_REWRITE;
        }
    };
    public static final RewriteMethod SCORING_BOOLEAN_QUERY_REWRITE = ScoringRewrite.SCORING_BOOLEAN_QUERY_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = ScoringRewrite.CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_AUTO_REWRITE_DEFAULT = new ConstantScoreAutoRewrite(){

        @Override
        public void setTermCountCutoff(int n) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        @Override
        public void setDocCountPercent(double d) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
        }
    };

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    @Deprecated
    public int getTotalNumberOfTerms() {
        return this.numberOfTerms;
    }

    @Deprecated
    public void clearTotalNumberOfTerms() {
        this.numberOfTerms = 0;
    }

    @Deprecated
    protected void incTotalNumberOfTerms(int n) {
        this.numberOfTerms += n;
    }

    @Override
    public final Query rewrite(IndexReader indexReader) throws IOException {
        return this.rewriteMethod.rewrite(indexReader, this);
    }

    public RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    public void setRewriteMethod(RewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.getBoost());
        n = 31 * n;
        return n += this.rewriteMethod.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiTermQuery multiTermQuery = (MultiTermQuery)object;
        if (Float.floatToIntBits(this.getBoost()) != Float.floatToIntBits(multiTermQuery.getBoost())) {
            return false;
        }
        return this.rewriteMethod.equals(multiTermQuery.rewriteMethod);
    }

    public static class ConstantScoreAutoRewrite
    extends org.apache.lucene.search.ConstantScoreAutoRewrite {
    }

    public static final class TopTermsBoostOnlyBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery> {
        public TopTermsBoostOnlyBooleanQueryRewrite(int n) {
            super(n);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery getTopLevelQuery() {
            return new BooleanQuery(true);
        }

        @Override
        protected void addClause(BooleanQuery booleanQuery, Term term, float f) {
            ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery(new TermQuery(term));
            constantScoreQuery.setBoost(f);
            booleanQuery.add(constantScoreQuery, BooleanClause.Occur.SHOULD);
        }
    }

    public static final class TopTermsScoringBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery> {
        public TopTermsScoringBooleanQueryRewrite(int n) {
            super(n);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery getTopLevelQuery() {
            return new BooleanQuery(true);
        }

        @Override
        protected void addClause(BooleanQuery booleanQuery, Term term, float f) {
            TermQuery termQuery = new TermQuery(term);
            termQuery.setBoost(f);
            booleanQuery.add(termQuery, BooleanClause.Occur.SHOULD);
        }
    }

    public static abstract class RewriteMethod
    implements Serializable {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;
    }
}

