/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ToStringUtils;

public class MultiPhraseQuery
extends Query {
    private String field;
    private ArrayList<Term[]> termArrays = new ArrayList();
    private ArrayList<Integer> positions = new ArrayList();
    private int slop = 0;

    public void setSlop(int n) {
        this.slop = n;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] termArray) {
        int n = 0;
        if (this.positions.size() > 0) {
            n = this.positions.get(this.positions.size() - 1) + 1;
        }
        this.add(termArray, n);
    }

    public void add(Term[] termArray, int n) {
        if (this.termArrays.size() == 0) {
            this.field = termArray[0].field();
        }
        for (int i = 0; i < termArray.length; ++i) {
            if (termArray[i].field() == this.field) continue;
            throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + termArray[i]);
        }
        this.termArrays.add(termArray);
        this.positions.add(n);
    }

    public List<Term[]> getTermArrays() {
        return Collections.unmodifiableList(this.termArrays);
    }

    public int[] getPositions() {
        int[] nArray = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            nArray[i] = this.positions.get(i);
        }
        return nArray;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        for (Term[] termArray : this.termArrays) {
            for (Term term : termArray) {
                set.add(term);
            }
        }
    }

    @Override
    public Query rewrite(IndexReader indexReader) {
        if (this.termArrays.size() == 1) {
            Term[] termArray = this.termArrays.get(0);
            BooleanQuery booleanQuery = new BooleanQuery(true);
            for (int i = 0; i < termArray.length; ++i) {
                booleanQuery.add(new TermQuery(termArray[i]), BooleanClause.Occur.SHOULD);
            }
            booleanQuery.setBoost(this.getBoost());
            return booleanQuery;
        }
        return this;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new MultiPhraseWeight(searcher);
    }

    @Override
    public final String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.field == null || !this.field.equals(string)) {
            stringBuilder.append(this.field);
            stringBuilder.append(":");
        }
        stringBuilder.append("\"");
        Iterator<Term[]> iterator = this.termArrays.iterator();
        while (iterator.hasNext()) {
            Term[] termArray = iterator.next();
            if (termArray.length > 1) {
                stringBuilder.append("(");
                for (int i = 0; i < termArray.length; ++i) {
                    stringBuilder.append(termArray[i].text());
                    if (i >= termArray.length - 1) continue;
                    stringBuilder.append(" ");
                }
                stringBuilder.append(")");
            } else {
                stringBuilder.append(termArray[0].text());
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append("\"");
        if (this.slop != 0) {
            stringBuilder.append("~");
            stringBuilder.append(this.slop);
        }
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MultiPhraseQuery)) {
            return false;
        }
        MultiPhraseQuery multiPhraseQuery = (MultiPhraseQuery)object;
        return this.getBoost() == multiPhraseQuery.getBoost() && this.slop == multiPhraseQuery.slop && this.termArraysEquals(this.termArrays, multiPhraseQuery.termArrays) && this.positions.equals(multiPhraseQuery.positions);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.slop ^ this.termArraysHashCode() ^ this.positions.hashCode() ^ 0x4AC65113;
    }

    private int termArraysHashCode() {
        int n = 1;
        for (Object[] objectArray : this.termArrays) {
            n = 31 * n + (objectArray == null ? 0 : Arrays.hashCode(objectArray));
        }
        return n;
    }

    private boolean termArraysEquals(List<Term[]> list, List<Term[]> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        ListIterator<Term[]> listIterator = list.listIterator();
        ListIterator<Term[]> listIterator2 = list2.listIterator();
        while (listIterator.hasNext()) {
            Object[] objectArray = listIterator.next();
            Object[] objectArray2 = listIterator2.next();
            if (objectArray != null ? Arrays.equals(objectArray, objectArray2) : objectArray2 == null) continue;
            return false;
        }
        return true;
    }

    private class MultiPhraseWeight
    extends Weight {
        private Similarity similarity;
        private float value;
        private final Explanation.IDFExplanation idfExp;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public MultiPhraseWeight(Searcher searcher) throws IOException {
            this.similarity = MultiPhraseQuery.this.getSimilarity(searcher);
            ArrayList<Term> arrayList = new ArrayList<Term>();
            Iterator iterator = MultiPhraseQuery.this.termArrays.iterator();
            while (iterator.hasNext()) {
                Term[] termArray;
                for (Term term : termArray = (Term[])iterator.next()) {
                    arrayList.add(term);
                }
            }
            this.idfExp = this.similarity.idfExplain(arrayList, searcher);
            this.idf = this.idfExp.getIdf();
        }

        @Override
        public Query getQuery() {
            return MultiPhraseQuery.this;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public float sumOfSquaredWeights() {
            this.queryWeight = this.idf * MultiPhraseQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= f;
            this.value = this.queryWeight * this.idf;
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            if (MultiPhraseQuery.this.termArrays.size() == 0) {
                return null;
            }
            Comparable[] comparableArray = new PhraseQuery.PostingsAndFreq[MultiPhraseQuery.this.termArrays.size()];
            for (int i = 0; i < comparableArray.length; ++i) {
                int n;
                TermPositions termPositions;
                Term[] termArray = (Term[])MultiPhraseQuery.this.termArrays.get(i);
                if (termArray.length > 1) {
                    termPositions = new MultipleTermPositions(indexReader, termArray);
                    n = 0;
                    for (int j = 0; j < termArray.length; ++j) {
                        n += indexReader.docFreq(termArray[j]);
                    }
                } else {
                    termPositions = indexReader.termPositions(termArray[0]);
                    n = indexReader.docFreq(termArray[0]);
                    if (termPositions == null) {
                        return null;
                    }
                }
                comparableArray[i] = new PhraseQuery.PostingsAndFreq(termPositions, n, (Integer)MultiPhraseQuery.this.positions.get(i), termArray[0]);
            }
            if (MultiPhraseQuery.this.slop == 0) {
                ArrayUtil.mergeSort((Comparable[])comparableArray);
            }
            if (MultiPhraseQuery.this.slop == 0) {
                ExactPhraseScorer exactPhraseScorer = new ExactPhraseScorer(this, (PhraseQuery.PostingsAndFreq[])comparableArray, this.similarity, indexReader.norms(MultiPhraseQuery.this.field));
                if (exactPhraseScorer.noDocs) {
                    return null;
                }
                return exactPhraseScorer;
            }
            return new SloppyPhraseScorer(this, (PhraseQuery.PostingsAndFreq[])comparableArray, this.similarity, MultiPhraseQuery.this.slop, indexReader.norms(MultiPhraseQuery.this.field));
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            ComplexExplanation complexExplanation = new ComplexExplanation();
            complexExplanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
            Explanation explanation = new Explanation(this.idf, "idf(" + MultiPhraseQuery.this.field + ":" + this.idfExp.explain() + ")");
            Explanation explanation2 = new Explanation();
            explanation2.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation explanation3 = new Explanation(MultiPhraseQuery.this.getBoost(), "boost");
            if (MultiPhraseQuery.this.getBoost() != 1.0f) {
                explanation2.addDetail(explanation3);
            }
            explanation2.addDetail(explanation);
            Explanation explanation4 = new Explanation(this.queryNorm, "queryNorm");
            explanation2.addDetail(explanation4);
            explanation2.setValue(explanation3.getValue() * explanation.getValue() * explanation4.getValue());
            complexExplanation.addDetail(explanation2);
            ComplexExplanation complexExplanation2 = new ComplexExplanation();
            complexExplanation2.setDescription("fieldWeight(" + this.getQuery() + " in " + n + "), product of:");
            Scorer scorer = this.scorer(indexReader, true, false);
            if (scorer == null) {
                return new Explanation(0.0f, "no matching docs");
            }
            Explanation explanation5 = new Explanation();
            int n2 = scorer.advance(n);
            float f = n2 == n ? scorer.freq() : 0.0f;
            explanation5.setValue(this.similarity.tf(f));
            explanation5.setDescription("tf(phraseFreq=" + f + ")");
            complexExplanation2.addDetail(explanation5);
            complexExplanation2.addDetail(explanation);
            Explanation explanation6 = new Explanation();
            byte[] byArray = indexReader.norms(MultiPhraseQuery.this.field);
            float f2 = byArray != null ? this.similarity.decodeNormValue(byArray[n]) : 1.0f;
            explanation6.setValue(f2);
            explanation6.setDescription("fieldNorm(field=" + MultiPhraseQuery.this.field + ", doc=" + n + ")");
            complexExplanation2.addDetail(explanation6);
            complexExplanation2.setMatch(explanation5.isMatch());
            complexExplanation2.setValue(explanation5.getValue() * explanation.getValue() * explanation6.getValue());
            complexExplanation.addDetail(complexExplanation2);
            complexExplanation.setMatch(complexExplanation2.getMatch());
            complexExplanation.setValue(explanation2.getValue() * complexExplanation2.getValue());
            if (explanation2.getValue() == 1.0f) {
                return complexExplanation2;
            }
            return complexExplanation;
        }
    }
}

