/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;

public abstract class FieldComparator<T> {
    public abstract int compare(int var1, int var2);

    public abstract void setBottom(int var1);

    public abstract int compareBottom(int var1) throws IOException;

    public abstract void copy(int var1, int var2) throws IOException;

    public abstract void setNextReader(IndexReader var1, int var2) throws IOException;

    public void setScorer(Scorer scorer) {
    }

    public abstract T value(int var1);

    public int compareValues(T t, T t2) {
        if (t == null) {
            if (t2 == null) {
                return 0;
            }
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        return ((Comparable)t).compareTo(t2);
    }

    protected static final int binarySearch(String[] stringArray, String string) {
        return FieldComparator.binarySearch(stringArray, string, 0, stringArray.length - 1);
    }

    protected static final int binarySearch(String[] stringArray, String string, int n, int n2) {
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            String string2 = stringArray[n3];
            int n4 = string2 != null ? string2.compareTo(string) : -1;
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static final class StringValComparator
    extends FieldComparator<String> {
        private String[] values;
        private String[] currentReaderValues;
        private final String field;
        private String bottom;

        StringValComparator(int n, String string) {
            this.values = new String[n];
            this.field = string;
        }

        @Override
        public int compare(int n, int n2) {
            String string = this.values[n];
            String string2 = this.values[n2];
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }

        @Override
        public int compareBottom(int n) {
            String string = this.currentReaderValues[n];
            if (this.bottom == null) {
                if (string == null) {
                    return 0;
                }
                return -1;
            }
            if (string == null) {
                return 1;
            }
            return this.bottom.compareTo(string);
        }

        @Override
        public void copy(int n, int n2) {
            this.values[n] = this.currentReaderValues[n2];
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(indexReader, this.field);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public String value(int n) {
            return this.values[n];
        }

        @Override
        public int compareValues(String string, String string2) {
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    public static final class StringOrdValComparator
    extends FieldComparator<String> {
        private final int[] ords;
        private final String[] values;
        private final int[] readerGen;
        private int currentReaderGen = -1;
        private String[] lookup;
        private int[] order;
        private final String field;
        private int bottomSlot = -1;
        private int bottomOrd;
        private boolean bottomSameReader;
        private String bottomValue;

        public StringOrdValComparator(int n, String string, int n2, boolean bl) {
            this.ords = new int[n];
            this.values = new String[n];
            this.readerGen = new int[n];
            this.field = string;
        }

        @Override
        public int compare(int n, int n2) {
            if (this.readerGen[n] == this.readerGen[n2]) {
                return this.ords[n] - this.ords[n2];
            }
            String string = this.values[n];
            String string2 = this.values[n2];
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }

        @Override
        public int compareBottom(int n) {
            assert (this.bottomSlot != -1);
            if (this.bottomSameReader) {
                return this.bottomOrd - this.order[n];
            }
            int n2 = this.order[n];
            int n3 = this.bottomOrd - n2;
            if (n3 != 0) {
                return n3;
            }
            String string = this.lookup[n2];
            if (this.bottomValue == null) {
                if (string == null) {
                    return 0;
                }
                return -1;
            }
            if (string == null) {
                return 1;
            }
            return this.bottomValue.compareTo(string);
        }

        @Override
        public void copy(int n, int n2) {
            int n3;
            this.ords[n] = n3 = this.order[n2];
            assert (n3 >= 0);
            this.values[n] = this.lookup[n3];
            this.readerGen[n] = this.currentReaderGen;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            FieldCache.StringIndex stringIndex = FieldCache.DEFAULT.getStringIndex(indexReader, this.field);
            ++this.currentReaderGen;
            this.order = stringIndex.order;
            this.lookup = stringIndex.lookup;
            assert (this.lookup.length > 0);
            if (this.bottomSlot != -1) {
                this.setBottom(this.bottomSlot);
            }
        }

        @Override
        public void setBottom(int n) {
            this.bottomSlot = n;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                this.ords[this.bottomSlot] = 0;
                this.bottomOrd = 0;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int n2 = StringOrdValComparator.binarySearch(this.lookup, this.bottomValue);
                if (n2 < 0) {
                    this.bottomOrd = -n2 - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = n2;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        @Override
        public String value(int n) {
            return this.values[n];
        }

        @Override
        public int compareValues(String string, String string2) {
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }

        public String[] getValues() {
            return this.values;
        }

        public int getBottomSlot() {
            return this.bottomSlot;
        }

        public String getField() {
            return this.field;
        }
    }

    public static final class StringComparatorLocale
    extends FieldComparator<String> {
        private final String[] values;
        private String[] currentReaderValues;
        private final String field;
        final Collator collator;
        private String bottom;

        StringComparatorLocale(int n, String string, Locale locale) {
            this.values = new String[n];
            this.field = string;
            this.collator = Collator.getInstance(locale);
        }

        @Override
        public int compare(int n, int n2) {
            String string = this.values[n];
            String string2 = this.values[n2];
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return this.collator.compare(string, string2);
        }

        @Override
        public int compareBottom(int n) {
            String string = this.currentReaderValues[n];
            if (this.bottom == null) {
                if (string == null) {
                    return 0;
                }
                return -1;
            }
            if (string == null) {
                return 1;
            }
            return this.collator.compare(this.bottom, string);
        }

        @Override
        public void copy(int n, int n2) {
            this.values[n] = this.currentReaderValues[n2];
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(indexReader, this.field);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public String value(int n) {
            return this.values[n];
        }

        @Override
        public int compareValues(String string, String string2) {
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return this.collator.compare(string, string2);
        }
    }

    public static final class ShortComparator
    extends NumericComparator<Short> {
        private final short[] values;
        private final FieldCache.ShortParser parser;
        private short[] currentReaderValues;
        private short bottom;

        ShortComparator(int n, String string, FieldCache.Parser parser, Short s) {
            super(string, s);
            this.values = new short[n];
            this.parser = (FieldCache.ShortParser)parser;
        }

        @Override
        public int compare(int n, int n2) {
            return this.values[n] - this.values[n2];
        }

        @Override
        public int compareBottom(int n) {
            short s = this.currentReaderValues[n];
            if (this.docsWithField != null && s == 0 && !this.docsWithField.get(n)) {
                s = (Short)this.missingValue;
            }
            return this.bottom - s;
        }

        @Override
        public void copy(int n, int n2) {
            short s = this.currentReaderValues[n2];
            if (this.docsWithField != null && s == 0 && !this.docsWithField.get(n2)) {
                s = (Short)this.missingValue;
            }
            this.values[n] = s;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getShorts(indexReader, this.field, this.parser, this.missingValue != null);
            super.setNextReader(indexReader, n);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public Short value(int n) {
            return this.values[n];
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator<Float> {
        private final float[] scores;
        private float bottom;
        private Scorer scorer;

        RelevanceComparator(int n) {
            this.scores = new float[n];
        }

        @Override
        public int compare(int n, int n2) {
            float f = this.scores[n];
            float f2 = this.scores[n2];
            return f > f2 ? -1 : (f < f2 ? 1 : 0);
        }

        @Override
        public int compareBottom(int n) throws IOException {
            float f = this.scorer.score();
            return this.bottom > f ? -1 : (this.bottom < f ? 1 : 0);
        }

        @Override
        public void copy(int n, int n2) throws IOException {
            this.scores[n] = this.scorer.score();
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) {
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.scores[n];
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = !(scorer instanceof ScoreCachingWrappingScorer) ? new ScoreCachingWrappingScorer(scorer) : scorer;
        }

        @Override
        public Float value(int n) {
            return Float.valueOf(this.scores[n]);
        }

        @Override
        public int compareValues(Float f, Float f2) {
            return f2.compareTo(f);
        }
    }

    public static final class LongComparator
    extends NumericComparator<Long> {
        private final long[] values;
        private final FieldCache.LongParser parser;
        private long[] currentReaderValues;
        private long bottom;

        LongComparator(int n, String string, FieldCache.Parser parser, Long l) {
            super(string, l);
            this.values = new long[n];
            this.parser = (FieldCache.LongParser)parser;
        }

        @Override
        public int compare(int n, int n2) {
            long l = this.values[n];
            long l2 = this.values[n2];
            if (l > l2) {
                return 1;
            }
            if (l < l2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int n) {
            long l = this.currentReaderValues[n];
            if (this.docsWithField != null && l == 0L && !this.docsWithField.get(n)) {
                l = (Long)this.missingValue;
            }
            if (this.bottom > l) {
                return 1;
            }
            if (this.bottom < l) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int n, int n2) {
            long l = this.currentReaderValues[n2];
            if (this.docsWithField != null && l == 0L && !this.docsWithField.get(n2)) {
                l = (Long)this.missingValue;
            }
            this.values[n] = l;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getLongs(indexReader, this.field, this.parser, this.missingValue != null);
            super.setNextReader(indexReader, n);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public Long value(int n) {
            return this.values[n];
        }
    }

    public static final class IntComparator
    extends NumericComparator<Integer> {
        private final int[] values;
        private final FieldCache.IntParser parser;
        private int[] currentReaderValues;
        private int bottom;

        IntComparator(int n, String string, FieldCache.Parser parser, Integer n2) {
            super(string, n2);
            this.values = new int[n];
            this.parser = (FieldCache.IntParser)parser;
        }

        @Override
        public int compare(int n, int n2) {
            int n3 = this.values[n];
            int n4 = this.values[n2];
            if (n3 > n4) {
                return 1;
            }
            if (n3 < n4) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int n) {
            int n2 = this.currentReaderValues[n];
            if (this.docsWithField != null && n2 == 0 && !this.docsWithField.get(n)) {
                n2 = (Integer)this.missingValue;
            }
            if (this.bottom > n2) {
                return 1;
            }
            if (this.bottom < n2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int n, int n2) {
            int n3 = this.currentReaderValues[n2];
            if (this.docsWithField != null && n3 == 0 && !this.docsWithField.get(n2)) {
                n3 = (Integer)this.missingValue;
            }
            this.values[n] = n3;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getInts(indexReader, this.field, this.parser, this.missingValue != null);
            super.setNextReader(indexReader, n);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public Integer value(int n) {
            return this.values[n];
        }
    }

    public static final class FloatComparator
    extends NumericComparator<Float> {
        private final float[] values;
        private final FieldCache.FloatParser parser;
        private float[] currentReaderValues;
        private float bottom;

        FloatComparator(int n, String string, FieldCache.Parser parser, Float f) {
            super(string, f);
            this.values = new float[n];
            this.parser = (FieldCache.FloatParser)parser;
        }

        @Override
        public int compare(int n, int n2) {
            float f = this.values[n];
            float f2 = this.values[n2];
            if (f > f2) {
                return 1;
            }
            if (f < f2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int n) {
            float f = this.currentReaderValues[n];
            if (this.docsWithField != null && f == 0.0f && !this.docsWithField.get(n)) {
                f = ((Float)this.missingValue).floatValue();
            }
            if (this.bottom > f) {
                return 1;
            }
            if (this.bottom < f) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int n, int n2) {
            float f = this.currentReaderValues[n2];
            if (this.docsWithField != null && f == 0.0f && !this.docsWithField.get(n2)) {
                f = ((Float)this.missingValue).floatValue();
            }
            this.values[n] = f;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getFloats(indexReader, this.field, this.parser, this.missingValue != null);
            super.setNextReader(indexReader, n);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public Float value(int n) {
            return Float.valueOf(this.values[n]);
        }
    }

    public static final class DoubleComparator
    extends NumericComparator<Double> {
        private final double[] values;
        private final FieldCache.DoubleParser parser;
        private double[] currentReaderValues;
        private double bottom;

        DoubleComparator(int n, String string, FieldCache.Parser parser, Double d) {
            super(string, d);
            this.values = new double[n];
            this.parser = (FieldCache.DoubleParser)parser;
        }

        @Override
        public int compare(int n, int n2) {
            double d = this.values[n];
            double d2 = this.values[n2];
            if (d > d2) {
                return 1;
            }
            if (d < d2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int n) {
            double d = this.currentReaderValues[n];
            if (this.docsWithField != null && d == 0.0 && !this.docsWithField.get(n)) {
                d = (Double)this.missingValue;
            }
            if (this.bottom > d) {
                return 1;
            }
            if (this.bottom < d) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int n, int n2) {
            double d = this.currentReaderValues[n2];
            if (this.docsWithField != null && d == 0.0 && !this.docsWithField.get(n2)) {
                d = (Double)this.missingValue;
            }
            this.values[n] = d;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getDoubles(indexReader, this.field, this.parser, this.missingValue != null);
            super.setNextReader(indexReader, n);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public Double value(int n) {
            return this.values[n];
        }
    }

    public static final class DocComparator
    extends FieldComparator<Integer> {
        private final int[] docIDs;
        private int docBase;
        private int bottom;

        DocComparator(int n) {
            this.docIDs = new int[n];
        }

        @Override
        public int compare(int n, int n2) {
            return this.docIDs[n] - this.docIDs[n2];
        }

        @Override
        public int compareBottom(int n) {
            return this.bottom - (this.docBase + n);
        }

        @Override
        public void copy(int n, int n2) {
            this.docIDs[n] = this.docBase + n2;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) {
            this.docBase = n;
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.docIDs[n];
        }

        @Override
        public Integer value(int n) {
            return this.docIDs[n];
        }
    }

    public static final class ByteComparator
    extends NumericComparator<Byte> {
        private final byte[] values;
        private final FieldCache.ByteParser parser;
        private byte[] currentReaderValues;
        private byte bottom;

        ByteComparator(int n, String string, FieldCache.Parser parser, Byte by) {
            super(string, by);
            this.values = new byte[n];
            this.parser = (FieldCache.ByteParser)parser;
        }

        @Override
        public int compare(int n, int n2) {
            return this.values[n] - this.values[n2];
        }

        @Override
        public int compareBottom(int n) {
            byte by = this.currentReaderValues[n];
            if (this.docsWithField != null && by == 0 && !this.docsWithField.get(n)) {
                by = (Byte)this.missingValue;
            }
            return this.bottom - by;
        }

        @Override
        public void copy(int n, int n2) {
            byte by = this.currentReaderValues[n2];
            if (this.docsWithField != null && by == 0 && !this.docsWithField.get(n2)) {
                by = (Byte)this.missingValue;
            }
            this.values[n] = by;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getBytes(indexReader, this.field, this.parser, this.missingValue != null);
            super.setNextReader(indexReader, n);
        }

        @Override
        public void setBottom(int n) {
            this.bottom = this.values[n];
        }

        @Override
        public Byte value(int n) {
            return this.values[n];
        }
    }

    public static abstract class NumericComparator<T extends Number>
    extends FieldComparator<T> {
        protected final T missingValue;
        protected final String field;
        protected Bits docsWithField;

        public NumericComparator(String string, T t) {
            this.field = string;
            this.missingValue = t;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            if (this.missingValue != null) {
                this.docsWithField = FieldCache.DEFAULT.getDocsWithField(indexReader, this.field);
                if (this.docsWithField instanceof Bits.MatchAllBits) {
                    this.docsWithField = null;
                }
            } else {
                this.docsWithField = null;
            }
        }
    }
}

