/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private ArrayList<Query> disjuncts = new ArrayList();
    private float tieBreakerMultiplier = 0.0f;

    public DisjunctionMaxQuery(float f) {
        this.tieBreakerMultiplier = f;
    }

    public DisjunctionMaxQuery(Collection<Query> collection, float f) {
        this.tieBreakerMultiplier = f;
        this.add(collection);
    }

    public void add(Query query) {
        this.disjuncts.add(query);
    }

    public void add(Collection<Query> collection) {
        this.disjuncts.addAll(collection);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.disjuncts.iterator();
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new DisjunctionMaxWeight(searcher);
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        int n = this.disjuncts.size();
        if (n == 1) {
            Query query = this.disjuncts.get(0);
            Query query2 = query.rewrite(indexReader);
            if (this.getBoost() != 1.0f) {
                if (query2 == query) {
                    query2 = (Query)query2.clone();
                }
                query2.setBoost(this.getBoost() * query2.getBoost());
            }
            return query2;
        }
        DisjunctionMaxQuery disjunctionMaxQuery = null;
        for (int i = 0; i < n; ++i) {
            Query query = this.disjuncts.get(i);
            Query query3 = query.rewrite(indexReader);
            if (query3 == query) continue;
            if (disjunctionMaxQuery == null) {
                disjunctionMaxQuery = (DisjunctionMaxQuery)this.clone();
            }
            disjunctionMaxQuery.disjuncts.set(i, query3);
        }
        if (disjunctionMaxQuery != null) {
            return disjunctionMaxQuery;
        }
        return this;
    }

    @Override
    public Object clone() {
        DisjunctionMaxQuery disjunctionMaxQuery = (DisjunctionMaxQuery)super.clone();
        disjunctionMaxQuery.disjuncts = (ArrayList)this.disjuncts.clone();
        return disjunctionMaxQuery;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        for (Query query : this.disjuncts) {
            query.extractTerms(set);
        }
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        int n = this.disjuncts.size();
        for (int i = 0; i < n; ++i) {
            Query query = this.disjuncts.get(i);
            if (query instanceof BooleanQuery) {
                stringBuilder.append("(");
                stringBuilder.append(query.toString(string));
                stringBuilder.append(")");
            } else {
                stringBuilder.append(query.toString(string));
            }
            if (i == n - 1) continue;
            stringBuilder.append(" | ");
        }
        stringBuilder.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            stringBuilder.append("~");
            stringBuilder.append(this.tieBreakerMultiplier);
        }
        if ((double)this.getBoost() != 1.0) {
            stringBuilder.append("^");
            stringBuilder.append(this.getBoost());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery disjunctionMaxQuery = (DisjunctionMaxQuery)object;
        return this.getBoost() == disjunctionMaxQuery.getBoost() && this.tieBreakerMultiplier == disjunctionMaxQuery.tieBreakerMultiplier && this.disjuncts.equals(disjunctionMaxQuery.disjuncts);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) + Float.floatToIntBits(this.tieBreakerMultiplier) + this.disjuncts.hashCode();
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected Similarity similarity;
        protected ArrayList<Weight> weights = new ArrayList();

        public DisjunctionMaxWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
            for (Query query : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(query.createWeight(searcher));
            }
        }

        @Override
        public Query getQuery() {
            return DisjunctionMaxQuery.this;
        }

        @Override
        public float getValue() {
            return DisjunctionMaxQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float f = 0.0f;
            float f2 = 0.0f;
            for (Weight weight : this.weights) {
                float f3 = weight.sumOfSquaredWeights();
                f2 += f3;
                f = Math.max(f, f3);
            }
            float f4 = DisjunctionMaxQuery.this.getBoost();
            return ((f2 - f) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + f) * f4 * f4;
        }

        @Override
        public void normalize(float f) {
            f *= DisjunctionMaxQuery.this.getBoost();
            for (Weight weight : this.weights) {
                weight.normalize(f);
            }
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            Scorer[] scorerArray = new Scorer[this.weights.size()];
            int n = 0;
            for (Weight weight : this.weights) {
                Scorer scorer = weight.scorer(indexReader, true, false);
                if (scorer == null || scorer.nextDoc() == Integer.MAX_VALUE) continue;
                scorerArray[n++] = scorer;
            }
            if (n == 0) {
                return null;
            }
            DisjunctionMaxScorer disjunctionMaxScorer = new DisjunctionMaxScorer(this, DisjunctionMaxQuery.this.tieBreakerMultiplier, this.similarity, scorerArray, n);
            return disjunctionMaxScorer;
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            if (DisjunctionMaxQuery.this.disjuncts.size() == 1) {
                return this.weights.get(0).explain(indexReader, n);
            }
            ComplexExplanation complexExplanation = new ComplexExplanation();
            float f = 0.0f;
            float f2 = 0.0f;
            complexExplanation.setDescription(DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:");
            for (Weight weight : this.weights) {
                Explanation explanation = weight.explain(indexReader, n);
                if (!explanation.isMatch()) continue;
                complexExplanation.setMatch(Boolean.TRUE);
                complexExplanation.addDetail(explanation);
                f2 += explanation.getValue();
                f = Math.max(f, explanation.getValue());
            }
            complexExplanation.setValue(f + (f2 - f) * DisjunctionMaxQuery.this.tieBreakerMultiplier);
            return complexExplanation;
        }
    }
}

