/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.Similarity;

public class DefaultSimilarity
extends Similarity {
    protected boolean discountOverlaps = true;

    @Override
    public float computeNorm(String string, FieldInvertState fieldInvertState) {
        int n = this.discountOverlaps ? fieldInvertState.getLength() - fieldInvertState.getNumOverlap() : fieldInvertState.getLength();
        return fieldInvertState.getBoost() * (float)(1.0 / Math.sqrt(n));
    }

    @Override
    public float queryNorm(float f) {
        return (float)(1.0 / Math.sqrt(f));
    }

    @Override
    public float tf(float f) {
        return (float)Math.sqrt(f);
    }

    @Override
    public float sloppyFreq(int n) {
        return 1.0f / (float)(n + 1);
    }

    @Override
    public float idf(int n, int n2) {
        return (float)(Math.log((double)n2 / (double)(n + 1)) + 1.0);
    }

    @Override
    public float coord(int n, int n2) {
        return (float)n / (float)n2;
    }

    public void setDiscountOverlaps(boolean bl) {
        this.discountOverlaps = bl;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }
}

