/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class ConstantScoreQuery
extends Query {
    protected final Filter filter;
    protected final Query query;

    public ConstantScoreQuery(Query query) {
        if (query == null) {
            throw new NullPointerException("Query may not be null");
        }
        this.filter = null;
        this.query = query;
    }

    public ConstantScoreQuery(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("Filter may not be null");
        }
        this.filter = filter;
        this.query = null;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        Query query;
        if (this.query != null && (query = this.query.rewrite(indexReader)) != this.query) {
            query = new ConstantScoreQuery(query);
            query.setBoost(this.getBoost());
            return query;
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        if (this.query != null) {
            this.query.extractTerms(set);
        }
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new ConstantWeight(searcher);
    }

    @Override
    public String toString(String string) {
        return "ConstantScore(" + (this.query == null ? this.filter.toString() : this.query.toString(string)) + ')' + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof ConstantScoreQuery) {
            ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)object;
            return (this.filter == null ? constantScoreQuery.filter == null : this.filter.equals(constantScoreQuery.filter)) && (this.query == null ? constantScoreQuery.query == null : this.query.equals(constantScoreQuery.query));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.query == null ? this.filter : this.query).hashCode();
    }

    protected class ConstantScorer
    extends Scorer {
        final DocIdSetIterator docIdSetIterator;
        final float theScore;

        public ConstantScorer(Similarity similarity, DocIdSetIterator docIdSetIterator, Weight weight) throws IOException {
            super(similarity, weight);
            this.theScore = weight.getValue();
            this.docIdSetIterator = docIdSetIterator;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.docIdSetIterator.nextDoc();
        }

        @Override
        public int docID() {
            return this.docIdSetIterator.docID();
        }

        @Override
        public float score() throws IOException {
            return this.theScore;
        }

        @Override
        public int advance(int n) throws IOException {
            return this.docIdSetIterator.advance(n);
        }

        private Collector wrapCollector(final Collector collector) {
            return new Collector(){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    collector.setScorer(new ConstantScorer(ConstantScorer.this.getSimilarity(), scorer, ConstantScorer.this.weight));
                }

                @Override
                public void collect(int n) throws IOException {
                    collector.collect(n);
                }

                @Override
                public void setNextReader(IndexReader indexReader, int n) throws IOException {
                    collector.setNextReader(indexReader, n);
                }

                @Override
                public boolean acceptsDocsOutOfOrder() {
                    return collector.acceptsDocsOutOfOrder();
                }
            };
        }

        @Override
        public void score(Collector collector) throws IOException {
            if (this.docIdSetIterator instanceof Scorer) {
                ((Scorer)this.docIdSetIterator).score(this.wrapCollector(collector));
            } else {
                super.score(collector);
            }
        }

        @Override
        protected boolean score(Collector collector, int n, int n2) throws IOException {
            if (this.docIdSetIterator instanceof Scorer) {
                return ((Scorer)this.docIdSetIterator).score(this.wrapCollector(collector), n, n2);
            }
            return super.score(collector, n, n2);
        }
    }

    protected class ConstantWeight
    extends Weight {
        private final Weight innerWeight;
        private final Similarity similarity;
        private float queryNorm;
        private float queryWeight;

        public ConstantWeight(Searcher searcher) throws IOException {
            this.similarity = ConstantScoreQuery.this.getSimilarity(searcher);
            this.innerWeight = ConstantScoreQuery.this.query == null ? null : ConstantScoreQuery.this.query.createWeight(searcher);
        }

        @Override
        public Query getQuery() {
            return ConstantScoreQuery.this;
        }

        @Override
        public float getValue() {
            return this.queryWeight;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            if (this.innerWeight != null) {
                this.innerWeight.sumOfSquaredWeights();
            }
            this.queryWeight = ConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= this.queryNorm;
            if (this.innerWeight != null) {
                this.innerWeight.normalize(f);
            }
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            DocIdSetIterator docIdSetIterator;
            if (ConstantScoreQuery.this.filter != null) {
                assert (ConstantScoreQuery.this.query == null);
                DocIdSet docIdSet = ConstantScoreQuery.this.filter.getDocIdSet(indexReader);
                if (docIdSet == null) {
                    return null;
                }
                docIdSetIterator = docIdSet.iterator();
            } else {
                assert (ConstantScoreQuery.this.query != null && this.innerWeight != null);
                docIdSetIterator = this.innerWeight.scorer(indexReader, bl, bl2);
            }
            if (docIdSetIterator == null) {
                return null;
            }
            return new ConstantScorer(this.similarity, docIdSetIterator, this);
        }

        @Override
        public boolean scoresDocsOutOfOrder() {
            return this.innerWeight != null ? this.innerWeight.scoresDocsOutOfOrder() : false;
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            Scorer scorer = this.scorer(indexReader, true, false);
            boolean bl = scorer != null && scorer.advance(n) == n;
            ComplexExplanation complexExplanation = new ComplexExplanation();
            if (bl) {
                complexExplanation.setDescription(ConstantScoreQuery.this.toString() + ", product of:");
                complexExplanation.setValue(this.queryWeight);
                complexExplanation.setMatch(Boolean.TRUE);
                complexExplanation.addDetail(new Explanation(ConstantScoreQuery.this.getBoost(), "boost"));
                complexExplanation.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                complexExplanation.setDescription(ConstantScoreQuery.this.toString() + " doesn't match id " + n);
                complexExplanation.setValue(0.0f);
                complexExplanation.setMatch(Boolean.FALSE);
            }
            return complexExplanation;
        }
    }
}

