/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.TermVectorsTermsWriter;
import org.apache.lucene.index.TermVectorsTermsWriterPerThread;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.UnicodeUtil;

final class TermVectorsTermsWriterPerField
extends TermsHashConsumerPerField {
    final TermVectorsTermsWriterPerThread perThread;
    final TermsHashPerField termsHashPerField;
    final TermVectorsTermsWriter termsWriter;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;
    boolean doVectors;
    boolean doVectorPositions;
    boolean doVectorOffsets;
    int maxNumPostings;
    OffsetAttribute offsetAttribute = null;

    public TermVectorsTermsWriterPerField(TermsHashPerField termsHashPerField, TermVectorsTermsWriterPerThread termVectorsTermsWriterPerThread, FieldInfo fieldInfo) {
        this.termsHashPerField = termsHashPerField;
        this.perThread = termVectorsTermsWriterPerThread;
        this.termsWriter = termVectorsTermsWriterPerThread.termsWriter;
        this.fieldInfo = fieldInfo;
        this.docState = termsHashPerField.docState;
        this.fieldState = termsHashPerField.fieldState;
    }

    @Override
    int getStreamCount() {
        return 2;
    }

    @Override
    boolean start(Fieldable[] fieldableArray, int n) {
        this.doVectors = false;
        this.doVectorPositions = false;
        this.doVectorOffsets = false;
        for (int i = 0; i < n; ++i) {
            Fieldable fieldable = fieldableArray[i];
            if (!fieldable.isIndexed() || !fieldable.isTermVectorStored()) continue;
            this.doVectors = true;
            this.doVectorPositions |= fieldable.isStorePositionWithTermVector();
            this.doVectorOffsets |= fieldable.isStoreOffsetWithTermVector();
        }
        if (this.doVectors) {
            if (this.perThread.doc == null) {
                this.perThread.doc = this.termsWriter.getPerDoc();
                this.perThread.doc.docID = this.docState.docID;
                assert (this.perThread.doc.numVectorFields == 0);
                assert (0L == this.perThread.doc.perDocTvf.length());
                assert (0L == this.perThread.doc.perDocTvf.getFilePointer());
            }
            assert (this.perThread.doc.docID == this.docState.docID);
            if (this.termsHashPerField.numPostings != 0) {
                this.termsHashPerField.reset();
                this.perThread.termsHashPerThread.reset(false);
            }
        }
        return this.doVectors;
    }

    public void abort() {
    }

    @Override
    void finish() throws IOException {
        assert (this.docState.testPoint("TermVectorsTermsWriterPerField.finish start"));
        int n = this.termsHashPerField.numPostings;
        assert (n >= 0);
        if (!this.doVectors || n == 0) {
            return;
        }
        if (n > this.maxNumPostings) {
            this.maxNumPostings = n;
        }
        RAMOutputStream rAMOutputStream = this.perThread.doc.perDocTvf;
        assert (this.fieldInfo.storeTermVector);
        assert (this.perThread.vectorFieldsInOrder(this.fieldInfo));
        this.perThread.doc.addField(this.termsHashPerField.fieldInfo.number);
        TermVectorsPostingsArray termVectorsPostingsArray = (TermVectorsPostingsArray)this.termsHashPerField.postingsArray;
        int[] nArray = this.termsHashPerField.sortPostings();
        rAMOutputStream.writeVInt(n);
        byte by = 0;
        if (this.doVectorPositions) {
            by = (byte)(by | 1);
        }
        if (this.doVectorOffsets) {
            by = (byte)(by | 2);
        }
        ((DataOutput)rAMOutputStream).writeByte(by);
        int n2 = 0;
        int n3 = 0;
        ByteSliceReader byteSliceReader = this.perThread.vectorSliceReader;
        char[][] cArray = this.perThread.termsHashPerThread.charPool.buffers;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5 = nArray[i];
            int n6 = termVectorsPostingsArray.freqs[n5];
            char[] cArray2 = cArray[termVectorsPostingsArray.textStarts[n5] >> 14];
            int n7 = termVectorsPostingsArray.textStarts[n5] & 0x3FFF;
            UnicodeUtil.UTF8Result uTF8Result = this.perThread.utf8Results[n2];
            UnicodeUtil.UTF16toUTF8(cArray2, n7, uTF8Result);
            int n8 = uTF8Result.length;
            if (i > 0) {
                byte[] byArray = this.perThread.utf8Results[1 - n2].result;
                byte[] byArray2 = this.perThread.utf8Results[n2].result;
                for (n4 = 0; n4 < n3 && n4 < n8 && byArray[n4] == byArray2[n4]; ++n4) {
                }
            }
            n2 = 1 - n2;
            n3 = n8;
            int n9 = n8 - n4;
            rAMOutputStream.writeVInt(n4);
            rAMOutputStream.writeVInt(n9);
            ((DataOutput)rAMOutputStream).writeBytes(uTF8Result.result, n4, n9);
            rAMOutputStream.writeVInt(n6);
            if (this.doVectorPositions) {
                this.termsHashPerField.initReader(byteSliceReader, n5, 0);
                byteSliceReader.writeTo(rAMOutputStream);
            }
            if (!this.doVectorOffsets) continue;
            this.termsHashPerField.initReader(byteSliceReader, n5, 1);
            byteSliceReader.writeTo(rAMOutputStream);
        }
        this.termsHashPerField.reset();
        this.perThread.termsHashPerThread.reset(false);
    }

    void shrinkHash() {
        this.termsHashPerField.shrinkHash(this.maxNumPostings);
        this.maxNumPostings = 0;
    }

    @Override
    void start(Fieldable fieldable) {
        this.offsetAttribute = this.doVectorOffsets ? this.fieldState.attributeSource.addAttribute(OffsetAttribute.class) : null;
    }

    @Override
    void newTerm(int n) {
        assert (this.docState.testPoint("TermVectorsTermsWriterPerField.newTerm start"));
        TermVectorsPostingsArray termVectorsPostingsArray = (TermVectorsPostingsArray)this.termsHashPerField.postingsArray;
        termVectorsPostingsArray.freqs[n] = 1;
        if (this.doVectorOffsets) {
            int n2 = this.fieldState.offset + this.offsetAttribute.startOffset();
            int n3 = this.fieldState.offset + this.offsetAttribute.endOffset();
            this.termsHashPerField.writeVInt(1, n2);
            this.termsHashPerField.writeVInt(1, n3 - n2);
            termVectorsPostingsArray.lastOffsets[n] = n3;
        }
        if (this.doVectorPositions) {
            this.termsHashPerField.writeVInt(0, this.fieldState.position);
            termVectorsPostingsArray.lastPositions[n] = this.fieldState.position;
        }
    }

    @Override
    void addTerm(int n) {
        assert (this.docState.testPoint("TermVectorsTermsWriterPerField.addTerm start"));
        TermVectorsPostingsArray termVectorsPostingsArray = (TermVectorsPostingsArray)this.termsHashPerField.postingsArray;
        int n2 = n;
        termVectorsPostingsArray.freqs[n2] = termVectorsPostingsArray.freqs[n2] + 1;
        if (this.doVectorOffsets) {
            int n3 = this.fieldState.offset + this.offsetAttribute.startOffset();
            int n4 = this.fieldState.offset + this.offsetAttribute.endOffset();
            this.termsHashPerField.writeVInt(1, n3 - termVectorsPostingsArray.lastOffsets[n]);
            this.termsHashPerField.writeVInt(1, n4 - n3);
            termVectorsPostingsArray.lastOffsets[n] = n4;
        }
        if (this.doVectorPositions) {
            this.termsHashPerField.writeVInt(0, this.fieldState.position - termVectorsPostingsArray.lastPositions[n]);
            termVectorsPostingsArray.lastPositions[n] = this.fieldState.position;
        }
    }

    @Override
    void skippingLongTerm() {
    }

    @Override
    ParallelPostingsArray createPostingsArray(int n) {
        return new TermVectorsPostingsArray(n);
    }

    static final class TermVectorsPostingsArray
    extends ParallelPostingsArray {
        int[] freqs;
        int[] lastOffsets;
        int[] lastPositions;

        public TermVectorsPostingsArray(int n) {
            super(n);
            this.freqs = new int[n];
            this.lastOffsets = new int[n];
            this.lastPositions = new int[n];
        }

        @Override
        ParallelPostingsArray newInstance(int n) {
            return new TermVectorsPostingsArray(n);
        }

        @Override
        void copyTo(ParallelPostingsArray parallelPostingsArray, int n) {
            assert (parallelPostingsArray instanceof TermVectorsPostingsArray);
            TermVectorsPostingsArray termVectorsPostingsArray = (TermVectorsPostingsArray)parallelPostingsArray;
            super.copyTo(parallelPostingsArray, n);
            System.arraycopy(this.freqs, 0, termVectorsPostingsArray.freqs, 0, this.size);
            System.arraycopy(this.lastOffsets, 0, termVectorsPostingsArray.lastOffsets, 0, this.size);
            System.arraycopy(this.lastPositions, 0, termVectorsPostingsArray.lastPositions, 0, this.size);
        }

        @Override
        int bytesPerPosting() {
            return super.bytesPerPosting() + 12;
        }
    }
}

