/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;

class TermInfosReaderIndex {
    private static final int MAX_PAGE_BITS = 18;
    private Term[] fields;
    private int totalIndexInterval;
    private Comparator<BytesRef> comparator = BytesRef.getUTF8SortedAsUTF16Comparator();
    private final PagedBytes.PagedBytesDataInput dataInput;
    private final PackedInts.Reader indexToDataOffset;
    private final int indexSize;
    private final int skipInterval;

    TermInfosReaderIndex(SegmentTermEnum segmentTermEnum, int n, long l, int n2) throws IOException {
        this.totalIndexInterval = n2;
        this.indexSize = 1 + ((int)segmentTermEnum.size - 1) / n;
        this.skipInterval = segmentTermEnum.skipInterval;
        long l2 = (long)((double)l * 1.5) / (long)n;
        PagedBytes pagedBytes = new PagedBytes(TermInfosReaderIndex.estimatePageBits(l2));
        PagedBytes.PagedBytesDataOutput pagedBytesDataOutput = pagedBytes.getDataOutput();
        GrowableWriter growableWriter = new GrowableWriter(4, this.indexSize, false);
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = -1;
        int n4 = 0;
        while (segmentTermEnum.next()) {
            Term term = segmentTermEnum.term();
            if (string != term.field) {
                string = term.field;
                arrayList.add(string);
                ++n3;
            }
            TermInfo termInfo = segmentTermEnum.termInfo();
            growableWriter.set(n4, pagedBytesDataOutput.getPosition());
            pagedBytesDataOutput.writeVInt(n3);
            pagedBytesDataOutput.writeString(term.text());
            pagedBytesDataOutput.writeVInt(termInfo.docFreq);
            if (termInfo.docFreq >= this.skipInterval) {
                pagedBytesDataOutput.writeVInt(termInfo.skipOffset);
            }
            pagedBytesDataOutput.writeVLong(termInfo.freqPointer);
            pagedBytesDataOutput.writeVLong(termInfo.proxPointer);
            pagedBytesDataOutput.writeVLong(segmentTermEnum.indexPointer);
            for (int i = 1; i < n && segmentTermEnum.next(); ++i) {
            }
            ++n4;
        }
        this.fields = new Term[arrayList.size()];
        for (n4 = 0; n4 < this.fields.length; ++n4) {
            this.fields[n4] = new Term((String)arrayList.get(n4));
        }
        pagedBytes.freeze(true);
        this.dataInput = pagedBytes.getDataInput();
        this.indexToDataOffset = growableWriter.getMutable();
    }

    private static int estimatePageBits(long l) {
        return Math.max(Math.min(64 - BitUtil.nlz(l), 18), 4);
    }

    void seekEnum(SegmentTermEnum segmentTermEnum, int n) throws IOException {
        PagedBytes.PagedBytesDataInput pagedBytesDataInput = (PagedBytes.PagedBytesDataInput)this.dataInput.clone();
        pagedBytesDataInput.setPosition(this.indexToDataOffset.get(n));
        int n2 = pagedBytesDataInput.readVInt();
        Term term = this.fields[n2];
        Term term2 = term.createTerm(pagedBytesDataInput.readString());
        TermInfo termInfo = new TermInfo();
        termInfo.docFreq = pagedBytesDataInput.readVInt();
        termInfo.skipOffset = termInfo.docFreq >= this.skipInterval ? pagedBytesDataInput.readVInt() : 0;
        termInfo.freqPointer = pagedBytesDataInput.readVLong();
        termInfo.proxPointer = pagedBytesDataInput.readVLong();
        long l = pagedBytesDataInput.readVLong();
        segmentTermEnum.seek(l, (long)n * (long)this.totalIndexInterval - 1L, term2, termInfo);
    }

    int getIndexOffset(Term term, BytesRef bytesRef) throws IOException {
        int n = 0;
        int n2 = this.indexSize - 1;
        PagedBytes.PagedBytesDataInput pagedBytesDataInput = (PagedBytes.PagedBytesDataInput)this.dataInput.clone();
        BytesRef bytesRef2 = new BytesRef();
        while (n2 >= n) {
            int n3 = n + n2 >>> 1;
            int n4 = this.compareTo(term, bytesRef, n3, pagedBytesDataInput, bytesRef2);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return n2;
    }

    Term getTerm(int n) throws IOException {
        PagedBytes.PagedBytesDataInput pagedBytesDataInput = (PagedBytes.PagedBytesDataInput)this.dataInput.clone();
        pagedBytesDataInput.setPosition(this.indexToDataOffset.get(n));
        int n2 = pagedBytesDataInput.readVInt();
        Term term = this.fields[n2];
        return term.createTerm(pagedBytesDataInput.readString());
    }

    int length() {
        return this.indexSize;
    }

    int compareTo(Term term, BytesRef bytesRef, int n) throws IOException {
        return this.compareTo(term, bytesRef, n, (PagedBytes.PagedBytesDataInput)this.dataInput.clone(), new BytesRef());
    }

    private int compareTo(Term term, BytesRef bytesRef, int n, PagedBytes.PagedBytesDataInput pagedBytesDataInput, BytesRef bytesRef2) throws IOException {
        int n2 = this.compareField(term, n, pagedBytesDataInput);
        if (n2 == 0) {
            bytesRef2.length = pagedBytesDataInput.readVInt();
            bytesRef2.grow(bytesRef2.length);
            pagedBytesDataInput.readBytes(bytesRef2.bytes, 0, bytesRef2.length);
            return this.comparator.compare(bytesRef, bytesRef2);
        }
        return n2;
    }

    private int compareField(Term term, int n, PagedBytes.PagedBytesDataInput pagedBytesDataInput) throws IOException {
        pagedBytesDataInput.setPosition(this.indexToDataOffset.get(n));
        return term.field.compareTo(this.fields[pagedBytesDataInput.readVInt()].field);
    }
}

