/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.FormatPostingsDocsConsumer;
import org.apache.lucene.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.index.FormatPostingsFieldsWriter;
import org.apache.lucene.index.FormatPostingsPositionsConsumer;
import org.apache.lucene.index.FormatPostingsTermsConsumer;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.PayloadProcessorProvider;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentNorms;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ReaderUtil;

final class SegmentMerger {
    private Directory directory;
    private String segment;
    private int termIndexInterval = 128;
    private List<IndexReader> readers = new ArrayList<IndexReader>();
    private final FieldInfos fieldInfos;
    private int mergedDocs;
    private final CheckAbort checkAbort;
    private static final int MAX_RAW_MERGE_DOCS = 4192;
    private SegmentWriteState segmentWriteState;
    private final PayloadProcessorProvider payloadProcessorProvider;
    private SegmentReader[] matchingSegmentReaders;
    private int[] rawDocLengths;
    private int[] rawDocLengths2;
    private int matchedCount;
    private SegmentMergeQueue queue = null;
    FieldInfo.IndexOptions indexOptions;
    private byte[] payloadBuffer;
    private int[][] docMaps;

    SegmentMerger(Directory directory, int n, String string, MergePolicy.OneMerge oneMerge, PayloadProcessorProvider payloadProcessorProvider, FieldInfos fieldInfos) {
        this.payloadProcessorProvider = payloadProcessorProvider;
        this.directory = directory;
        this.fieldInfos = fieldInfos;
        this.segment = string;
        this.checkAbort = oneMerge != null ? new CheckAbort(oneMerge, this.directory) : new CheckAbort(null, null){

            @Override
            public void work(double d) throws MergePolicy.MergeAbortedException {
            }
        };
        this.termIndexInterval = n;
    }

    public FieldInfos fieldInfos() {
        return this.fieldInfos;
    }

    final void add(IndexReader indexReader) {
        ReaderUtil.gatherSubReaders(this.readers, indexReader);
    }

    final int merge() throws CorruptIndexException, IOException {
        this.mergedDocs = this.mergeFields();
        this.mergeTerms();
        this.mergeNorms();
        if (this.fieldInfos.hasVectors()) {
            this.mergeVectors();
        }
        return this.mergedDocs;
    }

    final Collection<String> createCompoundFile(String string, SegmentInfo segmentInfo) throws IOException {
        List<String> list = segmentInfo.files();
        CompoundFileWriter compoundFileWriter = new CompoundFileWriter(this.directory, string, this.checkAbort);
        for (String string2 : list) {
            assert (!IndexFileNames.matchesExtension(string2, "del")) : ".del file is not allowed in .cfs: " + string2;
            assert (!IndexFileNames.isSeparateNormsFile(string2)) : "separate norms file (.s[0-9]+) is not allowed in .cfs: " + string2;
            compoundFileWriter.addFile(string2);
        }
        compoundFileWriter.close();
        return list;
    }

    private static void addIndexed(IndexReader indexReader, FieldInfos fieldInfos, Collection<String> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4, FieldInfo.IndexOptions indexOptions) throws IOException {
        for (String string : collection) {
            fieldInfos.add(string, true, bl, bl2, bl3, !indexReader.hasNorms(string), bl4, indexOptions);
        }
    }

    public int getMatchedSubReaderCount() {
        return this.matchedCount;
    }

    private void setMatchingSegmentReaders() {
        int n = this.readers.size();
        this.matchingSegmentReaders = new SegmentReader[n];
        for (int i = 0; i < n; ++i) {
            IndexReader indexReader = this.readers.get(i);
            if (!(indexReader instanceof SegmentReader)) continue;
            SegmentReader segmentReader = (SegmentReader)indexReader;
            boolean bl = true;
            FieldInfos fieldInfos = segmentReader.fieldInfos();
            int n2 = fieldInfos.size();
            for (int j = 0; j < n2; ++j) {
                if (this.fieldInfos.fieldName(j).equals(fieldInfos.fieldName(j))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.matchingSegmentReaders[i] = segmentReader;
            ++this.matchedCount;
        }
        this.rawDocLengths = new int[4192];
        this.rawDocLengths2 = new int[4192];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int mergeFields() throws CorruptIndexException, IOException {
        for (IndexReader object2 : this.readers) {
            if (object2 instanceof SegmentReader) {
                SegmentReader n2 = (SegmentReader)object2;
                FieldInfos l = n2.fieldInfos();
                int indexReader = l.size();
                for (int i = 0; i < indexReader; ++i) {
                    this.fieldInfos.add(l.fieldInfo(i));
                }
                continue;
            }
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET), true, true, true, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION), true, true, false, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET), true, false, true, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.TERMVECTOR), true, false, false, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.OMIT_POSITIONS), false, false, false, false, FieldInfo.IndexOptions.DOCS_AND_FREQS);
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.OMIT_TERM_FREQ_AND_POSITIONS), false, false, false, false, FieldInfo.IndexOptions.DOCS_ONLY);
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.STORES_PAYLOADS), false, false, false, true, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            SegmentMerger.addIndexed(object2, this.fieldInfos, object2.getFieldNames(IndexReader.FieldOption.INDEXED), false, false, false, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            this.fieldInfos.add(object2.getFieldNames(IndexReader.FieldOption.UNINDEXED), false);
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        int n = 0;
        this.setMatchingSegmentReaders();
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            int string = 0;
            for (IndexReader indexReader : this.readers) {
                FieldsReader fieldsReader;
                SegmentReader segmentReader = this.matchingSegmentReaders[string++];
                FieldsReader fieldsReader2 = null;
                if (segmentReader != null && (fieldsReader = segmentReader.getFieldsReader()) != null && fieldsReader.canReadRawDocs()) {
                    fieldsReader2 = fieldsReader;
                }
                if (indexReader.hasDeletions()) {
                    n += this.copyFieldsWithDeletions(fieldsWriter, indexReader, fieldsReader2);
                    continue;
                }
                n += this.copyFieldsNoDeletions(fieldsWriter, indexReader, fieldsReader2);
            }
        }
        finally {
            fieldsWriter.close();
        }
        String string = IndexFileNames.segmentFileName(this.segment, "fdx");
        long l = this.directory.fileLength(string);
        if (4L + (long)n * 8L != l) {
            throw new RuntimeException("mergeFields produced an invalid result: docCount is " + n + " but fdx file size is " + l + " file=" + string + " file exists?=" + this.directory.fileExists(string) + "; now aborting this merge to prevent index corruption");
        }
        this.segmentWriteState = new SegmentWriteState(null, this.directory, this.segment, this.fieldInfos, n, this.termIndexInterval, null);
        return n;
    }

    private int copyFieldsWithDeletions(FieldsWriter fieldsWriter, IndexReader indexReader, FieldsReader fieldsReader) throws IOException, MergePolicy.MergeAbortedException, CorruptIndexException {
        int n = 0;
        int n2 = indexReader.maxDoc();
        if (fieldsReader != null) {
            int n3 = 0;
            while (n3 < n2) {
                if (indexReader.isDeleted(n3)) {
                    ++n3;
                    continue;
                }
                int n4 = n3;
                int n5 = 0;
                do {
                    ++n5;
                    if (++n3 >= n2) break;
                    if (!indexReader.isDeleted(n3)) continue;
                    ++n3;
                    break;
                } while (n5 < 4192);
                IndexInput indexInput = fieldsReader.rawDocs(this.rawDocLengths, n4, n5);
                fieldsWriter.addRawDocuments(indexInput, this.rawDocLengths, n5);
                n += n5;
                this.checkAbort.work(300 * n5);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (indexReader.isDeleted(i)) continue;
                Document document = indexReader.document(i);
                fieldsWriter.addDocument(document);
                ++n;
                this.checkAbort.work(300.0);
            }
        }
        return n;
    }

    private int copyFieldsNoDeletions(FieldsWriter fieldsWriter, IndexReader indexReader, FieldsReader fieldsReader) throws IOException, MergePolicy.MergeAbortedException, CorruptIndexException {
        int n;
        int n2 = indexReader.maxDoc();
        if (fieldsReader != null) {
            int n3;
            for (n = 0; n < n2; n += n3) {
                n3 = Math.min(4192, n2 - n);
                IndexInput indexInput = fieldsReader.rawDocs(this.rawDocLengths, n, n3);
                fieldsWriter.addRawDocuments(indexInput, this.rawDocLengths, n3);
                this.checkAbort.work(300 * n3);
            }
        } else {
            while (n < n2) {
                Document document = indexReader.document(n);
                fieldsWriter.addDocument(document);
                this.checkAbort.work(300.0);
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeVectors() throws IOException {
        TermVectorsWriter termVectorsWriter = new TermVectorsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            int n = 0;
            for (IndexReader indexReader : this.readers) {
                TermVectorsReader termVectorsReader;
                SegmentReader segmentReader = this.matchingSegmentReaders[n++];
                TermVectorsReader termVectorsReader2 = null;
                if (segmentReader != null && (termVectorsReader = segmentReader.getTermVectorsReader()) != null && termVectorsReader.canReadRawDocs()) {
                    termVectorsReader2 = termVectorsReader;
                }
                if (indexReader.hasDeletions()) {
                    this.copyVectorsWithDeletions(termVectorsWriter, termVectorsReader2, indexReader);
                    continue;
                }
                this.copyVectorsNoDeletions(termVectorsWriter, termVectorsReader2, indexReader);
            }
        }
        finally {
            termVectorsWriter.close();
        }
        String string = IndexFileNames.segmentFileName(this.segment, "tvx");
        long l = this.directory.fileLength(string);
        if (4L + (long)this.mergedDocs * 16L != l) {
            throw new RuntimeException("mergeVectors produced an invalid result: mergedDocs is " + this.mergedDocs + " but tvx size is " + l + " file=" + string + " file exists?=" + this.directory.fileExists(string) + "; now aborting this merge to prevent index corruption");
        }
    }

    private void copyVectorsWithDeletions(TermVectorsWriter termVectorsWriter, TermVectorsReader termVectorsReader, IndexReader indexReader) throws IOException, MergePolicy.MergeAbortedException {
        int n = indexReader.maxDoc();
        if (termVectorsReader != null) {
            int n2 = 0;
            while (n2 < n) {
                if (indexReader.isDeleted(n2)) {
                    ++n2;
                    continue;
                }
                int n3 = n2;
                int n4 = 0;
                do {
                    ++n4;
                    if (++n2 >= n) break;
                    if (!indexReader.isDeleted(n2)) continue;
                    ++n2;
                    break;
                } while (n4 < 4192);
                termVectorsReader.rawDocs(this.rawDocLengths, this.rawDocLengths2, n3, n4);
                termVectorsWriter.addRawDocuments(termVectorsReader, this.rawDocLengths, this.rawDocLengths2, n4);
                this.checkAbort.work(300 * n4);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (indexReader.isDeleted(i)) continue;
                TermFreqVector[] termFreqVectorArray = indexReader.getTermFreqVectors(i);
                termVectorsWriter.addAllDocVectors(termFreqVectorArray);
                this.checkAbort.work(300.0);
            }
        }
    }

    private void copyVectorsNoDeletions(TermVectorsWriter termVectorsWriter, TermVectorsReader termVectorsReader, IndexReader indexReader) throws IOException, MergePolicy.MergeAbortedException {
        int n = indexReader.maxDoc();
        if (termVectorsReader != null) {
            int n2;
            for (int i = 0; i < n; i += n2) {
                n2 = Math.min(4192, n - i);
                termVectorsReader.rawDocs(this.rawDocLengths, this.rawDocLengths2, i, n2);
                termVectorsWriter.addRawDocuments(termVectorsReader, this.rawDocLengths, this.rawDocLengths2, n2);
                this.checkAbort.work(300 * n2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                TermFreqVector[] termFreqVectorArray = indexReader.getTermFreqVectors(i);
                termVectorsWriter.addAllDocVectors(termFreqVectorArray);
                this.checkAbort.work(300.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeTerms() throws CorruptIndexException, IOException {
        FormatPostingsFieldsWriter formatPostingsFieldsWriter = new FormatPostingsFieldsWriter(this.segmentWriteState, this.fieldInfos);
        try {
            this.queue = new SegmentMergeQueue(this.readers.size());
            this.mergeTermInfos(formatPostingsFieldsWriter);
        }
        finally {
            try {
                ((FormatPostingsFieldsConsumer)formatPostingsFieldsWriter).finish();
            }
            finally {
                if (this.queue != null) {
                    this.queue.close();
                }
            }
        }
    }

    private final void mergeTermInfos(FormatPostingsFieldsConsumer formatPostingsFieldsConsumer) throws CorruptIndexException, IOException {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        int n2 = this.readers.size();
        for (int i = 0; i < n2; ++i) {
            object3 = this.readers.get(i);
            object2 = ((IndexReader)object3).terms();
            SegmentMergeInfo segmentMergeInfo = new SegmentMergeInfo(n, (TermEnum)object2, (IndexReader)object3);
            if (this.payloadProcessorProvider != null) {
                segmentMergeInfo.dirPayloadProcessor = this.payloadProcessorProvider.getDirProcessor(((IndexReader)object3).directory());
            }
            if ((object = segmentMergeInfo.getDocMap()) != null) {
                if (this.docMaps == null) {
                    this.docMaps = new int[n2][];
                }
                this.docMaps[i] = object;
            }
            n += ((IndexReader)object3).numDocs();
            assert (((IndexReader)object3).numDocs() == ((IndexReader)object3).maxDoc() - segmentMergeInfo.delCount);
            if (segmentMergeInfo.next()) {
                this.queue.add(segmentMergeInfo);
                continue;
            }
            segmentMergeInfo.close();
        }
        SegmentMergeInfo[] segmentMergeInfoArray = new SegmentMergeInfo[this.readers.size()];
        object3 = null;
        object2 = null;
        while (this.queue.size() > 0) {
            int n3 = 0;
            segmentMergeInfoArray[n3++] = (SegmentMergeInfo)this.queue.pop();
            object = segmentMergeInfoArray[0].term;
            SegmentMergeInfo segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            while (segmentMergeInfo != null && ((Term)object).compareTo(segmentMergeInfo.term) == 0) {
                segmentMergeInfoArray[n3++] = (SegmentMergeInfo)this.queue.pop();
                segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            }
            if (object3 != ((Term)object).field) {
                object3 = ((Term)object).field;
                if (object2 != null) {
                    ((FormatPostingsTermsConsumer)object2).finish();
                }
                FieldInfo fieldInfo = this.fieldInfos.fieldInfo((String)object3);
                object2 = formatPostingsFieldsConsumer.addField(fieldInfo);
                this.indexOptions = fieldInfo.indexOptions;
            }
            int n4 = this.appendPostings((FormatPostingsTermsConsumer)object2, segmentMergeInfoArray, n3);
            this.checkAbort.work((double)n4 / 3.0);
            while (n3 > 0) {
                SegmentMergeInfo segmentMergeInfo2;
                if ((segmentMergeInfo2 = segmentMergeInfoArray[--n3]).next()) {
                    this.queue.add(segmentMergeInfo2);
                    continue;
                }
                segmentMergeInfo2.close();
            }
        }
    }

    private final int appendPostings(FormatPostingsTermsConsumer formatPostingsTermsConsumer, SegmentMergeInfo[] segmentMergeInfoArray, int n) throws CorruptIndexException, IOException {
        FormatPostingsDocsConsumer formatPostingsDocsConsumer = formatPostingsTermsConsumer.addTerm(segmentMergeInfoArray[0].term.text);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SegmentMergeInfo segmentMergeInfo = segmentMergeInfoArray[i];
            TermPositions termPositions = segmentMergeInfo.getPositions();
            assert (termPositions != null);
            int n3 = segmentMergeInfo.base;
            int[] nArray = segmentMergeInfo.getDocMap();
            termPositions.seek(segmentMergeInfo.termEnum);
            PayloadProcessorProvider.PayloadProcessor payloadProcessor = null;
            if (segmentMergeInfo.dirPayloadProcessor != null) {
                payloadProcessor = segmentMergeInfo.dirPayloadProcessor.getProcessor(segmentMergeInfo.term);
            }
            while (termPositions.next()) {
                ++n2;
                int n4 = termPositions.doc();
                if (nArray != null) {
                    n4 = nArray[n4];
                }
                int n5 = termPositions.freq();
                FormatPostingsPositionsConsumer formatPostingsPositionsConsumer = formatPostingsDocsConsumer.addDoc(n4 += n3, n5);
                if (this.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) continue;
                for (int j = 0; j < n5; ++j) {
                    int n6 = termPositions.nextPosition();
                    int n7 = termPositions.getPayloadLength();
                    if (n7 > 0) {
                        if (this.payloadBuffer == null || this.payloadBuffer.length < n7) {
                            this.payloadBuffer = new byte[n7];
                        }
                        termPositions.getPayload(this.payloadBuffer, 0);
                        if (payloadProcessor != null) {
                            this.payloadBuffer = payloadProcessor.processPayload(this.payloadBuffer, 0, n7);
                            n7 = payloadProcessor.payloadLength();
                        }
                    }
                    formatPostingsPositionsConsumer.addPosition(n6, this.payloadBuffer, 0, n7);
                }
                formatPostingsPositionsConsumer.finish();
            }
        }
        formatPostingsDocsConsumer.finish();
        return n2;
    }

    public boolean getAnyNonBulkMerges() {
        assert (this.matchedCount <= this.readers.size());
        return this.matchedCount != this.readers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void mergeNorms() throws IOException {
        block13: {
            void var3_5;
            block12: {
                int n = 0;
                for (IndexReader closeable2 : this.readers) {
                    n = Math.max(n, closeable2.maxDoc());
                }
                Object object = null;
                Object var3_4 = null;
                boolean bl = false;
                try {
                    int n2 = this.fieldInfos.size();
                    for (int i = 0; i < n2; ++i) {
                        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
                        if (!fieldInfo.isIndexed || fieldInfo.omitNorms) continue;
                        if (var3_5 == null) {
                            IndexOutput indexOutput = this.directory.createOutput(IndexFileNames.segmentFileName(this.segment, "nrm"));
                            indexOutput.writeBytes(SegmentNorms.NORMS_HEADER, SegmentNorms.NORMS_HEADER.length);
                        }
                        if (object == null) {
                            object = new byte[n];
                        }
                        for (IndexReader indexReader : this.readers) {
                            int n3 = indexReader.maxDoc();
                            indexReader.norms(fieldInfo.name, (byte[])object, 0);
                            if (!indexReader.hasDeletions()) {
                                var3_5.writeBytes((byte[])object, n3);
                            } else {
                                for (int j = 0; j < n3; ++j) {
                                    if (indexReader.isDeleted(j)) continue;
                                    var3_5.writeByte((byte)object[j]);
                                }
                            }
                            this.checkAbort.work(n3);
                        }
                    }
                    bl = true;
                    if (!bl) break block12;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(new Closeable[]{var3_4});
                    } else {
                        IOUtils.closeWhileHandlingException(new Closeable[]{var3_4});
                    }
                    throw throwable;
                }
                IOUtils.close(new Closeable[]{var3_5});
                break block13;
            }
            IOUtils.closeWhileHandlingException(new Closeable[]{var3_5});
        }
    }

    static class CheckAbort {
        private double workCount;
        private MergePolicy.OneMerge merge;
        private Directory dir;

        public CheckAbort(MergePolicy.OneMerge oneMerge, Directory directory) {
            this.merge = oneMerge;
            this.dir = directory;
        }

        public void work(double d) throws MergePolicy.MergeAbortedException {
            this.workCount += d;
            if (this.workCount >= 10000.0) {
                this.merge.checkAborted(this.dir);
                this.workCount = 0.0;
            }
        }
    }
}

