/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.Constants;

public final class SegmentInfo
implements Cloneable {
    static final int NO = -1;
    static final int YES = 1;
    static final int CHECK_DIR = 0;
    static final int WITHOUT_GEN = 0;
    public String name;
    public int docCount;
    public Directory dir;
    private boolean preLockless;
    private long delGen;
    private long[] normGen;
    private byte isCompoundFile;
    private boolean hasSingleNormFile;
    private volatile List<String> files;
    private volatile long sizeInBytesNoStore = -1L;
    private volatile long sizeInBytesWithStore = -1L;
    private int docStoreOffset;
    private String docStoreSegment;
    private boolean docStoreIsCompoundFile;
    private int delCount;
    private boolean hasProx;
    private boolean hasVectors;
    private Map<String, String> diagnostics;
    private String version;
    private long bufferedDeletesGen;

    public SegmentInfo(String string, int n, Directory directory, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.docCount = n;
        this.dir = directory;
        this.delGen = -1L;
        this.isCompoundFile = (byte)(bl ? 1 : -1);
        this.preLockless = false;
        this.hasSingleNormFile = bl2;
        this.docStoreOffset = -1;
        this.delCount = 0;
        this.hasProx = bl3;
        this.hasVectors = bl4;
        this.version = Constants.LUCENE_MAIN_VERSION;
    }

    void reset(SegmentInfo segmentInfo) {
        this.clearFiles();
        this.version = segmentInfo.version;
        this.name = segmentInfo.name;
        this.docCount = segmentInfo.docCount;
        this.dir = segmentInfo.dir;
        this.preLockless = segmentInfo.preLockless;
        this.delGen = segmentInfo.delGen;
        this.docStoreOffset = segmentInfo.docStoreOffset;
        this.docStoreIsCompoundFile = segmentInfo.docStoreIsCompoundFile;
        this.hasVectors = segmentInfo.hasVectors;
        this.hasProx = segmentInfo.hasProx;
        if (segmentInfo.normGen == null) {
            this.normGen = null;
        } else {
            this.normGen = new long[segmentInfo.normGen.length];
            System.arraycopy(segmentInfo.normGen, 0, this.normGen, 0, segmentInfo.normGen.length);
        }
        this.isCompoundFile = segmentInfo.isCompoundFile;
        this.hasSingleNormFile = segmentInfo.hasSingleNormFile;
        this.delCount = segmentInfo.delCount;
    }

    void setDiagnostics(Map<String, String> map) {
        this.diagnostics = map;
    }

    public Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentInfo(Directory directory, int n, IndexInput indexInput) throws IOException {
        this.dir = directory;
        if (n <= -11) {
            this.version = indexInput.readString();
        }
        this.name = indexInput.readString();
        this.docCount = indexInput.readInt();
        if (n <= -2) {
            this.delGen = indexInput.readLong();
            if (n <= -4) {
                this.docStoreOffset = indexInput.readInt();
                if (this.docStoreOffset != -1) {
                    this.docStoreSegment = indexInput.readString();
                    this.docStoreIsCompoundFile = 1 == indexInput.readByte();
                } else {
                    this.docStoreSegment = this.name;
                    this.docStoreIsCompoundFile = false;
                }
            } else {
                this.docStoreOffset = -1;
                this.docStoreSegment = this.name;
                this.docStoreIsCompoundFile = false;
            }
            this.hasSingleNormFile = n <= -3 ? 1 == indexInput.readByte() : false;
            int n2 = indexInput.readInt();
            if (n2 == -1) {
                this.normGen = null;
            } else {
                this.normGen = new long[n2];
                for (int i = 0; i < n2; ++i) {
                    this.normGen[i] = indexInput.readLong();
                }
            }
            this.isCompoundFile = indexInput.readByte();
            boolean bl = this.preLockless = this.isCompoundFile == 0;
            if (n <= -6) {
                this.delCount = indexInput.readInt();
                assert (this.delCount <= this.docCount);
            } else {
                this.delCount = -1;
            }
            this.hasProx = n <= -7 ? indexInput.readByte() == 1 : true;
            this.diagnostics = n <= -9 ? indexInput.readStringStringMap() : Collections.emptyMap();
            if (n <= -10) {
                this.hasVectors = indexInput.readByte() == 1;
            } else {
                String string;
                boolean bl2;
                String string2;
                if (this.docStoreOffset != -1) {
                    string2 = this.docStoreSegment;
                    bl2 = this.docStoreIsCompoundFile;
                    string = "cfx";
                } else {
                    string2 = this.name;
                    bl2 = this.getUseCompoundFile();
                    string = "cfs";
                }
                Directory directory2 = bl2 ? new CompoundFileReader(directory, IndexFileNames.segmentFileName(string2, string)) : directory;
                try {
                    this.hasVectors = directory2.fileExists(IndexFileNames.segmentFileName(string2, "tvx"));
                }
                finally {
                    if (bl2) {
                        directory2.close();
                    }
                }
            }
        } else {
            this.delGen = 0L;
            this.normGen = null;
            this.isCompoundFile = 0;
            this.preLockless = true;
            this.hasSingleNormFile = false;
            this.docStoreOffset = -1;
            this.docStoreIsCompoundFile = false;
            this.docStoreSegment = null;
            this.delCount = -1;
            this.hasProx = true;
            this.diagnostics = Collections.emptyMap();
        }
    }

    void setNumFields(int n) {
        if (this.normGen == null) {
            this.normGen = new long[n];
            if (!this.preLockless) {
                for (int i = 0; i < n; ++i) {
                    this.normGen[i] = -1L;
                }
            }
        }
    }

    public long sizeInBytes(boolean bl) throws IOException {
        if (bl) {
            if (this.sizeInBytesWithStore != -1L) {
                return this.sizeInBytesWithStore;
            }
            long l = 0L;
            for (String string : this.files()) {
                if (this.docStoreOffset != -1 && IndexFileNames.isDocStoreFile(string)) continue;
                l += this.dir.fileLength(string);
            }
            this.sizeInBytesWithStore = l;
            return this.sizeInBytesWithStore;
        }
        if (this.sizeInBytesNoStore != -1L) {
            return this.sizeInBytesNoStore;
        }
        long l = 0L;
        for (String string : this.files()) {
            if (IndexFileNames.isDocStoreFile(string)) continue;
            l += this.dir.fileLength(string);
        }
        this.sizeInBytesNoStore = l;
        return this.sizeInBytesNoStore;
    }

    public boolean getHasVectors() throws IOException {
        return this.hasVectors;
    }

    public void setHasVectors(boolean bl) {
        this.hasVectors = bl;
        this.clearFiles();
    }

    public boolean hasDeletions() throws IOException {
        if (this.delGen == -1L) {
            return false;
        }
        if (this.delGen >= 1L) {
            return true;
        }
        return this.dir.fileExists(this.getDelFileName());
    }

    void advanceDelGen() {
        this.delGen = this.delGen == -1L ? 1L : ++this.delGen;
        this.clearFiles();
    }

    void clearDelGen() {
        this.delGen = -1L;
        this.clearFiles();
    }

    public Object clone() {
        SegmentInfo segmentInfo = new SegmentInfo(this.name, this.docCount, this.dir, false, this.hasSingleNormFile, this.hasProx, this.hasVectors);
        segmentInfo.docStoreOffset = this.docStoreOffset;
        segmentInfo.docStoreSegment = this.docStoreSegment;
        segmentInfo.docStoreIsCompoundFile = this.docStoreIsCompoundFile;
        segmentInfo.delGen = this.delGen;
        segmentInfo.delCount = this.delCount;
        segmentInfo.preLockless = this.preLockless;
        segmentInfo.isCompoundFile = this.isCompoundFile;
        segmentInfo.diagnostics = new HashMap<String, String>(this.diagnostics);
        if (this.normGen != null) {
            segmentInfo.normGen = (long[])this.normGen.clone();
        }
        segmentInfo.version = this.version;
        return segmentInfo;
    }

    public String getDelFileName() {
        if (this.delGen == -1L) {
            return null;
        }
        return IndexFileNames.fileNameFromGeneration(this.name, "del", this.delGen);
    }

    public boolean hasSeparateNorms(int n) throws IOException {
        if (this.normGen == null && this.preLockless || this.normGen != null && this.normGen[n] == 0L) {
            String string = this.name + ".s" + n;
            return this.dir.fileExists(string);
        }
        return this.normGen != null && this.normGen[n] != -1L;
    }

    public boolean hasSeparateNorms() throws IOException {
        int n;
        if (this.normGen == null) {
            if (!this.preLockless) {
                return false;
            }
            String[] stringArray = this.dir.listAll();
            if (stringArray == null) {
                throw new IOException("cannot read directory " + this.dir + ": listAll() returned null");
            }
            IndexFileNameFilter indexFileNameFilter = IndexFileNameFilter.getFilter();
            String string = this.name + ".s";
            int n2 = string.length();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!indexFileNameFilter.accept(null, string2) || !string2.startsWith(string) || !Character.isDigit(string2.charAt(n2))) continue;
                return true;
            }
            return false;
        }
        for (n = 0; n < this.normGen.length; ++n) {
            if (this.normGen[n] < 1L) continue;
            return true;
        }
        for (n = 0; n < this.normGen.length; ++n) {
            if (this.normGen[n] != 0L || !this.hasSeparateNorms(n)) continue;
            return true;
        }
        return false;
    }

    void advanceNormGen(int n) {
        if (this.normGen[n] == -1L) {
            this.normGen[n] = 1L;
        } else {
            int n2 = n;
            this.normGen[n2] = this.normGen[n2] + 1L;
        }
        this.clearFiles();
    }

    public String getNormFileName(int n) throws IOException {
        long l = this.normGen == null ? 0L : this.normGen[n];
        if (this.hasSeparateNorms(n)) {
            return IndexFileNames.fileNameFromGeneration(this.name, "s" + n, l);
        }
        if (this.hasSingleNormFile) {
            return IndexFileNames.fileNameFromGeneration(this.name, "nrm", 0L);
        }
        return IndexFileNames.fileNameFromGeneration(this.name, "f" + n, 0L);
    }

    void setUseCompoundFile(boolean bl) {
        this.isCompoundFile = bl ? (byte)1 : (byte)-1;
        this.clearFiles();
    }

    public boolean getUseCompoundFile() throws IOException {
        if (this.isCompoundFile == -1) {
            return false;
        }
        if (this.isCompoundFile == 1) {
            return true;
        }
        return this.dir.fileExists(IndexFileNames.segmentFileName(this.name, "cfs"));
    }

    public int getDelCount() throws IOException {
        if (this.delCount == -1) {
            if (this.hasDeletions()) {
                String string = this.getDelFileName();
                this.delCount = new BitVector(this.dir, string).count();
            } else {
                this.delCount = 0;
            }
        }
        assert (this.delCount <= this.docCount);
        return this.delCount;
    }

    void setDelCount(int n) {
        this.delCount = n;
        assert (n <= this.docCount);
    }

    public int getDocStoreOffset() {
        return this.docStoreOffset;
    }

    public boolean getDocStoreIsCompoundFile() {
        return this.docStoreIsCompoundFile;
    }

    void setDocStoreIsCompoundFile(boolean bl) {
        this.docStoreIsCompoundFile = bl;
        this.clearFiles();
    }

    public String getDocStoreSegment() {
        return this.docStoreSegment;
    }

    public void setDocStoreSegment(String string) {
        this.docStoreSegment = string;
    }

    void setDocStoreOffset(int n) {
        this.docStoreOffset = n;
        this.clearFiles();
    }

    void setDocStore(int n, String string, boolean bl) {
        this.docStoreOffset = n;
        this.docStoreSegment = string;
        this.docStoreIsCompoundFile = bl;
        this.clearFiles();
    }

    void write(IndexOutput indexOutput) throws IOException {
        assert (this.delCount <= this.docCount) : "delCount=" + this.delCount + " docCount=" + this.docCount + " segment=" + this.name;
        indexOutput.writeString(this.version);
        indexOutput.writeString(this.name);
        indexOutput.writeInt(this.docCount);
        indexOutput.writeLong(this.delGen);
        indexOutput.writeInt(this.docStoreOffset);
        if (this.docStoreOffset != -1) {
            indexOutput.writeString(this.docStoreSegment);
            indexOutput.writeByte((byte)(this.docStoreIsCompoundFile ? 1 : 0));
        }
        indexOutput.writeByte((byte)(this.hasSingleNormFile ? 1 : 0));
        if (this.normGen == null) {
            indexOutput.writeInt(-1);
        } else {
            indexOutput.writeInt(this.normGen.length);
            for (int i = 0; i < this.normGen.length; ++i) {
                indexOutput.writeLong(this.normGen[i]);
            }
        }
        indexOutput.writeByte(this.isCompoundFile);
        indexOutput.writeInt(this.delCount);
        indexOutput.writeByte((byte)(this.hasProx ? 1 : 0));
        indexOutput.writeStringStringMap(this.diagnostics);
        indexOutput.writeByte((byte)(this.hasVectors ? 1 : 0));
    }

    void setHasProx(boolean bl) {
        this.hasProx = bl;
        this.clearFiles();
    }

    public boolean getHasProx() {
        return this.hasProx;
    }

    private void addIfExists(Set<String> set, String string) throws IOException {
        if (this.dir.fileExists(string)) {
            set.add(string);
        }
    }

    public List<String> files() throws IOException {
        int l;
        int string;
        if (this.files != null) {
            return this.files;
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = this.getUseCompoundFile();
        if (bl) {
            hashSet.add(IndexFileNames.segmentFileName(this.name, "cfs"));
        } else {
            String[] object = IndexFileNames.NON_STORE_INDEX_EXTENSIONS;
            string = object.length;
            for (l = 0; l < string; ++l) {
                String string2 = object[l];
                this.addIfExists(hashSet, IndexFileNames.segmentFileName(this.name, string2));
            }
        }
        if (this.docStoreOffset != -1) {
            assert (this.docStoreSegment != null);
            if (this.docStoreIsCompoundFile) {
                hashSet.add(IndexFileNames.segmentFileName(this.docStoreSegment, "cfx"));
            } else {
                hashSet.add(IndexFileNames.segmentFileName(this.docStoreSegment, "fdx"));
                hashSet.add(IndexFileNames.segmentFileName(this.docStoreSegment, "fdt"));
                if (this.hasVectors) {
                    hashSet.add(IndexFileNames.segmentFileName(this.docStoreSegment, "tvx"));
                    hashSet.add(IndexFileNames.segmentFileName(this.docStoreSegment, "tvd"));
                    hashSet.add(IndexFileNames.segmentFileName(this.docStoreSegment, "tvf"));
                }
            }
        } else if (!bl) {
            hashSet.add(IndexFileNames.segmentFileName(this.name, "fdx"));
            hashSet.add(IndexFileNames.segmentFileName(this.name, "fdt"));
            if (this.hasVectors) {
                hashSet.add(IndexFileNames.segmentFileName(this.name, "tvx"));
                hashSet.add(IndexFileNames.segmentFileName(this.name, "tvd"));
                hashSet.add(IndexFileNames.segmentFileName(this.name, "tvf"));
            }
        }
        String string3 = IndexFileNames.fileNameFromGeneration(this.name, "del", this.delGen);
        if (string3 != null && (this.delGen >= 1L || this.dir.fileExists(string3))) {
            hashSet.add(string3);
        }
        if (this.normGen != null) {
            for (string = 0; string < this.normGen.length; ++string) {
                String string4;
                long l2 = this.normGen[string];
                if (l2 >= 1L) {
                    hashSet.add(IndexFileNames.fileNameFromGeneration(this.name, "s" + string, l2));
                    continue;
                }
                if (-1L == l2) {
                    if (this.hasSingleNormFile || bl || !this.dir.fileExists(string4 = IndexFileNames.segmentFileName(this.name, "f" + string))) continue;
                    hashSet.add(string4);
                    continue;
                }
                if (0L != l2) continue;
                string4 = null;
                if (bl) {
                    string4 = IndexFileNames.segmentFileName(this.name, "s" + string);
                } else if (!this.hasSingleNormFile) {
                    string4 = IndexFileNames.segmentFileName(this.name, "f" + string);
                }
                if (string4 == null || !this.dir.fileExists(string4)) continue;
                hashSet.add(string4);
            }
        } else if (this.preLockless || !this.hasSingleNormFile && !bl) {
            String string5 = bl ? IndexFileNames.segmentFileName(this.name, "s") : IndexFileNames.segmentFileName(this.name, "f");
            l = string5.length();
            String[] stringArray = this.dir.listAll();
            IndexFileNameFilter indexFileNameFilter = IndexFileNameFilter.getFilter();
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = stringArray[i];
                if (!indexFileNameFilter.accept(null, string6) || string6.length() <= l || !Character.isDigit(string6.charAt(l)) || !string6.startsWith(string5)) continue;
                hashSet.add(string6);
            }
        }
        this.files = new ArrayList<String>(hashSet);
        return this.files;
    }

    private void clearFiles() {
        this.files = null;
        this.sizeInBytesNoStore = -1L;
        this.sizeInBytesWithStore = -1L;
    }

    public String toString() {
        return this.toString(this.dir, 0);
    }

    public String toString(Directory directory, int n) {
        int n2;
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append('(').append(this.version == null ? "?" : this.version).append(')').append(':');
        try {
            c = this.getUseCompoundFile() ? (char)'c' : 'C';
        }
        catch (IOException iOException) {
            c = '?';
        }
        stringBuilder.append(c);
        if (this.dir != directory) {
            stringBuilder.append('x');
        }
        if (this.hasVectors) {
            stringBuilder.append('v');
        }
        stringBuilder.append(this.docCount);
        try {
            n2 = this.getDelCount();
        }
        catch (IOException iOException) {
            n2 = -1;
        }
        if (n2 != -1) {
            n2 += n;
        }
        if (n2 != 0) {
            stringBuilder.append('/');
            if (n2 == -1) {
                stringBuilder.append('?');
            } else {
                stringBuilder.append(n2);
            }
        }
        if (this.docStoreOffset != -1) {
            stringBuilder.append("->").append(this.docStoreSegment);
            if (this.docStoreIsCompoundFile) {
                stringBuilder.append('c');
            } else {
                stringBuilder.append('C');
            }
            stringBuilder.append('+').append(this.docStoreOffset);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentInfo) {
            SegmentInfo segmentInfo = (SegmentInfo)object;
            return segmentInfo.dir == this.dir && segmentInfo.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.dir.hashCode() + this.name.hashCode();
    }

    void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    long getBufferedDeletesGen() {
        return this.bufferedDeletesGen;
    }

    void setBufferedDeletesGen(long l) {
        this.bufferedDeletesGen = l;
    }
}

