/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

final class SegmentCoreReaders {
    private final AtomicInteger ref = new AtomicInteger(1);
    final String segment;
    final FieldInfos fieldInfos;
    final IndexInput freqStream;
    final IndexInput proxStream;
    final TermInfosReader tisNoIndex;
    final Directory dir;
    final Directory cfsDir;
    final int readBufferSize;
    final int termsIndexDivisor;
    private final SegmentReader owner;
    TermInfosReader tis;
    FieldsReader fieldsReaderOrig;
    TermVectorsReader termVectorsReaderOrig;
    CompoundFileReader cfsReader;
    CompoundFileReader storeCFSReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentCoreReaders(SegmentReader segmentReader, Directory directory, SegmentInfo segmentInfo, int n, int n2) throws IOException {
        this.segment = segmentInfo.name;
        this.readBufferSize = n;
        this.dir = directory;
        boolean bl = false;
        try {
            Directory directory2 = directory;
            if (segmentInfo.getUseCompoundFile()) {
                this.cfsReader = new CompoundFileReader(directory, IndexFileNames.segmentFileName(this.segment, "cfs"), n);
                directory2 = this.cfsReader;
            }
            this.cfsDir = directory2;
            this.fieldInfos = new FieldInfos(this.cfsDir, IndexFileNames.segmentFileName(this.segment, "fnm"));
            this.termsIndexDivisor = n2;
            TermInfosReader termInfosReader = new TermInfosReader(this.cfsDir, this.segment, this.fieldInfos, n, n2);
            if (n2 == -1) {
                this.tisNoIndex = termInfosReader;
            } else {
                this.tis = termInfosReader;
                this.tisNoIndex = null;
            }
            this.freqStream = this.cfsDir.openInput(IndexFileNames.segmentFileName(this.segment, "frq"), n);
            this.proxStream = this.fieldInfos.hasProx() ? this.cfsDir.openInput(IndexFileNames.segmentFileName(this.segment, "prx"), n) : null;
            bl = true;
        }
        finally {
            if (!bl) {
                this.decRef();
            }
        }
        this.owner = segmentReader;
    }

    synchronized TermVectorsReader getTermVectorsReaderOrig() {
        return this.termVectorsReaderOrig;
    }

    synchronized FieldsReader getFieldsReaderOrig() {
        return this.fieldsReaderOrig;
    }

    synchronized void incRef() {
        this.ref.incrementAndGet();
    }

    synchronized Directory getCFSReader() {
        return this.cfsReader;
    }

    synchronized TermInfosReader getTermsReader() {
        if (this.tis != null) {
            return this.tis;
        }
        return this.tisNoIndex;
    }

    synchronized boolean termsIndexIsLoaded() {
        return this.tis != null;
    }

    synchronized void loadTermsIndex(SegmentInfo segmentInfo, int n) throws IOException {
        if (this.tis == null) {
            Directory directory;
            if (segmentInfo.getUseCompoundFile()) {
                if (this.cfsReader == null) {
                    this.cfsReader = new CompoundFileReader(this.dir, IndexFileNames.segmentFileName(this.segment, "cfs"), this.readBufferSize);
                }
                directory = this.cfsReader;
            } else {
                directory = this.dir;
            }
            this.tis = new TermInfosReader(directory, this.segment, this.fieldInfos, this.readBufferSize, n);
        }
    }

    synchronized void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            IOUtils.close(this.tis, this.tisNoIndex, this.freqStream, this.proxStream, this.termVectorsReaderOrig, this.fieldsReaderOrig, this.cfsReader, this.storeCFSReader);
            this.tis = null;
            if (this.owner != null) {
                this.owner.notifyReaderFinishedListeners();
            }
        }
    }

    synchronized void openDocStores(SegmentInfo segmentInfo) throws IOException {
        assert (segmentInfo.name.equals(this.segment));
        if (this.fieldsReaderOrig == null) {
            Directory directory;
            if (segmentInfo.getDocStoreOffset() != -1) {
                if (segmentInfo.getDocStoreIsCompoundFile()) {
                    assert (this.storeCFSReader == null);
                    this.storeCFSReader = new CompoundFileReader(this.dir, IndexFileNames.segmentFileName(segmentInfo.getDocStoreSegment(), "cfx"), this.readBufferSize);
                    directory = this.storeCFSReader;
                    assert (directory != null);
                } else {
                    directory = this.dir;
                    assert (directory != null);
                }
            } else if (segmentInfo.getUseCompoundFile()) {
                if (this.cfsReader == null) {
                    this.cfsReader = new CompoundFileReader(this.dir, IndexFileNames.segmentFileName(this.segment, "cfs"), this.readBufferSize);
                }
                directory = this.cfsReader;
                assert (directory != null);
            } else {
                directory = this.dir;
                assert (directory != null);
            }
            String string = segmentInfo.getDocStoreOffset() != -1 ? segmentInfo.getDocStoreSegment() : this.segment;
            this.fieldsReaderOrig = new FieldsReader(directory, string, this.fieldInfos, this.readBufferSize, segmentInfo.getDocStoreOffset(), segmentInfo.docCount);
            if (segmentInfo.getDocStoreOffset() == -1 && this.fieldsReaderOrig.size() != segmentInfo.docCount) {
                throw new CorruptIndexException("doc counts differ for segment " + this.segment + ": fieldsReader shows " + this.fieldsReaderOrig.size() + " but segmentInfo shows " + segmentInfo.docCount);
            }
            if (segmentInfo.getHasVectors()) {
                this.termVectorsReaderOrig = new TermVectorsReader(directory, string, this.fieldInfos, this.readBufferSize, segmentInfo.getDocStoreOffset(), segmentInfo.docCount);
            }
        }
    }

    public String toString() {
        return "SegmentCoreReader(owner=" + this.owner + ")";
    }
}

