/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.util.MapBackedSet;

public class ParallelReader
extends IndexReader {
    private List<IndexReader> readers = new ArrayList<IndexReader>();
    private List<Boolean> decrefOnClose = new ArrayList<Boolean>();
    boolean incRefReaders = false;
    private SortedMap<String, IndexReader> fieldToReader = new TreeMap<String, IndexReader>();
    private Map<IndexReader, Collection<String>> readerToFields = new HashMap<IndexReader, Collection<String>>();
    private List<IndexReader> storedFieldReaders = new ArrayList<IndexReader>();
    private int maxDoc;
    private int numDocs;
    private boolean hasDeletions;

    public ParallelReader() throws IOException {
        this(true);
    }

    public ParallelReader(boolean bl) throws IOException {
        this.incRefReaders = !bl;
        this.readerFinishedListeners = new MapBackedSet(new ConcurrentHashMap());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ParallelReader(");
        Iterator<IndexReader> iterator = this.readers.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(", ").append(iterator.next());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public void add(IndexReader indexReader) throws IOException {
        this.ensureOpen();
        this.add(indexReader, false);
    }

    public void add(IndexReader indexReader, boolean bl) throws IOException {
        this.ensureOpen();
        if (this.readers.size() == 0) {
            this.maxDoc = indexReader.maxDoc();
            this.numDocs = indexReader.numDocs();
            this.hasDeletions = indexReader.hasDeletions();
        }
        if (indexReader.maxDoc() != this.maxDoc) {
            throw new IllegalArgumentException("All readers must have same maxDoc: " + this.maxDoc + "!=" + indexReader.maxDoc());
        }
        if (indexReader.numDocs() != this.numDocs) {
            throw new IllegalArgumentException("All readers must have same numDocs: " + this.numDocs + "!=" + indexReader.numDocs());
        }
        Collection<String> collection = indexReader.getFieldNames(IndexReader.FieldOption.ALL);
        this.readerToFields.put(indexReader, collection);
        for (String string : collection) {
            if (this.fieldToReader.get(string) != null) continue;
            this.fieldToReader.put(string, indexReader);
        }
        if (!bl) {
            this.storedFieldReaders.add(indexReader);
        }
        this.readers.add(indexReader);
        if (this.incRefReaders) {
            indexReader.incRef();
        }
        this.decrefOnClose.add(this.incRefReaders);
    }

    @Override
    public synchronized Object clone() {
        try {
            return this.doReopen(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected synchronized IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        return this.doReopen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexReader doReopen(boolean bl) throws CorruptIndexException, IOException {
        IndexReader indexReader2;
        this.ensureOpen();
        boolean bl2 = false;
        ArrayList<IndexReader> arrayList = new ArrayList<IndexReader>();
        boolean bl3 = false;
        try {
            for (IndexReader indexReader2 : this.readers) {
                IndexReader indexReader3 = null;
                if (bl) {
                    indexReader3 = (IndexReader)indexReader2.clone();
                    bl2 = true;
                } else {
                    indexReader3 = IndexReader.openIfChanged(indexReader2);
                    if (indexReader3 != null) {
                        bl2 = true;
                    } else {
                        indexReader3 = indexReader2;
                    }
                }
                arrayList.add(indexReader3);
            }
            bl3 = true;
        }
        finally {
            if (!bl3 && bl2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    indexReader2 = (IndexReader)arrayList.get(i);
                    if (indexReader2 == this.readers.get(i)) continue;
                    try {
                        indexReader2.close();
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (bl2) {
            ArrayList arrayList2 = new ArrayList();
            indexReader2 = new ParallelReader();
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader indexReader4 = this.readers.get(i);
                IndexReader indexReader5 = (IndexReader)arrayList.get(i);
                if (indexReader5 == indexReader4) {
                    arrayList2.add(Boolean.TRUE);
                    indexReader5.incRef();
                } else {
                    arrayList2.add(Boolean.FALSE);
                }
                ((ParallelReader)indexReader2).add(indexReader5, !this.storedFieldReaders.contains(indexReader4));
            }
            ((ParallelReader)indexReader2).decrefOnClose = arrayList2;
            ((ParallelReader)indexReader2).incRefReaders = this.incRefReaders;
            return indexReader2;
        }
        return null;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public boolean hasDeletions() {
        this.ensureOpen();
        return this.hasDeletions;
    }

    @Override
    public boolean isDeleted(int n) {
        if (this.readers.size() > 0) {
            return this.readers.get(0).isDeleted(n);
        }
        return false;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        for (IndexReader indexReader : this.readers) {
            indexReader.deleteDocument(n);
        }
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (IndexReader indexReader : this.readers) {
            indexReader.undeleteAll();
        }
        this.hasDeletions = false;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        Document document = new Document();
        for (IndexReader indexReader : this.storedFieldReaders) {
            Collection<String> collection;
            boolean bl;
            boolean bl2 = bl = fieldSelector == null;
            if (!bl) {
                collection = this.readerToFields.get(indexReader);
                for (String string : collection) {
                    if (fieldSelector.accept(string) == FieldSelectorResult.NO_LOAD) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            collection = indexReader.document(n, fieldSelector).getFields();
            for (Fieldable fieldable : collection) {
                document.add(fieldable);
            }
        }
        return document;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        ArrayList<TermFreqVector> arrayList = new ArrayList<TermFreqVector>();
        for (Map.Entry<String, IndexReader> entry : this.fieldToReader.entrySet()) {
            String string = entry.getKey();
            IndexReader indexReader = entry.getValue();
            TermFreqVector termFreqVector = indexReader.getTermFreqVector(n, string);
            if (termFreqVector == null) continue;
            arrayList.add(termFreqVector);
        }
        return arrayList.toArray(new TermFreqVector[arrayList.size()]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String string) throws IOException {
        this.ensureOpen();
        IndexReader indexReader = (IndexReader)this.fieldToReader.get(string);
        return indexReader == null ? null : indexReader.getTermFreqVector(n, string);
    }

    @Override
    public void getTermFreqVector(int n, String string, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        IndexReader indexReader = (IndexReader)this.fieldToReader.get(string);
        if (indexReader != null) {
            indexReader.getTermFreqVector(n, string, termVectorMapper);
        }
    }

    @Override
    public void getTermFreqVector(int n, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        for (Map.Entry<String, IndexReader> entry : this.fieldToReader.entrySet()) {
            String string = entry.getKey();
            IndexReader indexReader = entry.getValue();
            indexReader.getTermFreqVector(n, string, termVectorMapper);
        }
    }

    @Override
    public boolean hasNorms(String string) throws IOException {
        this.ensureOpen();
        IndexReader indexReader = (IndexReader)this.fieldToReader.get(string);
        return indexReader == null ? false : indexReader.hasNorms(string);
    }

    @Override
    public byte[] norms(String string) throws IOException {
        this.ensureOpen();
        IndexReader indexReader = (IndexReader)this.fieldToReader.get(string);
        return indexReader == null ? null : indexReader.norms(string);
    }

    @Override
    public void norms(String string, byte[] byArray, int n) throws IOException {
        this.ensureOpen();
        IndexReader indexReader = (IndexReader)this.fieldToReader.get(string);
        if (indexReader != null) {
            indexReader.norms(string, byArray, n);
        }
    }

    @Override
    protected void doSetNorm(int n, String string, byte by) throws CorruptIndexException, IOException {
        IndexReader indexReader = (IndexReader)this.fieldToReader.get(string);
        if (indexReader != null) {
            indexReader.doSetNorm(n, string, by);
        }
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum();
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum(term);
    }

    @Override
    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        IndexReader indexReader = (IndexReader)this.fieldToReader.get(term.field());
        return indexReader == null ? 0 : indexReader.docFreq(term);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs(term);
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs();
    }

    @Override
    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions();
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        for (IndexReader indexReader : this.readers) {
            if (indexReader.isCurrent()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean isOptimized() {
        this.ensureOpen();
        for (IndexReader indexReader : this.readers) {
            if (indexReader.isOptimized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getVersion() {
        throw new UnsupportedOperationException("ParallelReader does not support this method.");
    }

    IndexReader[] getSubReaders() {
        return this.readers.toArray(new IndexReader[this.readers.size()]);
    }

    @Override
    protected void doCommit(Map<String, String> map) throws IOException {
        for (IndexReader indexReader : this.readers) {
            indexReader.commit(map);
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            if (this.decrefOnClose.get(i).booleanValue()) {
                this.readers.get(i).decRef();
                continue;
            }
            this.readers.get(i).close();
        }
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexReader indexReader : this.readers) {
            Collection<String> collection = indexReader.getFieldNames(fieldOption);
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    @Override
    public void addReaderFinishedListener(IndexReader.ReaderFinishedListener readerFinishedListener) {
        super.addReaderFinishedListener(readerFinishedListener);
        for (IndexReader indexReader : this.readers) {
            indexReader.addReaderFinishedListener(readerFinishedListener);
        }
    }

    @Override
    public void removeReaderFinishedListener(IndexReader.ReaderFinishedListener readerFinishedListener) {
        super.removeReaderFinishedListener(readerFinishedListener);
        for (IndexReader indexReader : this.readers) {
            indexReader.removeReaderFinishedListener(readerFinishedListener);
        }
    }

    private class ParallelTermPositions
    extends ParallelTermDocs
    implements TermPositions {
        public ParallelTermPositions() {
        }

        public ParallelTermPositions(Term term) throws IOException {
            this.seek(term);
        }

        @Override
        public void seek(Term term) throws IOException {
            IndexReader indexReader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = indexReader != null ? indexReader.termPositions(term) : null;
        }

        @Override
        public int nextPosition() throws IOException {
            return ((TermPositions)this.termDocs).nextPosition();
        }

        @Override
        public int getPayloadLength() {
            return ((TermPositions)this.termDocs).getPayloadLength();
        }

        @Override
        public byte[] getPayload(byte[] byArray, int n) throws IOException {
            return ((TermPositions)this.termDocs).getPayload(byArray, n);
        }

        @Override
        public boolean isPayloadAvailable() {
            return ((TermPositions)this.termDocs).isPayloadAvailable();
        }
    }

    private class ParallelTermDocs
    implements TermDocs {
        protected TermDocs termDocs;

        public ParallelTermDocs() {
        }

        public ParallelTermDocs(Term term) throws IOException {
            if (term == null) {
                this.termDocs = ParallelReader.this.readers.isEmpty() ? null : ((IndexReader)ParallelReader.this.readers.get(0)).termDocs(null);
            } else {
                this.seek(term);
            }
        }

        @Override
        public int doc() {
            return this.termDocs.doc();
        }

        @Override
        public int freq() {
            return this.termDocs.freq();
        }

        @Override
        public void seek(Term term) throws IOException {
            IndexReader indexReader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = indexReader != null ? indexReader.termDocs(term) : null;
        }

        @Override
        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        @Override
        public boolean next() throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.next();
        }

        @Override
        public int read(int[] nArray, int[] nArray2) throws IOException {
            if (this.termDocs == null) {
                return 0;
            }
            return this.termDocs.read(nArray, nArray2);
        }

        @Override
        public boolean skipTo(int n) throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.skipTo(n);
        }

        @Override
        public void close() throws IOException {
            if (this.termDocs != null) {
                this.termDocs.close();
            }
        }
    }

    private class ParallelTermEnum
    extends TermEnum {
        private String field;
        private Iterator<String> fieldIterator;
        private TermEnum termEnum;

        public ParallelTermEnum() throws IOException {
            try {
                this.field = (String)ParallelReader.this.fieldToReader.firstKey();
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
            if (this.field != null) {
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms();
            }
        }

        public ParallelTermEnum(Term term) throws IOException {
            this.field = term.field();
            IndexReader indexReader = (IndexReader)ParallelReader.this.fieldToReader.get(this.field);
            if (indexReader != null) {
                this.termEnum = indexReader.terms(term);
            }
        }

        @Override
        public boolean next() throws IOException {
            if (this.termEnum == null) {
                return false;
            }
            if (this.termEnum.next() && this.termEnum.term().field() == this.field) {
                return true;
            }
            this.termEnum.close();
            if (this.fieldIterator == null) {
                this.fieldIterator = ParallelReader.this.fieldToReader.tailMap(this.field).keySet().iterator();
                this.fieldIterator.next();
            }
            while (this.fieldIterator.hasNext()) {
                this.field = this.fieldIterator.next();
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms(new Term(this.field));
                Term term = this.termEnum.term();
                if (term != null && term.field() == this.field) {
                    return true;
                }
                this.termEnum.close();
            }
            return false;
        }

        @Override
        public Term term() {
            if (this.termEnum == null) {
                return null;
            }
            return this.termEnum.term();
        }

        @Override
        public int docFreq() {
            if (this.termEnum == null) {
                return 0;
            }
            return this.termEnum.docFreq();
        }

        @Override
        public void close() throws IOException {
            if (this.termEnum != null) {
                this.termEnum.close();
            }
        }
    }
}

