/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;

public final class IndexWriterConfig
implements Cloneable {
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    public static final int DISABLE_AUTO_FLUSH = -1;
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = -1;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = -1;
    public static final double DEFAULT_RAM_BUFFER_SIZE_MB = 16.0;
    public static long WRITE_LOCK_TIMEOUT = 1000L;
    public static final int DEFAULT_MAX_THREAD_STATES = 8;
    public static final boolean DEFAULT_READER_POOLING = false;
    public static final int DEFAULT_READER_TERMS_INDEX_DIVISOR = IndexReader.DEFAULT_TERMS_INDEX_DIVISOR;
    private final Analyzer analyzer;
    private volatile IndexDeletionPolicy delPolicy;
    private volatile IndexCommit commit;
    private volatile OpenMode openMode;
    private volatile Similarity similarity;
    private volatile int termIndexInterval;
    private volatile MergeScheduler mergeScheduler;
    private volatile long writeLockTimeout;
    private volatile int maxBufferedDeleteTerms;
    private volatile double ramBufferSizeMB;
    private volatile int maxBufferedDocs;
    private volatile DocumentsWriter.IndexingChain indexingChain;
    private volatile IndexWriter.IndexReaderWarmer mergedSegmentWarmer;
    private volatile MergePolicy mergePolicy;
    private volatile int maxThreadStates;
    private volatile boolean readerPooling;
    private volatile int readerTermsIndexDivisor;
    private Version matchVersion;

    public static void setDefaultWriteLockTimeout(long l) {
        WRITE_LOCK_TIMEOUT = l;
    }

    public static long getDefaultWriteLockTimeout() {
        return WRITE_LOCK_TIMEOUT;
    }

    public IndexWriterConfig(Version version, Analyzer analyzer) {
        this.matchVersion = version;
        this.analyzer = analyzer;
        this.delPolicy = new KeepOnlyLastCommitDeletionPolicy();
        this.commit = null;
        this.openMode = OpenMode.CREATE_OR_APPEND;
        this.similarity = Similarity.getDefault();
        this.termIndexInterval = 128;
        this.mergeScheduler = new ConcurrentMergeScheduler();
        this.writeLockTimeout = WRITE_LOCK_TIMEOUT;
        this.maxBufferedDeleteTerms = -1;
        this.ramBufferSizeMB = 16.0;
        this.maxBufferedDocs = -1;
        this.indexingChain = DocumentsWriter.defaultIndexingChain;
        this.mergedSegmentWarmer = null;
        this.mergePolicy = version.onOrAfter(Version.LUCENE_32) ? new TieredMergePolicy() : new LogByteSizeMergePolicy();
        this.maxThreadStates = 8;
        this.readerPooling = false;
        this.readerTermsIndexDivisor = DEFAULT_READER_TERMS_INDEX_DIVISOR;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public IndexWriterConfig setOpenMode(OpenMode openMode) {
        this.openMode = openMode;
        return this;
    }

    public OpenMode getOpenMode() {
        return this.openMode;
    }

    public IndexWriterConfig setIndexDeletionPolicy(IndexDeletionPolicy indexDeletionPolicy) {
        this.delPolicy = indexDeletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : indexDeletionPolicy;
        return this;
    }

    public IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.delPolicy;
    }

    public IndexWriterConfig setIndexCommit(IndexCommit indexCommit) {
        this.commit = indexCommit;
        return this;
    }

    public IndexCommit getIndexCommit() {
        return this.commit;
    }

    public IndexWriterConfig setSimilarity(Similarity similarity) {
        this.similarity = similarity == null ? Similarity.getDefault() : similarity;
        return this;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexWriterConfig setTermIndexInterval(int n) {
        this.termIndexInterval = n;
        return this;
    }

    public int getTermIndexInterval() {
        return this.termIndexInterval;
    }

    public IndexWriterConfig setMergeScheduler(MergeScheduler mergeScheduler) {
        this.mergeScheduler = mergeScheduler == null ? new ConcurrentMergeScheduler() : mergeScheduler;
        return this;
    }

    public MergeScheduler getMergeScheduler() {
        return this.mergeScheduler;
    }

    public IndexWriterConfig setWriteLockTimeout(long l) {
        this.writeLockTimeout = l;
        return this;
    }

    public long getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    public IndexWriterConfig setMaxBufferedDeleteTerms(int n) {
        if (n != -1 && n < 1) {
            throw new IllegalArgumentException("maxBufferedDeleteTerms must at least be 1 when enabled");
        }
        this.maxBufferedDeleteTerms = n;
        return this;
    }

    public int getMaxBufferedDeleteTerms() {
        return this.maxBufferedDeleteTerms;
    }

    public IndexWriterConfig setRAMBufferSizeMB(double d) {
        if (d > 2048.0) {
            throw new IllegalArgumentException("ramBufferSize " + d + " is too large; should be comfortably less than 2048");
        }
        if (d != -1.0 && d <= 0.0) {
            throw new IllegalArgumentException("ramBufferSize should be > 0.0 MB when enabled");
        }
        if (d == -1.0 && this.maxBufferedDocs == -1) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.ramBufferSizeMB = d;
        return this;
    }

    public double getRAMBufferSizeMB() {
        return this.ramBufferSizeMB;
    }

    public IndexWriterConfig setMaxBufferedDocs(int n) {
        if (n != -1 && n < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2 when enabled");
        }
        if (n == -1 && this.ramBufferSizeMB == -1.0) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.maxBufferedDocs = n;
        return this;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public IndexWriterConfig setMergedSegmentWarmer(IndexWriter.IndexReaderWarmer indexReaderWarmer) {
        this.mergedSegmentWarmer = indexReaderWarmer;
        return this;
    }

    public IndexWriter.IndexReaderWarmer getMergedSegmentWarmer() {
        return this.mergedSegmentWarmer;
    }

    public IndexWriterConfig setMergePolicy(MergePolicy mergePolicy) {
        this.mergePolicy = mergePolicy == null ? new LogByteSizeMergePolicy() : mergePolicy;
        return this;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public IndexWriterConfig setMaxThreadStates(int n) {
        this.maxThreadStates = n < 1 ? 8 : n;
        return this;
    }

    public int getMaxThreadStates() {
        return this.maxThreadStates;
    }

    public IndexWriterConfig setReaderPooling(boolean bl) {
        this.readerPooling = bl;
        return this;
    }

    public boolean getReaderPooling() {
        return this.readerPooling;
    }

    IndexWriterConfig setIndexingChain(DocumentsWriter.IndexingChain indexingChain) {
        this.indexingChain = indexingChain == null ? DocumentsWriter.defaultIndexingChain : indexingChain;
        return this;
    }

    DocumentsWriter.IndexingChain getIndexingChain() {
        return this.indexingChain;
    }

    public IndexWriterConfig setReaderTermsIndexDivisor(int n) {
        if (n <= 0 && n != -1) {
            throw new IllegalArgumentException("divisor must be >= 1, or -1 (got " + n + ")");
        }
        this.readerTermsIndexDivisor = n;
        return this;
    }

    public int getReaderTermsIndexDivisor() {
        return this.readerTermsIndexDivisor;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("matchVersion=").append((Object)this.matchVersion).append("\n");
        stringBuilder.append("analyzer=").append(this.analyzer == null ? "null" : this.analyzer.getClass().getName()).append("\n");
        stringBuilder.append("delPolicy=").append(this.delPolicy.getClass().getName()).append("\n");
        stringBuilder.append("commit=").append(this.commit == null ? "null" : this.commit).append("\n");
        stringBuilder.append("openMode=").append((Object)this.openMode).append("\n");
        stringBuilder.append("similarity=").append(this.similarity.getClass().getName()).append("\n");
        stringBuilder.append("termIndexInterval=").append(this.termIndexInterval).append("\n");
        stringBuilder.append("mergeScheduler=").append(this.mergeScheduler.getClass().getName()).append("\n");
        stringBuilder.append("default WRITE_LOCK_TIMEOUT=").append(WRITE_LOCK_TIMEOUT).append("\n");
        stringBuilder.append("writeLockTimeout=").append(this.writeLockTimeout).append("\n");
        stringBuilder.append("maxBufferedDeleteTerms=").append(this.maxBufferedDeleteTerms).append("\n");
        stringBuilder.append("ramBufferSizeMB=").append(this.ramBufferSizeMB).append("\n");
        stringBuilder.append("maxBufferedDocs=").append(this.maxBufferedDocs).append("\n");
        stringBuilder.append("mergedSegmentWarmer=").append(this.mergedSegmentWarmer).append("\n");
        stringBuilder.append("mergePolicy=").append(this.mergePolicy).append("\n");
        stringBuilder.append("maxThreadStates=").append(this.maxThreadStates).append("\n");
        stringBuilder.append("readerPooling=").append(this.readerPooling).append("\n");
        stringBuilder.append("readerTermsIndexDivisor=").append(this.readerTermsIndexDivisor).append("\n");
        return stringBuilder.toString();
    }

    public static enum OpenMode {
        CREATE,
        APPEND,
        CREATE_OR_APPEND;

    }
}

