/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.zip.DataFormatException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldReaderException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

final class FieldsReader
implements Cloneable,
Closeable {
    private final FieldInfos fieldInfos;
    private final IndexInput cloneableFieldsStream;
    private final IndexInput fieldsStream;
    private final IndexInput cloneableIndexStream;
    private final IndexInput indexStream;
    private int numTotalDocs;
    private int size;
    private boolean closed;
    private final int format;
    private final int formatSize;
    private int docStoreOffset;
    private CloseableThreadLocal<IndexInput> fieldsStreamTL = new CloseableThreadLocal();
    private boolean isOriginal = false;

    public Object clone() {
        this.ensureOpen();
        return new FieldsReader(this.fieldInfos, this.numTotalDocs, this.size, this.format, this.formatSize, this.docStoreOffset, this.cloneableFieldsStream, this.cloneableIndexStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String detectCodeVersion(Directory directory, String string) throws IOException {
        IndexInput indexInput = directory.openInput(IndexFileNames.segmentFileName(string, "fdx"), 1024);
        try {
            int n = indexInput.readInt();
            if (n < 2) {
                String string2 = "2.x";
                return string2;
            }
            String string3 = "3.0";
            return string3;
        }
        finally {
            indexInput.close();
        }
    }

    private FieldsReader(FieldInfos fieldInfos, int n, int n2, int n3, int n4, int n5, IndexInput indexInput, IndexInput indexInput2) {
        this.fieldInfos = fieldInfos;
        this.numTotalDocs = n;
        this.size = n2;
        this.format = n3;
        this.formatSize = n4;
        this.docStoreOffset = n5;
        this.cloneableFieldsStream = indexInput;
        this.cloneableIndexStream = indexInput2;
        this.fieldsStream = (IndexInput)indexInput.clone();
        this.indexStream = (IndexInput)indexInput2.clone();
    }

    FieldsReader(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this(directory, string, fieldInfos, 1024, -1, 0);
    }

    FieldsReader(Directory directory, String string, FieldInfos fieldInfos, int n) throws IOException {
        this(directory, string, fieldInfos, n, -1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsReader(Directory directory, String string, FieldInfos fieldInfos, int n, int n2, int n3) throws IOException {
        boolean bl = false;
        this.isOriginal = true;
        try {
            this.fieldInfos = fieldInfos;
            this.cloneableFieldsStream = directory.openInput(IndexFileNames.segmentFileName(string, "fdt"), n);
            String string2 = IndexFileNames.segmentFileName(string, "fdx");
            this.cloneableIndexStream = directory.openInput(string2, n);
            int n4 = this.cloneableIndexStream.readInt();
            this.format = n4 == 0 ? 0 : n4;
            if (this.format > 3) {
                throw new IndexFormatTooNewException(this.cloneableIndexStream, this.format, 0, 3);
            }
            this.formatSize = this.format > 0 ? 4 : 0;
            if (this.format < 1) {
                this.cloneableFieldsStream.setModifiedUTF8StringsMode();
            }
            this.fieldsStream = (IndexInput)this.cloneableFieldsStream.clone();
            long l = this.cloneableIndexStream.length() - (long)this.formatSize;
            if (n2 != -1) {
                this.docStoreOffset = n2;
                this.size = n3;
                assert ((int)(l / 8L) >= n3 + this.docStoreOffset) : "indexSize=" + l + " size=" + n3 + " docStoreOffset=" + n2;
            } else {
                this.docStoreOffset = 0;
                this.size = (int)(l >> 3);
            }
            this.indexStream = (IndexInput)this.cloneableIndexStream.clone();
            this.numTotalDocs = (int)(l >> 3);
            bl = true;
        }
        finally {
            if (!bl) {
                this.close();
            }
        }
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            if (this.isOriginal) {
                IOUtils.close(this.fieldsStream, this.indexStream, this.fieldsStreamTL, this.cloneableFieldsStream, this.cloneableIndexStream);
            } else {
                IOUtils.close(this.fieldsStream, this.indexStream, this.fieldsStreamTL);
            }
            this.closed = true;
        }
    }

    final int size() {
        return this.size;
    }

    private final void seekIndex(int n) throws IOException {
        this.indexStream.seek((long)this.formatSize + (long)(n + this.docStoreOffset) * 8L);
    }

    boolean canReadRawDocs() {
        return this.format >= 2;
    }

    final Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.seekIndex(n);
        long l = this.indexStream.readLong();
        this.fieldsStream.seek(l);
        Document document = new Document();
        int n2 = this.fieldsStream.readVInt();
        block8: for (int i = 0; i < n2; ++i) {
            boolean bl;
            int n3 = this.fieldsStream.readVInt();
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n3);
            FieldSelectorResult fieldSelectorResult = fieldSelector == null ? FieldSelectorResult.LOAD : fieldSelector.accept(fieldInfo.name);
            int n4 = this.fieldsStream.readByte() & 0xFF;
            assert (n4 <= 63) : "bits=" + Integer.toHexString(n4);
            boolean bl2 = bl = (n4 & 4) != 0;
            assert (!bl || this.format < 2) : "compressed fields are only allowed in indexes of version <= 2.9";
            boolean bl3 = (n4 & 1) != 0;
            boolean bl4 = (n4 & 2) != 0;
            int n5 = n4 & 0x38;
            switch (fieldSelectorResult) {
                case LOAD: {
                    this.addField(document, fieldInfo, bl4, bl, bl3, n5);
                    continue block8;
                }
                case LOAD_AND_BREAK: {
                    this.addField(document, fieldInfo, bl4, bl, bl3, n5);
                    break block8;
                }
                case LAZY_LOAD: {
                    this.addFieldLazy(document, fieldInfo, bl4, bl, bl3, true, n5);
                    continue block8;
                }
                case LATENT: {
                    this.addFieldLazy(document, fieldInfo, bl4, bl, bl3, false, n5);
                    continue block8;
                }
                case SIZE: {
                    this.skipFieldBytes(bl4, bl, this.addFieldSize(document, fieldInfo, bl4, bl, n5));
                    continue block8;
                }
                case SIZE_AND_BREAK: {
                    this.addFieldSize(document, fieldInfo, bl4, bl, n5);
                    break block8;
                }
                default: {
                    this.skipField(bl4, bl, n5);
                }
            }
        }
        return document;
    }

    final IndexInput rawDocs(int[] nArray, int n, int n2) throws IOException {
        long l;
        this.seekIndex(n);
        long l2 = l = this.indexStream.readLong();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.docStoreOffset + n + n3 + 1;
            assert (n4 <= this.numTotalDocs);
            long l3 = n4 < this.numTotalDocs ? this.indexStream.readLong() : this.fieldsStream.length();
            nArray[n3++] = (int)(l3 - l2);
            l2 = l3;
        }
        this.fieldsStream.seek(l);
        return this.fieldsStream;
    }

    private void skipField(boolean bl, boolean bl2, int n) throws IOException {
        int n2;
        switch (n) {
            case 0: {
                n2 = this.fieldsStream.readVInt();
                break;
            }
            case 8: 
            case 24: {
                n2 = 4;
                break;
            }
            case 16: 
            case 32: {
                n2 = 8;
                break;
            }
            default: {
                throw new FieldReaderException("Invalid numeric type: " + Integer.toHexString(n));
            }
        }
        this.skipFieldBytes(bl, bl2, n2);
    }

    private void skipFieldBytes(boolean bl, boolean bl2, int n) throws IOException {
        if (this.format >= 1 || bl || bl2) {
            this.fieldsStream.seek(this.fieldsStream.getFilePointer() + (long)n);
        } else {
            this.fieldsStream.skipChars(n);
        }
    }

    private NumericField loadNumericField(FieldInfo fieldInfo, int n) throws IOException {
        assert (n != 0);
        switch (n) {
            case 8: {
                return new NumericField(fieldInfo.name, Field.Store.YES, fieldInfo.isIndexed).setIntValue(this.fieldsStream.readInt());
            }
            case 16: {
                return new NumericField(fieldInfo.name, Field.Store.YES, fieldInfo.isIndexed).setLongValue(this.fieldsStream.readLong());
            }
            case 24: {
                return new NumericField(fieldInfo.name, Field.Store.YES, fieldInfo.isIndexed).setFloatValue(Float.intBitsToFloat(this.fieldsStream.readInt()));
            }
            case 32: {
                return new NumericField(fieldInfo.name, Field.Store.YES, fieldInfo.isIndexed).setDoubleValue(Double.longBitsToDouble(this.fieldsStream.readLong()));
            }
        }
        throw new FieldReaderException("Invalid numeric type: " + Integer.toHexString(n));
    }

    private void addFieldLazy(Document document, FieldInfo fieldInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) throws IOException {
        AbstractField abstractField;
        if (bl) {
            int n2 = this.fieldsStream.readVInt();
            long l = this.fieldsStream.getFilePointer();
            abstractField = new LazyField(fieldInfo.name, Field.Store.YES, n2, l, bl, bl2, bl4);
            this.fieldsStream.seek(l + (long)n2);
        } else if (n != 0) {
            abstractField = this.loadNumericField(fieldInfo, n);
        } else {
            Field.Store store = Field.Store.YES;
            Field.Index index = Field.Index.toIndex(fieldInfo.isIndexed, bl3);
            Field.TermVector termVector = Field.TermVector.toTermVector(fieldInfo.storeTermVector, fieldInfo.storeOffsetWithTermVector, fieldInfo.storePositionWithTermVector);
            if (bl2) {
                int n3 = this.fieldsStream.readVInt();
                long l = this.fieldsStream.getFilePointer();
                abstractField = new LazyField(fieldInfo.name, store, n3, l, bl, bl2, bl4);
                this.fieldsStream.seek(l + (long)n3);
            } else {
                int n4 = this.fieldsStream.readVInt();
                long l = this.fieldsStream.getFilePointer();
                if (this.format >= 1) {
                    this.fieldsStream.seek(l + (long)n4);
                } else {
                    this.fieldsStream.skipChars(n4);
                }
                abstractField = new LazyField(fieldInfo.name, store, index, termVector, n4, l, bl, bl2, bl4);
            }
        }
        abstractField.setOmitNorms(fieldInfo.omitNorms);
        abstractField.setIndexOptions(fieldInfo.indexOptions);
        document.add(abstractField);
    }

    private void addField(Document document, FieldInfo fieldInfo, boolean bl, boolean bl2, boolean bl3, int n) throws CorruptIndexException, IOException {
        AbstractField abstractField;
        if (bl) {
            int n2 = this.fieldsStream.readVInt();
            byte[] byArray = new byte[n2];
            this.fieldsStream.readBytes(byArray, 0, byArray.length);
            abstractField = bl2 ? new Field(fieldInfo.name, this.uncompress(byArray)) : new Field(fieldInfo.name, byArray);
        } else if (n != 0) {
            abstractField = this.loadNumericField(fieldInfo, n);
        } else {
            Field.Store store = Field.Store.YES;
            Field.Index index = Field.Index.toIndex(fieldInfo.isIndexed, bl3);
            Field.TermVector termVector = Field.TermVector.toTermVector(fieldInfo.storeTermVector, fieldInfo.storeOffsetWithTermVector, fieldInfo.storePositionWithTermVector);
            if (bl2) {
                int n3 = this.fieldsStream.readVInt();
                byte[] byArray = new byte[n3];
                this.fieldsStream.readBytes(byArray, 0, byArray.length);
                abstractField = new Field(fieldInfo.name, false, new String(this.uncompress(byArray), "UTF-8"), store, index, termVector);
            } else {
                abstractField = new Field(fieldInfo.name, false, this.fieldsStream.readString(), store, index, termVector);
            }
        }
        abstractField.setIndexOptions(fieldInfo.indexOptions);
        abstractField.setOmitNorms(fieldInfo.omitNorms);
        document.add(abstractField);
    }

    private int addFieldSize(Document document, FieldInfo fieldInfo, boolean bl, boolean bl2, int n) throws IOException {
        int n2;
        int n3;
        switch (n) {
            case 0: {
                n3 = this.fieldsStream.readVInt();
                n2 = bl || bl2 ? n3 : 2 * n3;
                break;
            }
            case 8: 
            case 24: {
                n2 = 4;
                n3 = 4;
                break;
            }
            case 16: 
            case 32: {
                n2 = 8;
                n3 = 8;
                break;
            }
            default: {
                throw new FieldReaderException("Invalid numeric type: " + Integer.toHexString(n));
            }
        }
        byte[] byArray = new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
        document.add(new Field(fieldInfo.name, byArray));
        return n3;
    }

    private byte[] uncompress(byte[] byArray) throws CorruptIndexException {
        try {
            return CompressionTools.decompress(byArray);
        }
        catch (DataFormatException dataFormatException) {
            CorruptIndexException corruptIndexException = new CorruptIndexException("field data are in wrong format: " + dataFormatException.toString());
            corruptIndexException.initCause(dataFormatException);
            throw corruptIndexException;
        }
    }

    private class LazyField
    extends AbstractField
    implements Fieldable {
        private int toRead;
        private long pointer;
        @Deprecated
        private boolean isCompressed;
        private boolean cacheResult;

        public LazyField(String string, Field.Store store, int n, long l, boolean bl, boolean bl2, boolean bl3) {
            super(string, store, Field.Index.NO, Field.TermVector.NO);
            this.toRead = n;
            this.pointer = l;
            this.isBinary = bl;
            this.cacheResult = bl3;
            if (bl) {
                this.binaryLength = n;
            }
            this.lazy = true;
            this.isCompressed = bl2;
        }

        public LazyField(String string, Field.Store store, Field.Index index, Field.TermVector termVector, int n, long l, boolean bl, boolean bl2, boolean bl3) {
            super(string, store, index, termVector);
            this.toRead = n;
            this.pointer = l;
            this.isBinary = bl;
            this.cacheResult = bl3;
            if (bl) {
                this.binaryLength = n;
            }
            this.lazy = true;
            this.isCompressed = bl2;
        }

        private IndexInput getFieldStream() {
            IndexInput indexInput = (IndexInput)FieldsReader.this.fieldsStreamTL.get();
            if (indexInput == null) {
                indexInput = (IndexInput)FieldsReader.this.cloneableFieldsStream.clone();
                FieldsReader.this.fieldsStreamTL.set(indexInput);
            }
            return indexInput;
        }

        @Override
        public Reader readerValue() {
            FieldsReader.this.ensureOpen();
            return null;
        }

        @Override
        public TokenStream tokenStreamValue() {
            FieldsReader.this.ensureOpen();
            return null;
        }

        @Override
        public String stringValue() {
            FieldsReader.this.ensureOpen();
            if (this.isBinary) {
                return null;
            }
            if (this.fieldsData == null) {
                String string;
                IndexInput indexInput = this.getFieldStream();
                try {
                    indexInput.seek(this.pointer);
                    if (this.isCompressed) {
                        byte[] byArray = new byte[this.toRead];
                        indexInput.readBytes(byArray, 0, byArray.length);
                        string = new String(FieldsReader.this.uncompress(byArray), "UTF-8");
                    } else if (FieldsReader.this.format >= 1) {
                        byte[] byArray = new byte[this.toRead];
                        indexInput.readBytes(byArray, 0, this.toRead);
                        string = new String(byArray, "UTF-8");
                    } else {
                        char[] cArray = new char[this.toRead];
                        indexInput.readChars(cArray, 0, this.toRead);
                        string = new String(cArray);
                    }
                }
                catch (IOException iOException) {
                    throw new FieldReaderException(iOException);
                }
                if (this.cacheResult) {
                    this.fieldsData = string;
                }
                return string;
            }
            return (String)this.fieldsData;
        }

        public long getPointer() {
            FieldsReader.this.ensureOpen();
            return this.pointer;
        }

        public void setPointer(long l) {
            FieldsReader.this.ensureOpen();
            this.pointer = l;
        }

        public int getToRead() {
            FieldsReader.this.ensureOpen();
            return this.toRead;
        }

        public void setToRead(int n) {
            FieldsReader.this.ensureOpen();
            this.toRead = n;
        }

        @Override
        public byte[] getBinaryValue(byte[] byArray) {
            FieldsReader.this.ensureOpen();
            if (this.isBinary) {
                if (this.fieldsData == null) {
                    byte[] byArray2;
                    byte[] byArray3 = byArray == null || byArray.length < this.toRead ? new byte[this.toRead] : byArray;
                    IndexInput indexInput = this.getFieldStream();
                    try {
                        indexInput.seek(this.pointer);
                        indexInput.readBytes(byArray3, 0, this.toRead);
                        byArray2 = this.isCompressed ? FieldsReader.this.uncompress(byArray3) : byArray3;
                    }
                    catch (IOException iOException) {
                        throw new FieldReaderException(iOException);
                    }
                    this.binaryOffset = 0;
                    this.binaryLength = this.toRead;
                    if (this.cacheResult) {
                        this.fieldsData = byArray2;
                    }
                    return byArray2;
                }
                return (byte[])this.fieldsData;
            }
            return null;
        }
    }
}

