/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

public final class FieldInfo {
    final String name;
    final int number;
    boolean isIndexed;
    boolean storeTermVector;
    boolean storeOffsetWithTermVector;
    boolean storePositionWithTermVector;
    public boolean omitNorms;
    public IndexOptions indexOptions;
    boolean storePayloads;

    FieldInfo(String string, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, IndexOptions indexOptions) {
        this.name = string;
        this.isIndexed = bl;
        this.number = n;
        if (this.isIndexed) {
            this.storeTermVector = bl2;
            this.storeOffsetWithTermVector = bl4;
            this.storePositionWithTermVector = bl3;
            this.storePayloads = bl6;
            this.omitNorms = bl5;
            this.indexOptions = indexOptions;
        } else {
            this.storeTermVector = false;
            this.storeOffsetWithTermVector = false;
            this.storePositionWithTermVector = false;
            this.storePayloads = false;
            this.omitNorms = true;
            this.indexOptions = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        assert (indexOptions == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !bl6);
    }

    public Object clone() {
        return new FieldInfo(this.name, this.isIndexed, this.number, this.storeTermVector, this.storePositionWithTermVector, this.storeOffsetWithTermVector, this.omitNorms, this.storePayloads, this.indexOptions);
    }

    void update(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, IndexOptions indexOptions) {
        if (this.isIndexed != bl) {
            this.isIndexed = true;
        }
        if (bl) {
            if (this.storeTermVector != bl2) {
                this.storeTermVector = true;
            }
            if (this.storePositionWithTermVector != bl3) {
                this.storePositionWithTermVector = true;
            }
            if (this.storeOffsetWithTermVector != bl4) {
                this.storeOffsetWithTermVector = true;
            }
            if (this.storePayloads != bl6) {
                this.storePayloads = true;
            }
            if (this.omitNorms != bl5) {
                this.omitNorms = false;
            }
            if (this.indexOptions != indexOptions) {
                this.indexOptions = this.indexOptions.compareTo(indexOptions) < 0 ? this.indexOptions : indexOptions;
                this.storePayloads = false;
            }
        }
        assert (this.indexOptions == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !this.storePayloads);
    }

    public static enum IndexOptions {
        DOCS_ONLY,
        DOCS_AND_FREQS,
        DOCS_AND_FREQS_AND_POSITIONS;

    }
}

