/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BufferedDeletes;
import org.apache.lucene.index.BufferedDeletesStream;
import org.apache.lucene.index.ByteBlockPool;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessor;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.FrozenBufferedDeletes;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NormsWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermVectorsTermsWriter;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.ThreadInterruptedException;

final class DocumentsWriter {
    final AtomicLong bytesUsed = new AtomicLong(0L);
    IndexWriter writer;
    Directory directory;
    String segment;
    private int nextDocID;
    private int numDocs;
    private DocumentsWriterThreadState[] threadStates = new DocumentsWriterThreadState[0];
    private final HashMap<Thread, DocumentsWriterThreadState> threadBindings = new HashMap();
    boolean bufferIsFull;
    private boolean aborting;
    PrintStream infoStream;
    int maxFieldLength = IndexWriter.DEFAULT_MAX_FIELD_LENGTH;
    Similarity similarity;
    private final int maxThreadStates;
    private BufferedDeletes pendingDeletes = new BufferedDeletes();
    static final IndexingChain defaultIndexingChain = new IndexingChain(){

        @Override
        DocConsumer getChain(DocumentsWriter documentsWriter) {
            TermVectorsTermsWriter termVectorsTermsWriter = new TermVectorsTermsWriter(documentsWriter);
            FreqProxTermsWriter freqProxTermsWriter = new FreqProxTermsWriter();
            TermsHash termsHash = new TermsHash(documentsWriter, true, freqProxTermsWriter, new TermsHash(documentsWriter, false, termVectorsTermsWriter, null));
            NormsWriter normsWriter = new NormsWriter();
            DocInverter docInverter = new DocInverter(termsHash, normsWriter);
            return new DocFieldProcessor(documentsWriter, docInverter);
        }
    };
    final DocConsumer consumer;
    private final IndexWriterConfig config;
    private boolean closed;
    private final FieldInfos fieldInfos;
    private final BufferedDeletesStream bufferedDeletesStream;
    private final IndexWriter.FlushControl flushControl;
    final SkipDocWriter skipDocWriter = new SkipDocWriter();
    NumberFormat nf = NumberFormat.getInstance();
    static final int BYTE_BLOCK_SHIFT = 15;
    static final int BYTE_BLOCK_SIZE = 32768;
    static final int BYTE_BLOCK_MASK = Short.MAX_VALUE;
    static final int BYTE_BLOCK_NOT_MASK = Short.MIN_VALUE;
    static final int INT_BLOCK_SHIFT = 13;
    static final int INT_BLOCK_SIZE = 8192;
    static final int INT_BLOCK_MASK = 8191;
    private List<int[]> freeIntBlocks = new ArrayList<int[]>();
    ByteBlockAllocator byteBlockAllocator = new ByteBlockAllocator(32768);
    static final int PER_DOC_BLOCK_SIZE = 1024;
    final ByteBlockAllocator perDocAllocator = new ByteBlockAllocator(1024);
    static final int CHAR_BLOCK_SHIFT = 14;
    static final int CHAR_BLOCK_SIZE = 16384;
    static final int CHAR_BLOCK_MASK = 16383;
    static final int MAX_TERM_LENGTH = 16383;
    private ArrayList<char[]> freeCharBlocks = new ArrayList();
    final WaitQueue waitQueue = new WaitQueue();

    PerDocBuffer newPerDocBuffer() {
        return new PerDocBuffer();
    }

    DocumentsWriter(IndexWriterConfig indexWriterConfig, Directory directory, IndexWriter indexWriter, FieldInfos fieldInfos, BufferedDeletesStream bufferedDeletesStream) throws IOException {
        this.directory = directory;
        this.writer = indexWriter;
        this.similarity = indexWriterConfig.getSimilarity();
        this.maxThreadStates = indexWriterConfig.getMaxThreadStates();
        this.fieldInfos = fieldInfos;
        this.bufferedDeletesStream = bufferedDeletesStream;
        this.flushControl = indexWriter.flushControl;
        this.consumer = indexWriterConfig.getIndexingChain().getChain(this);
        this.config = indexWriterConfig;
    }

    synchronized void deleteDocID(int n) {
        this.pendingDeletes.addDocID(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteQueries(Query ... queryArray) {
        boolean bl = this.flushControl.waitUpdate(0, queryArray.length);
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            for (Query query : queryArray) {
                this.pendingDeletes.addQuery(query, this.numDocs);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteQuery(Query query) {
        boolean bl = this.flushControl.waitUpdate(0, 1);
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            this.pendingDeletes.addQuery(query, this.numDocs);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteTerms(Term ... termArray) {
        boolean bl = this.flushControl.waitUpdate(0, termArray.length);
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            for (Term term : termArray) {
                this.pendingDeletes.addTerm(term, this.numDocs);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteTerm(Term term, boolean bl) {
        boolean bl2 = this.flushControl.waitUpdate(0, 1, bl);
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            this.pendingDeletes.addTerm(term, this.numDocs);
        }
        return bl2;
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    synchronized void setInfoStream(PrintStream printStream) {
        this.infoStream = printStream;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.infoStream = printStream;
        }
    }

    synchronized void setMaxFieldLength(int n) {
        this.maxFieldLength = n;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.maxFieldLength = n;
        }
    }

    synchronized void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.similarity = similarity;
        }
    }

    synchronized String getSegment() {
        return this.segment;
    }

    synchronized int getNumDocs() {
        return this.numDocs;
    }

    void message(String string) {
        if (this.infoStream != null) {
            this.writer.message("DW: " + string);
        }
    }

    synchronized void setAborting() {
        if (this.infoStream != null) {
            this.message("setAborting");
        }
        this.aborting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void abort() throws IOException {
        if (this.infoStream != null) {
            this.message("docWriter: abort");
        }
        boolean bl = false;
        try {
            block22: {
                try {
                    this.waitQueue.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.waitIdle();
                    if (this.infoStream != null) {
                        this.message("docWriter: abort waitIdle done");
                    }
                    if ($assertionsDisabled || 0 == this.waitQueue.numWaiting) break block22;
                    throw new AssertionError((Object)("waitQueue.numWaiting=" + this.waitQueue.numWaiting));
                }
                catch (Throwable throwable) {
                    if (this.infoStream != null) {
                        this.message("docWriter: abort waitIdle done");
                    }
                    assert (0 == this.waitQueue.numWaiting) : "waitQueue.numWaiting=" + this.waitQueue.numWaiting;
                    this.waitQueue.waitingBytes = 0L;
                    this.pendingDeletes.clear();
                    for (DocumentsWriterThreadState documentsWriterThreadState : this.threadStates) {
                        try {
                            documentsWriterThreadState.consumer.abort();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    try {
                        this.consumer.abort();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    this.doAfterFlush();
                    throw throwable;
                }
            }
            this.waitQueue.waitingBytes = 0L;
            this.pendingDeletes.clear();
            for (DocumentsWriterThreadState documentsWriterThreadState : this.threadStates) {
                try {
                    documentsWriterThreadState.consumer.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.consumer.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.doAfterFlush();
            bl = true;
            return;
        }
        finally {
            this.aborting = false;
            this.notifyAll();
            if (this.infoStream != null) {
                this.message("docWriter: done abort; success=" + bl);
            }
        }
    }

    private void doAfterFlush() throws IOException {
        assert (this.allThreadsIdle());
        this.threadBindings.clear();
        this.waitQueue.reset();
        this.segment = null;
        this.numDocs = 0;
        this.nextDocID = 0;
        this.bufferIsFull = false;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].doAfterFlush();
        }
    }

    private synchronized boolean allThreadsIdle() {
        for (int i = 0; i < this.threadStates.length; ++i) {
            if (this.threadStates[i].isIdle) continue;
            return false;
        }
        return true;
    }

    synchronized boolean anyChanges() {
        return this.numDocs != 0 || this.pendingDeletes.any();
    }

    public BufferedDeletes getPendingDeletes() {
        return this.pendingDeletes;
    }

    private void pushDeletes(SegmentInfo segmentInfo, SegmentInfos segmentInfos) {
        long l = this.bufferedDeletesStream.getNextGen();
        if (this.pendingDeletes.any()) {
            if (segmentInfos.size() > 0 || segmentInfo != null) {
                FrozenBufferedDeletes frozenBufferedDeletes = new FrozenBufferedDeletes(this.pendingDeletes, l);
                if (this.infoStream != null) {
                    this.message("flush: push buffered deletes startSize=" + this.pendingDeletes.bytesUsed.get() + " frozenSize=" + frozenBufferedDeletes.bytesUsed);
                }
                this.bufferedDeletesStream.push(frozenBufferedDeletes);
                if (this.infoStream != null) {
                    this.message("flush: delGen=" + frozenBufferedDeletes.gen);
                }
                if (segmentInfo != null) {
                    segmentInfo.setBufferedDeletesGen(frozenBufferedDeletes.gen);
                }
            } else if (this.infoStream != null) {
                this.message("flush: drop buffered deletes: no segments");
            }
            this.pendingDeletes.clear();
        } else if (segmentInfo != null) {
            segmentInfo.setBufferedDeletesGen(l);
        }
    }

    public boolean anyDeletions() {
        return this.pendingDeletes.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SegmentInfo flush(IndexWriter indexWriter, IndexFileDeleter indexFileDeleter, MergePolicy mergePolicy, SegmentInfos segmentInfos) throws IOException {
        SegmentInfo segmentInfo;
        long l = System.currentTimeMillis();
        assert (Thread.holdsLock(indexWriter));
        this.waitIdle();
        if (this.numDocs == 0) {
            if (this.infoStream != null) {
                this.message("flush: no docs; skipping");
            }
            this.pushDeletes(null, segmentInfos);
            return null;
        }
        if (this.aborting) {
            if (this.infoStream != null) {
                this.message("flush: skip because aborting is set");
            }
            return null;
        }
        boolean bl = false;
        try {
            Object object2;
            assert (this.nextDocID == this.numDocs) : "nextDocID=" + this.nextDocID + " numDocs=" + this.numDocs;
            assert (this.waitQueue.numWaiting == 0) : "numWaiting=" + this.waitQueue.numWaiting;
            assert (this.waitQueue.waitingBytes == 0L);
            if (this.infoStream != null) {
                this.message("flush postings as segment " + this.segment + " numDocs=" + this.numDocs);
            }
            SegmentWriteState segmentWriteState = new SegmentWriteState(this.infoStream, this.directory, this.segment, this.fieldInfos, this.numDocs, indexWriter.getConfig().getTermIndexInterval(), this.pendingDeletes);
            if (this.pendingDeletes.docIDs.size() > 0) {
                segmentWriteState.deletedDocs = new BitVector(this.numDocs);
                object2 = this.pendingDeletes.docIDs.iterator();
                while (object2.hasNext()) {
                    int n = object2.next();
                    segmentWriteState.deletedDocs.set(n);
                }
                this.pendingDeletes.bytesUsed.addAndGet(-this.pendingDeletes.docIDs.size() * BufferedDeletes.BYTES_PER_DEL_DOCID);
                this.pendingDeletes.docIDs.clear();
            }
            segmentInfo = new SegmentInfo(this.segment, this.numDocs, this.directory, false, true, this.fieldInfos.hasProx(), false);
            object2 = new HashSet();
            for (DocumentsWriterThreadState object3 : this.threadStates) {
                object2.add(object3.consumer);
            }
            double d = (double)this.bytesUsed() / 1024.0 / 1024.0;
            this.consumer.flush((Collection<DocConsumerPerThread>)object2, segmentWriteState);
            segmentInfo.setHasVectors(segmentWriteState.hasVectors);
            if (this.infoStream != null) {
                this.message("new segment has " + (segmentWriteState.hasVectors ? "vectors" : "no vectors"));
                if (segmentWriteState.deletedDocs != null) {
                    this.message("new segment has " + segmentWriteState.deletedDocs.count() + " deleted docs");
                }
                this.message("flushedFiles=" + segmentInfo.files());
            }
            if (mergePolicy.useCompoundFile(segmentInfos, segmentInfo)) {
                String string = IndexFileNames.segmentFileName(this.segment, "cfs");
                if (this.infoStream != null) {
                    this.message("flush: create compound file \"" + string + "\"");
                }
                CompoundFileWriter compoundFileWriter = new CompoundFileWriter(this.directory, string);
                for (String string2 : segmentInfo.files()) {
                    compoundFileWriter.addFile(string2);
                }
                compoundFileWriter.close();
                indexFileDeleter.deleteNewFiles(segmentInfo.files());
                segmentInfo.setUseCompoundFile(true);
            }
            if (segmentWriteState.deletedDocs != null) {
                int n = segmentWriteState.deletedDocs.count();
                assert (n > 0);
                segmentInfo.setDelCount(n);
                segmentInfo.advanceDelGen();
                String string = segmentInfo.getDelFileName();
                if (this.infoStream != null) {
                    this.message("flush: write " + n + " deletes to " + string);
                }
                boolean bl2 = false;
                try {
                    segmentWriteState.deletedDocs.write(this.directory, string);
                    bl2 = true;
                }
                finally {
                    if (!bl2) {
                        try {
                            this.directory.deleteFile(string);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            if (this.infoStream != null) {
                this.message("flush: segment=" + segmentInfo);
                double d2 = (double)segmentInfo.sizeInBytes(false) / 1024.0 / 1024.0;
                double d3 = (double)segmentInfo.sizeInBytes(true) / 1024.0 / 1024.0;
                this.message("  ramUsed=" + this.nf.format(d) + " MB" + " newFlushedSize=" + this.nf.format(d3) + " MB" + " (" + this.nf.format(d2) + " MB w/o doc stores)" + " docs/MB=" + this.nf.format((double)this.numDocs / d3) + " new/old=" + this.nf.format(100.0 * d2 / d) + "%");
            }
            bl = true;
        }
        finally {
            this.notifyAll();
            if (!bl) {
                if (this.segment != null) {
                    indexFileDeleter.refresh(this.segment);
                }
                this.abort();
            }
        }
        this.doAfterFlush();
        this.pushDeletes(segmentInfo, segmentInfos);
        if (this.infoStream != null) {
            this.message("flush time " + (System.currentTimeMillis() - l) + " msec");
        }
        return segmentInfo;
    }

    synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    synchronized DocumentsWriterThreadState getThreadState(Term term, int n) throws IOException {
        Thread thread = Thread.currentThread();
        assert (!Thread.holdsLock(this.writer));
        DocumentsWriterThreadState documentsWriterThreadState = this.threadBindings.get(thread);
        if (documentsWriterThreadState == null) {
            DocumentsWriterThreadState documentsWriterThreadState2 = null;
            for (int i = 0; i < this.threadStates.length; ++i) {
                DocumentsWriterThreadState documentsWriterThreadState3 = this.threadStates[i];
                if (documentsWriterThreadState2 != null && documentsWriterThreadState3.numThreads >= documentsWriterThreadState2.numThreads) continue;
                documentsWriterThreadState2 = documentsWriterThreadState3;
            }
            if (documentsWriterThreadState2 != null && (documentsWriterThreadState2.numThreads == 0 || this.threadStates.length >= this.maxThreadStates)) {
                documentsWriterThreadState = documentsWriterThreadState2;
                ++documentsWriterThreadState.numThreads;
            } else {
                DocumentsWriterThreadState[] documentsWriterThreadStateArray = new DocumentsWriterThreadState[1 + this.threadStates.length];
                if (this.threadStates.length > 0) {
                    System.arraycopy(this.threadStates, 0, documentsWriterThreadStateArray, 0, this.threadStates.length);
                }
                DocumentsWriterThreadState documentsWriterThreadState4 = new DocumentsWriterThreadState(this);
                documentsWriterThreadStateArray[this.threadStates.length] = documentsWriterThreadState4;
                documentsWriterThreadState = documentsWriterThreadState4;
                this.threadStates = documentsWriterThreadStateArray;
            }
            this.threadBindings.put(thread, documentsWriterThreadState);
        }
        this.waitReady(documentsWriterThreadState);
        if (this.segment == null) {
            this.segment = this.writer.newSegmentName();
            assert (this.numDocs == 0);
        }
        documentsWriterThreadState.docState.docID = this.nextDocID;
        this.nextDocID += n;
        if (term != null) {
            this.pendingDeletes.addTerm(term, documentsWriterThreadState.docState.docID);
        }
        this.numDocs += n;
        documentsWriterThreadState.isIdle = false;
        return documentsWriterThreadState;
    }

    boolean addDocument(Document document, Analyzer analyzer) throws CorruptIndexException, IOException {
        return this.updateDocument(document, analyzer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDocument(Document document, Analyzer analyzer, Term term) throws CorruptIndexException, IOException {
        Object object;
        boolean bl = this.flushControl.waitUpdate(1, term != null ? 1 : 0);
        DocumentsWriterThreadState documentsWriterThreadState = this.getThreadState(term, 1);
        DocState docState = documentsWriterThreadState.docState;
        docState.doc = document;
        docState.analyzer = analyzer;
        boolean bl2 = false;
        try {
            try {
                object = documentsWriterThreadState.consumer.processDocument();
            }
            finally {
                docState.clear();
            }
            this.finishDocument(documentsWriterThreadState, (DocWriter)object);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                if (bl) {
                    this.flushControl.clearFlushPending();
                }
                if (this.infoStream != null) {
                    this.message("exception in updateDocument aborting=" + this.aborting);
                }
                object = this;
                synchronized (object) {
                    documentsWriterThreadState.isIdle = true;
                    this.notifyAll();
                    if (this.aborting) {
                        this.abort();
                    } else {
                        this.skipDocWriter.docID = docState.docID;
                        boolean bl3 = false;
                        try {
                            this.waitQueue.add(this.skipDocWriter);
                            bl3 = true;
                        }
                        finally {
                            if (!bl3) {
                                this.abort();
                                return false;
                            }
                        }
                        this.deleteDocID(documentsWriterThreadState.docState.docID);
                    }
                }
            }
        }
        return bl |= this.flushControl.flushByRAMUsage("new document");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDocuments(Collection<Document> collection, Analyzer analyzer, Term term) throws CorruptIndexException, IOException {
        int n;
        boolean bl = this.flushControl.waitUpdate(collection.size(), term != null ? 1 : 0);
        int n2 = collection.size();
        DocumentsWriterThreadState documentsWriterThreadState = this.getThreadState(null, n2);
        DocState docState = documentsWriterThreadState.docState;
        int n3 = n = docState.docID;
        Object object = collection.iterator();
        while (object.hasNext()) {
            Document document;
            docState.doc = document = object.next();
            docState.analyzer = analyzer;
            docState.docID = n3++;
            boolean bl2 = false;
            try {
                DocWriter docWriter;
                try {
                    docWriter = documentsWriterThreadState.consumer.processDocument();
                }
                finally {
                    docState.clear();
                }
                this.balanceRAM();
                DocumentsWriter documentsWriter = this;
                synchronized (documentsWriter) {
                    block45: {
                        if (!this.aborting) break block45;
                        break;
                    }
                    assert (docWriter == null || docWriter.docID == docState.docID);
                    if (docWriter != null) {
                        this.waitQueue.add(docWriter);
                    } else {
                        this.skipDocWriter.docID = docState.docID;
                        this.waitQueue.add(this.skipDocWriter);
                    }
                }
                bl2 = true;
            }
            finally {
                if (bl2) continue;
                if (bl) {
                    this.message("clearFlushPending!");
                    this.flushControl.clearFlushPending();
                }
                if (this.infoStream != null) {
                    this.message("exception in updateDocuments aborting=" + this.aborting);
                }
                DocumentsWriter documentsWriter = this;
                synchronized (documentsWriter) {
                    documentsWriterThreadState.isIdle = true;
                    this.notifyAll();
                    if (this.aborting) {
                        this.abort();
                    } else {
                        int n4 = n + n2;
                        n3 = docState.docID;
                        while (n3 < n4) {
                            this.skipDocWriter.docID = n3++;
                            boolean bl3 = false;
                            try {
                                this.waitQueue.add(this.skipDocWriter);
                                bl3 = true;
                            }
                            finally {
                                if (bl3) continue;
                                this.abort();
                                return false;
                            }
                        }
                        n3 = n;
                        while (n3 < n + collection.size()) {
                            this.deleteDocID(n3++);
                        }
                    }
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.waitQueue.doPause()) {
                this.waitForWaitQueue();
            }
            if (this.aborting) {
                documentsWriterThreadState.isIdle = true;
                this.notifyAll();
                this.abort();
                if (bl) {
                    this.message("clearFlushPending!");
                    this.flushControl.clearFlushPending();
                }
                return false;
            }
            if (term != null) {
                this.pendingDeletes.addTerm(term, n);
            }
            documentsWriterThreadState.isIdle = true;
            this.notifyAll();
        }
        return bl |= this.flushControl.flushByRAMUsage("new document");
    }

    public synchronized void waitIdle() {
        while (!this.allThreadsIdle()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
        }
    }

    synchronized void waitReady(DocumentsWriterThreadState documentsWriterThreadState) {
        while (!(this.closed || documentsWriterThreadState.isIdle && !this.aborting)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
        }
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishDocument(DocumentsWriterThreadState documentsWriterThreadState, DocWriter docWriter) throws IOException {
        this.balanceRAM();
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            boolean bl;
            assert (docWriter == null || docWriter.docID == documentsWriterThreadState.docState.docID);
            if (this.aborting) {
                if (docWriter != null) {
                    try {
                        docWriter.abort();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                documentsWriterThreadState.isIdle = true;
                this.notifyAll();
                return;
            }
            if (docWriter != null) {
                bl = this.waitQueue.add(docWriter);
            } else {
                this.skipDocWriter.docID = documentsWriterThreadState.docState.docID;
                bl = this.waitQueue.add(this.skipDocWriter);
            }
            if (bl) {
                this.waitForWaitQueue();
            }
            documentsWriterThreadState.isIdle = true;
            this.notifyAll();
        }
    }

    synchronized void waitForWaitQueue() {
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
        } while (!this.waitQueue.doResume());
    }

    synchronized int[] getIntBlock() {
        int[] nArray;
        int n = this.freeIntBlocks.size();
        if (0 == n) {
            nArray = new int[8192];
            this.bytesUsed.addAndGet(32768L);
        } else {
            nArray = this.freeIntBlocks.remove(n - 1);
        }
        return nArray;
    }

    synchronized void bytesUsed(long l) {
        this.bytesUsed.addAndGet(l);
    }

    long bytesUsed() {
        return this.bytesUsed.get() + this.pendingDeletes.bytesUsed.get();
    }

    synchronized void recycleIntBlocks(int[][] nArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.freeIntBlocks.add(nArray[i]);
            nArray[i] = null;
        }
    }

    synchronized char[] getCharBlock() {
        char[] cArray;
        int n = this.freeCharBlocks.size();
        if (0 == n) {
            this.bytesUsed.addAndGet(32768L);
            cArray = new char[16384];
        } else {
            cArray = this.freeCharBlocks.remove(n - 1);
        }
        return cArray;
    }

    synchronized void recycleCharBlocks(char[][] cArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.freeCharBlocks.add(cArray[i]);
            cArray[i] = null;
        }
    }

    String toMB(long l) {
        return this.nf.format((double)l / 1024.0 / 1024.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void balanceRAM() {
        boolean bl;
        long l = this.bufferedDeletesStream.bytesUsed();
        double d = this.config.getRAMBufferSizeMB();
        long l2 = d == -1.0 ? -1L : (long)(d * 1024.0 * 1024.0);
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            if (l2 == -1L || this.bufferIsFull) {
                return;
            }
            bl = this.bytesUsed() + l >= l2;
        }
        if (bl) {
            if (this.infoStream != null) {
                this.message("  RAM: balance allocations: usedMB=" + this.toMB(this.bytesUsed()) + " vs trigger=" + this.toMB(l2) + " deletesMB=" + this.toMB(l) + " byteBlockFree=" + this.toMB(this.byteBlockAllocator.freeByteBlocks.size() * 32768) + " perDocFree=" + this.toMB(this.perDocAllocator.freeByteBlocks.size() * 1024) + " charBlockFree=" + this.toMB(this.freeCharBlocks.size() * 16384 * 2));
            }
            long l3 = this.bytesUsed() + l;
            int n = 0;
            boolean bl2 = true;
            long l4 = (long)(0.95 * (double)l2);
            while (this.bytesUsed() + l > l4) {
                DocumentsWriter documentsWriter2 = this;
                synchronized (documentsWriter2) {
                    if (0 == this.perDocAllocator.freeByteBlocks.size() && 0 == this.byteBlockAllocator.freeByteBlocks.size() && 0 == this.freeCharBlocks.size() && 0 == this.freeIntBlocks.size() && !bl2) {
                        boolean bl3 = this.bufferIsFull = this.bytesUsed() + l > l2;
                        if (this.infoStream != null) {
                            if (this.bytesUsed() + l > l2) {
                                this.message("    nothing to free; set bufferIsFull");
                            } else {
                                this.message("    nothing to free");
                            }
                        }
                        break;
                    }
                    if (0 == n % 5 && this.byteBlockAllocator.freeByteBlocks.size() > 0) {
                        this.byteBlockAllocator.freeByteBlocks.remove(this.byteBlockAllocator.freeByteBlocks.size() - 1);
                        this.bytesUsed.addAndGet(-32768L);
                    }
                    if (1 == n % 5 && this.freeCharBlocks.size() > 0) {
                        this.freeCharBlocks.remove(this.freeCharBlocks.size() - 1);
                        this.bytesUsed.addAndGet(-32768L);
                    }
                    if (2 == n % 5 && this.freeIntBlocks.size() > 0) {
                        this.freeIntBlocks.remove(this.freeIntBlocks.size() - 1);
                        this.bytesUsed.addAndGet(-32768L);
                    }
                    if (3 == n % 5 && this.perDocAllocator.freeByteBlocks.size() > 0) {
                        for (int i = 0; i < 32; ++i) {
                            this.perDocAllocator.freeByteBlocks.remove(this.perDocAllocator.freeByteBlocks.size() - 1);
                            this.bytesUsed.addAndGet(-1024L);
                            if (this.perDocAllocator.freeByteBlocks.size() == 0) break;
                        }
                    }
                }
                if (4 == n % 5 && bl2) {
                    bl2 = this.consumer.freeRAM();
                }
                ++n;
            }
            if (this.infoStream != null) {
                this.message("    after free: freedMB=" + this.nf.format((double)(l3 - this.bytesUsed() - l) / 1024.0 / 1024.0) + " usedMB=" + this.nf.format((double)(this.bytesUsed() + l) / 1024.0 / 1024.0));
            }
        }
    }

    private class WaitQueue {
        DocWriter[] waiting = new DocWriter[10];
        int nextWriteDocID;
        int nextWriteLoc;
        int numWaiting;
        long waitingBytes;

        synchronized void reset() {
            assert (this.numWaiting == 0);
            assert (this.waitingBytes == 0L);
            this.nextWriteDocID = 0;
        }

        synchronized boolean doResume() {
            double d = DocumentsWriter.this.config.getRAMBufferSizeMB();
            long l = d == -1.0 ? 0x200000L : (long)(d * 1024.0 * 1024.0 * 0.05);
            return this.waitingBytes <= l;
        }

        synchronized boolean doPause() {
            double d = DocumentsWriter.this.config.getRAMBufferSizeMB();
            long l = d == -1.0 ? 0x400000L : (long)(d * 1024.0 * 1024.0 * 0.1);
            return this.waitingBytes > l;
        }

        synchronized void abort() {
            int n = 0;
            for (int i = 0; i < this.waiting.length; ++i) {
                DocWriter docWriter = this.waiting[i];
                if (docWriter == null) continue;
                docWriter.abort();
                this.waiting[i] = null;
                ++n;
            }
            this.waitingBytes = 0L;
            assert (n == this.numWaiting);
            this.numWaiting = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDocument(DocWriter docWriter) throws IOException {
            assert (docWriter == DocumentsWriter.this.skipDocWriter || this.nextWriteDocID == docWriter.docID);
            boolean bl = false;
            try {
                docWriter.finish();
                ++this.nextWriteDocID;
                ++this.nextWriteLoc;
                assert (this.nextWriteLoc <= this.waiting.length);
                if (this.nextWriteLoc == this.waiting.length) {
                    this.nextWriteLoc = 0;
                }
                bl = true;
            }
            finally {
                if (!bl) {
                    DocumentsWriter.this.setAborting();
                }
            }
        }

        public synchronized boolean add(DocWriter docWriter) throws IOException {
            assert (docWriter.docID >= this.nextWriteDocID);
            if (docWriter.docID == this.nextWriteDocID) {
                this.writeDocument(docWriter);
                while ((docWriter = this.waiting[this.nextWriteLoc]) != null) {
                    --this.numWaiting;
                    this.waiting[this.nextWriteLoc] = null;
                    this.waitingBytes -= docWriter.sizeInBytes();
                    this.writeDocument(docWriter);
                }
            } else {
                int n;
                int n2 = docWriter.docID - this.nextWriteDocID;
                if (n2 >= this.waiting.length) {
                    DocWriter[] docWriterArray = new DocWriter[ArrayUtil.oversize(n2, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    assert (this.nextWriteLoc >= 0);
                    System.arraycopy(this.waiting, this.nextWriteLoc, docWriterArray, 0, this.waiting.length - this.nextWriteLoc);
                    System.arraycopy(this.waiting, 0, docWriterArray, this.waiting.length - this.nextWriteLoc, this.nextWriteLoc);
                    this.nextWriteLoc = 0;
                    this.waiting = docWriterArray;
                    n2 = docWriter.docID - this.nextWriteDocID;
                }
                if ((n = this.nextWriteLoc + n2) >= this.waiting.length) {
                    n -= this.waiting.length;
                }
                assert (n < this.waiting.length);
                assert (this.waiting[n] == null);
                this.waiting[n] = docWriter;
                ++this.numWaiting;
                this.waitingBytes += docWriter.sizeInBytes();
            }
            return this.doPause();
        }
    }

    private class ByteBlockAllocator
    extends ByteBlockPool.Allocator {
        final int blockSize;
        ArrayList<byte[]> freeByteBlocks = new ArrayList();

        ByteBlockAllocator(int n) {
            this.blockSize = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte[] getByteBlock() {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                byte[] byArray;
                int n = this.freeByteBlocks.size();
                if (0 == n) {
                    byArray = new byte[this.blockSize];
                    DocumentsWriter.this.bytesUsed.addAndGet(this.blockSize);
                } else {
                    byArray = this.freeByteBlocks.remove(n - 1);
                }
                return byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void recycleByteBlocks(byte[][] byArray, int n, int n2) {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                for (int i = n; i < n2; ++i) {
                    this.freeByteBlocks.add(byArray[i]);
                    byArray[i] = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void recycleByteBlocks(List<byte[]> list) {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    this.freeByteBlocks.add(list.get(i));
                    list.set(i, null);
                }
            }
        }
    }

    private static class SkipDocWriter
    extends DocWriter {
        private SkipDocWriter() {
        }

        @Override
        void finish() {
        }

        @Override
        void abort() {
        }

        @Override
        long sizeInBytes() {
            return 0L;
        }
    }

    static abstract class IndexingChain {
        IndexingChain() {
        }

        abstract DocConsumer getChain(DocumentsWriter var1);
    }

    class PerDocBuffer
    extends RAMFile {
        PerDocBuffer() {
        }

        @Override
        protected byte[] newBuffer(int n) {
            assert (n == 1024);
            return DocumentsWriter.this.perDocAllocator.getByteBlock();
        }

        synchronized void recycle() {
            if (this.buffers.size() > 0) {
                this.setLength(0L);
                DocumentsWriter.this.perDocAllocator.recycleByteBlocks(this.buffers);
                this.buffers.clear();
                this.sizeInBytes = 0L;
                assert (this.numBuffers() == 0);
            }
        }
    }

    static abstract class DocWriter {
        DocWriter next;
        int docID;

        DocWriter() {
        }

        abstract void finish() throws IOException;

        abstract void abort();

        abstract long sizeInBytes();

        void setNext(DocWriter docWriter) {
            this.next = docWriter;
        }
    }

    static class DocState {
        DocumentsWriter docWriter;
        Analyzer analyzer;
        int maxFieldLength;
        PrintStream infoStream;
        Similarity similarity;
        int docID;
        Document doc;
        String maxTermPrefix;

        DocState() {
        }

        public boolean testPoint(String string) {
            return this.docWriter.writer.testPoint(string);
        }

        public void clear() {
            this.doc = null;
            this.analyzer = null;
        }
    }
}

