/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessor;
import org.apache.lucene.index.DocFieldProcessorPerField;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsWriterPerThread;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

final class DocFieldProcessorPerThread
extends DocConsumerPerThread {
    float docBoost;
    int fieldGen;
    final DocFieldProcessor docFieldProcessor;
    final FieldInfos fieldInfos;
    final DocFieldConsumerPerThread consumer;
    DocFieldProcessorPerField[] fields = new DocFieldProcessorPerField[1];
    int fieldCount;
    DocFieldProcessorPerField[] fieldHash = new DocFieldProcessorPerField[2];
    int hashMask = 1;
    int totalFieldCount;
    final StoredFieldsWriterPerThread fieldsWriter;
    final DocumentsWriter.DocState docState;
    private static final Comparator<DocFieldProcessorPerField> fieldsComp = new Comparator<DocFieldProcessorPerField>(){

        @Override
        public int compare(DocFieldProcessorPerField docFieldProcessorPerField, DocFieldProcessorPerField docFieldProcessorPerField2) {
            return docFieldProcessorPerField.fieldInfo.name.compareTo(docFieldProcessorPerField2.fieldInfo.name);
        }
    };
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    int allocCount;

    public DocFieldProcessorPerThread(DocumentsWriterThreadState documentsWriterThreadState, DocFieldProcessor docFieldProcessor) throws IOException {
        this.docState = documentsWriterThreadState.docState;
        this.docFieldProcessor = docFieldProcessor;
        this.fieldInfos = docFieldProcessor.fieldInfos;
        this.consumer = docFieldProcessor.consumer.addThread(this);
        this.fieldsWriter = docFieldProcessor.fieldsWriter.addThread(this.docState);
    }

    @Override
    public void abort() {
        Throwable throwable;
        block13: {
            block12: {
                throwable = null;
                for (DocFieldProcessorPerField docFieldProcessorPerField : this.fieldHash) {
                    while (docFieldProcessorPerField != null) {
                        DocFieldProcessorPerField docFieldProcessorPerField2;
                        block11: {
                            docFieldProcessorPerField2 = docFieldProcessorPerField.next;
                            try {
                                docFieldProcessorPerField.abort();
                            }
                            catch (Throwable throwable2) {
                                if (throwable != null) break block11;
                                throwable = throwable2;
                            }
                        }
                        docFieldProcessorPerField = docFieldProcessorPerField2;
                    }
                }
                try {
                    this.fieldsWriter.abort();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block12;
                    throwable = throwable3;
                }
            }
            try {
                this.consumer.abort();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block13;
                throwable = throwable4;
            }
        }
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public Collection<DocFieldConsumerPerField> fields() {
        HashSet<DocFieldConsumerPerField> hashSet = new HashSet<DocFieldConsumerPerField>();
        for (int i = 0; i < this.fieldHash.length; ++i) {
            DocFieldProcessorPerField docFieldProcessorPerField = this.fieldHash[i];
            while (docFieldProcessorPerField != null) {
                hashSet.add(docFieldProcessorPerField.consumer);
                docFieldProcessorPerField = docFieldProcessorPerField.next;
            }
        }
        assert (hashSet.size() == this.totalFieldCount);
        return hashSet;
    }

    void trimFields(SegmentWriteState segmentWriteState) {
        for (int i = 0; i < this.fieldHash.length; ++i) {
            DocFieldProcessorPerField docFieldProcessorPerField = this.fieldHash[i];
            DocFieldProcessorPerField docFieldProcessorPerField2 = null;
            while (docFieldProcessorPerField != null) {
                if (docFieldProcessorPerField.lastGen == -1) {
                    if (docFieldProcessorPerField2 == null) {
                        this.fieldHash[i] = docFieldProcessorPerField.next;
                    } else {
                        docFieldProcessorPerField2.next = docFieldProcessorPerField.next;
                    }
                    if (segmentWriteState.infoStream != null) {
                        segmentWriteState.infoStream.println("  purge field=" + docFieldProcessorPerField.fieldInfo.name);
                    }
                    --this.totalFieldCount;
                } else {
                    docFieldProcessorPerField.lastGen = -1;
                    docFieldProcessorPerField2 = docFieldProcessorPerField;
                }
                docFieldProcessorPerField = docFieldProcessorPerField.next;
            }
        }
    }

    private void rehash() {
        int n = this.fieldHash.length * 2;
        assert (n > this.fieldHash.length);
        DocFieldProcessorPerField[] docFieldProcessorPerFieldArray = new DocFieldProcessorPerField[n];
        int n2 = n - 1;
        for (int i = 0; i < this.fieldHash.length; ++i) {
            DocFieldProcessorPerField docFieldProcessorPerField = this.fieldHash[i];
            while (docFieldProcessorPerField != null) {
                int n3 = docFieldProcessorPerField.fieldInfo.name.hashCode() & n2;
                DocFieldProcessorPerField docFieldProcessorPerField2 = docFieldProcessorPerField.next;
                docFieldProcessorPerField.next = docFieldProcessorPerFieldArray[n3];
                docFieldProcessorPerFieldArray[n3] = docFieldProcessorPerField;
                docFieldProcessorPerField = docFieldProcessorPerField2;
            }
        }
        this.fieldHash = docFieldProcessorPerFieldArray;
        this.hashMask = n2;
    }

    @Override
    public DocumentsWriter.DocWriter processDocument() throws IOException {
        Object object;
        Object object2;
        int n;
        this.consumer.startDocument();
        this.fieldsWriter.startDocument();
        Document document = this.docState.doc;
        assert (this.docFieldProcessor.docWriter.writer.testPoint("DocumentsWriter.ThreadState.init start"));
        this.fieldCount = 0;
        int n2 = this.fieldGen++;
        List<Fieldable> list = document.getFields();
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            Fieldable[] fieldableArray;
            object2 = list.get(n);
            object = object2.name();
            int n4 = ((String)object).hashCode() & this.hashMask;
            DocFieldProcessorPerField docFieldProcessorPerField = this.fieldHash[n4];
            while (docFieldProcessorPerField != null && !docFieldProcessorPerField.fieldInfo.name.equals(object)) {
                docFieldProcessorPerField = docFieldProcessorPerField.next;
            }
            if (docFieldProcessorPerField == null) {
                fieldableArray = this.fieldInfos.add((String)object, object2.isIndexed(), object2.isTermVectorStored(), object2.isStorePositionWithTermVector(), object2.isStoreOffsetWithTermVector(), object2.getOmitNorms(), false, object2.getIndexOptions());
                docFieldProcessorPerField = new DocFieldProcessorPerField(this, (FieldInfo)fieldableArray);
                docFieldProcessorPerField.next = this.fieldHash[n4];
                this.fieldHash[n4] = docFieldProcessorPerField;
                ++this.totalFieldCount;
                if (this.totalFieldCount >= this.fieldHash.length / 2) {
                    this.rehash();
                }
            } else {
                docFieldProcessorPerField.fieldInfo.update(object2.isIndexed(), object2.isTermVectorStored(), object2.isStorePositionWithTermVector(), object2.isStoreOffsetWithTermVector(), object2.getOmitNorms(), false, object2.getIndexOptions());
            }
            if (n2 != docFieldProcessorPerField.lastGen) {
                docFieldProcessorPerField.fieldCount = 0;
                if (this.fieldCount == this.fields.length) {
                    int n5 = this.fields.length * 2;
                    DocFieldProcessorPerField[] docFieldProcessorPerFieldArray = new DocFieldProcessorPerField[n5];
                    System.arraycopy(this.fields, 0, docFieldProcessorPerFieldArray, 0, this.fieldCount);
                    this.fields = docFieldProcessorPerFieldArray;
                }
                this.fields[this.fieldCount++] = docFieldProcessorPerField;
                docFieldProcessorPerField.lastGen = n2;
            }
            if (docFieldProcessorPerField.fieldCount == docFieldProcessorPerField.fields.length) {
                fieldableArray = new Fieldable[docFieldProcessorPerField.fields.length * 2];
                System.arraycopy(docFieldProcessorPerField.fields, 0, fieldableArray, 0, docFieldProcessorPerField.fieldCount);
                docFieldProcessorPerField.fields = fieldableArray;
            }
            docFieldProcessorPerField.fields[docFieldProcessorPerField.fieldCount++] = object2;
            if (!object2.isStored()) continue;
            this.fieldsWriter.addField((Fieldable)object2, docFieldProcessorPerField.fieldInfo);
        }
        ArrayUtil.quickSort(this.fields, 0, this.fieldCount, fieldsComp);
        for (n = 0; n < this.fieldCount; ++n) {
            this.fields[n].consumer.processFields(this.fields[n].fields, this.fields[n].fieldCount);
        }
        if (this.docState.maxTermPrefix != null && this.docState.infoStream != null) {
            this.docState.infoStream.println("WARNING: document contains at least one immense term (longer than the max length 16383), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + this.docState.maxTermPrefix + "...'");
            this.docState.maxTermPrefix = null;
        }
        DocumentsWriter.DocWriter docWriter = this.fieldsWriter.finishDocument();
        object2 = this.consumer.finishDocument();
        if (docWriter == null) {
            return object2;
        }
        if (object2 == null) {
            return docWriter;
        }
        object = this.getPerDoc();
        ((PerDoc)object).docID = this.docState.docID;
        assert (docWriter.docID == this.docState.docID);
        assert (((DocumentsWriter.DocWriter)object2).docID == this.docState.docID);
        ((PerDoc)object).one = docWriter;
        ((PerDoc)object).two = object2;
        return object;
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.oversize(this.allocCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    synchronized void freePerDoc(PerDoc perDoc) {
        assert (this.freeCount < this.docFreeList.length);
        this.docFreeList[this.freeCount++] = perDoc;
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        DocumentsWriter.DocWriter one;
        DocumentsWriter.DocWriter two;

        PerDoc() {
        }

        @Override
        public long sizeInBytes() {
            return this.one.sizeInBytes() + this.two.sizeInBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() throws IOException {
            try {
                try {
                    this.one.finish();
                }
                finally {
                    this.two.finish();
                }
            }
            finally {
                DocFieldProcessorPerThread.this.freePerDoc(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            try {
                try {
                    this.one.abort();
                }
                finally {
                    this.two.abort();
                }
            }
            finally {
                DocFieldProcessorPerThread.this.freePerDoc(this);
            }
        }
    }
}

