/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

final class ByteBlockPool {
    public byte[][] buffers = new byte[10][];
    int bufferUpto = -1;
    public int byteUpto = 32768;
    public byte[] buffer;
    public int byteOffset = Short.MIN_VALUE;
    private final Allocator allocator;
    static final int[] nextLevelArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
    static final int[] levelSizeArray = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
    static final int FIRST_LEVEL_SIZE = levelSizeArray[0];

    public ByteBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public void reset() {
        if (this.bufferUpto != -1) {
            for (int i = 0; i < this.bufferUpto; ++i) {
                Arrays.fill(this.buffers[i], (byte)0);
            }
            Arrays.fill(this.buffers[this.bufferUpto], 0, this.byteUpto, (byte)0);
            if (this.bufferUpto > 0) {
                this.allocator.recycleByteBlocks(this.buffers, 1, 1 + this.bufferUpto);
            }
            this.bufferUpto = 0;
            this.byteUpto = 0;
            this.byteOffset = 0;
            this.buffer = this.buffers[0];
        }
    }

    public void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            byte[][] byArrayArray = new byte[ArrayUtil.oversize(this.buffers.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.buffers, 0, byArrayArray, 0, this.buffers.length);
            this.buffers = byArrayArray;
        }
        byte[] byArray = this.allocator.getByteBlock();
        this.buffers[1 + this.bufferUpto] = byArray;
        this.buffer = byArray;
        ++this.bufferUpto;
        this.byteUpto = 0;
        this.byteOffset += 32768;
    }

    public int newSlice(int n) {
        if (this.byteUpto > 32768 - n) {
            this.nextBuffer();
        }
        int n2 = this.byteUpto;
        this.byteUpto += n;
        this.buffer[this.byteUpto - 1] = 16;
        return n2;
    }

    public int allocSlice(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xF;
        int n3 = nextLevelArray[n2];
        int n4 = levelSizeArray[n3];
        if (this.byteUpto > 32768 - n4) {
            this.nextBuffer();
        }
        int n5 = this.byteUpto;
        int n6 = n5 + this.byteOffset;
        this.byteUpto += n4;
        this.buffer[n5] = byArray[n - 3];
        this.buffer[n5 + 1] = byArray[n - 2];
        this.buffer[n5 + 2] = byArray[n - 1];
        byArray[n - 3] = (byte)(n6 >>> 24);
        byArray[n - 2] = (byte)(n6 >>> 16);
        byArray[n - 1] = (byte)(n6 >>> 8);
        byArray[n] = (byte)n6;
        this.buffer[this.byteUpto - 1] = (byte)(0x10 | n3);
        return n5 + 3;
    }

    static abstract class Allocator {
        Allocator() {
        }

        abstract void recycleByteBlocks(byte[][] var1, int var2, int var3);

        abstract void recycleByteBlocks(List<byte[]> var1);

        abstract byte[] getByteBlock();
    }
}

