/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.CharacterUtils;
import org.apache.lucene.util.Version;

public final class LowerCaseFilter
extends TokenFilter {
    private final CharacterUtils charUtils;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public LowerCaseFilter(Version version, TokenStream tokenStream) {
        super(tokenStream);
        this.charUtils = CharacterUtils.getInstance(version);
    }

    @Deprecated
    public LowerCaseFilter(TokenStream tokenStream) {
        this(Version.LUCENE_30, tokenStream);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] cArray = this.termAtt.buffer();
            int n = this.termAtt.length();
            for (int i = 0; i < n; i += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(cArray, i)), cArray, i)) {
            }
            return true;
        }
        return false;
    }
}

