/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public abstract class FilteringTokenFilter
extends TokenFilter {
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private boolean enablePositionIncrements;

    public FilteringTokenFilter(boolean bl, TokenStream tokenStream) {
        super(tokenStream);
        this.enablePositionIncrements = bl;
    }

    protected abstract boolean accept() throws IOException;

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.enablePositionIncrements) {
            int n = 0;
            while (this.input.incrementToken()) {
                if (this.accept()) {
                    if (n != 0) {
                        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + n);
                    }
                    return true;
                }
                n += this.posIncrAtt.getPositionIncrement();
            }
        } else {
            while (this.input.incrementToken()) {
                if (!this.accept()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean bl) {
        this.enablePositionIncrements = bl;
    }
}

