/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.ultraviolet;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class AssetInformationBox
extends AbstractFullBox {
    public static final String TYPE = "ainf";
    String apid = "";
    String profileVersion = "0000";

    public AssetInformationBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return Utf8.utf8StringLengthInBytes(this.apid) + 9;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(Utf8.convert(this.profileVersion), 0, 4);
        byteBuffer.put(Utf8.convert(this.apid));
        byteBuffer.put((byte)0);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.profileVersion = IsoTypeReader.readString(byteBuffer, 4);
        this.apid = IsoTypeReader.readString(byteBuffer);
        byteBuffer = null;
    }

    public String getApid() {
        return this.apid;
    }

    public void setApid(String string) {
        this.apid = string;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String string) {
        assert (string != null && string.length() == 4);
        this.profileVersion = string;
    }
}

