/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.threegpp26245;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractBox;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class FontTableBox
extends AbstractBox {
    public static final String TYPE = "ftab";
    List<FontRecord> entries = new LinkedList<FontRecord>();

    public FontTableBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        int n = 2;
        for (FontRecord fontRecord : this.entries) {
            n += fontRecord.getSize();
        }
        return n;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        int n = IsoTypeReader.readUInt16(byteBuffer);
        for (int i = 0; i < n; ++i) {
            FontRecord fontRecord = new FontRecord();
            fontRecord.parse(byteBuffer);
            this.entries.add(fontRecord);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt16(byteBuffer, this.entries.size());
        for (FontRecord fontRecord : this.entries) {
            fontRecord.getContent(byteBuffer);
        }
    }

    public List<FontRecord> getEntries() {
        return this.entries;
    }

    public void setEntries(List<FontRecord> list) {
        this.entries = list;
    }

    public static class FontRecord {
        int fontId;
        String fontname;

        public FontRecord() {
        }

        public FontRecord(int n, String string) {
            this.fontId = n;
            this.fontname = string;
        }

        public void parse(ByteBuffer byteBuffer) {
            this.fontId = IsoTypeReader.readUInt16(byteBuffer);
            int n = IsoTypeReader.readUInt8(byteBuffer);
            this.fontname = IsoTypeReader.readString(byteBuffer, n);
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.fontId);
            IsoTypeWriter.writeUInt8(byteBuffer, this.fontname.length());
            byteBuffer.put(Utf8.convert(this.fontname));
        }

        public int getSize() {
            return Utf8.utf8StringLengthInBytes(this.fontname) + 3;
        }

        public String toString() {
            return "FontRecord{fontId=" + this.fontId + ", fontname='" + this.fontname + '\'' + '}';
        }
    }
}

