/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.boxes.AbstractTrackEncryptionBox;
import com.googlecode.mp4parser.util.Path;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSampleEncryptionBox
extends AbstractFullBox {
    int algorithmId = -1;
    int ivSize = -1;
    byte[] kid = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    List<Entry> entries = new LinkedList<Entry>();

    protected AbstractSampleEncryptionBox(String string) {
        super(string);
    }

    public int getOffsetToFirstIV() {
        int n = this.getSize() > 0x100000000L ? 16 : 8;
        n += this.isOverrideTrackEncryptionBoxParameters() ? 20 : 0;
        return n += 4;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        int n = -1;
        if ((this.getFlags() & 1) > 0) {
            this.algorithmId = IsoTypeReader.readUInt24(byteBuffer);
            n = this.ivSize = IsoTypeReader.readUInt8(byteBuffer);
            this.kid = new byte[16];
            byteBuffer.get(this.kid);
        } else {
            List<Box> list = Path.getPaths(this, "/moov[0]/trak/tkhd");
            for (Box object : list) {
                if (((TrackHeaderBox)object).getTrackId() != this.getParent().getBoxes(TrackFragmentHeaderBox.class).get(0).getTrackId()) continue;
                AbstractTrackEncryptionBox n2 = (AbstractTrackEncryptionBox)Path.getPath(object, "../mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/tenc[0]");
                if (n2 == null) {
                    n2 = (AbstractTrackEncryptionBox)Path.getPath(object, "../mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/uuid[0]");
                }
                n = n2.getDefaultIvSize();
            }
        }
        long l = IsoTypeReader.readUInt32(byteBuffer);
        while (l-- > 0L) {
            Entry entry = new Entry();
            entry.iv = new byte[n < 0 ? 8 : n];
            byteBuffer.get(entry.iv);
            if ((this.getFlags() & 2) > 0) {
                int n2 = IsoTypeReader.readUInt16(byteBuffer);
                entry.pairs = new LinkedList<Entry.Pair>();
                while (n2-- > 0) {
                    entry.pairs.add(entry.createPair(IsoTypeReader.readUInt16(byteBuffer), IsoTypeReader.readUInt32(byteBuffer)));
                }
            }
            this.entries.add(entry);
        }
    }

    public int getSampleCount() {
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(int n) {
        this.algorithmId = n;
    }

    public int getIvSize() {
        return this.ivSize;
    }

    public void setIvSize(int n) {
        this.ivSize = n;
    }

    public byte[] getKid() {
        return this.kid;
    }

    public void setKid(byte[] byArray) {
        this.kid = byArray;
    }

    public boolean isSubSampleEncryption() {
        return (this.getFlags() & 2) > 0;
    }

    public boolean isOverrideTrackEncryptionBoxParameters() {
        return (this.getFlags() & 1) > 0;
    }

    public void setSubSampleEncryption(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFD);
        }
    }

    public void setOverrideTrackEncryptionBoxParameters(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            IsoTypeWriter.writeUInt24(byteBuffer, this.algorithmId);
            IsoTypeWriter.writeUInt8(byteBuffer, this.ivSize);
            byteBuffer.put(this.kid);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            Object object;
            if (this.isOverrideTrackEncryptionBoxParameters()) {
                object = new byte[this.ivSize];
                System.arraycopy(entry.iv, 0, object, this.ivSize - entry.iv.length, entry.iv.length);
                byteBuffer.put((byte[])object);
            } else {
                byteBuffer.put(entry.iv);
            }
            if (!this.isSubSampleEncryption()) continue;
            IsoTypeWriter.writeUInt16(byteBuffer, entry.pairs.size());
            object = entry.pairs.iterator();
            while (object.hasNext()) {
                Entry.Pair pair = (Entry.Pair)object.next();
                IsoTypeWriter.writeUInt16(byteBuffer, pair.clear);
                IsoTypeWriter.writeUInt32(byteBuffer, pair.encrypted);
            }
        }
    }

    @Override
    protected long getContentSize() {
        long l = 4L;
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            l += 4L;
            l += (long)this.kid.length;
        }
        l += 4L;
        for (Entry entry : this.entries) {
            l += (long)entry.getSize();
        }
        return l;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        super.getBox(writableByteChannel);
    }

    public Entry createEntry() {
        return new Entry();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractSampleEncryptionBox abstractSampleEncryptionBox = (AbstractSampleEncryptionBox)object;
        if (this.algorithmId != abstractSampleEncryptionBox.algorithmId) {
            return false;
        }
        if (this.ivSize != abstractSampleEncryptionBox.ivSize) {
            return false;
        }
        if (this.entries != null ? !this.entries.equals(abstractSampleEncryptionBox.entries) : abstractSampleEncryptionBox.entries != null) {
            return false;
        }
        return Arrays.equals(this.kid, abstractSampleEncryptionBox.kid);
    }

    public int hashCode() {
        int n = this.algorithmId;
        n = 31 * n + this.ivSize;
        n = 31 * n + (this.kid != null ? Arrays.hashCode(this.kid) : 0);
        n = 31 * n + (this.entries != null ? this.entries.hashCode() : 0);
        return n;
    }

    public List<Short> getEntrySizes() {
        ArrayList<Short> arrayList = new ArrayList<Short>(this.entries.size());
        for (Entry entry : this.entries) {
            short s = (short)entry.iv.length;
            if (this.isSubSampleEncryption()) {
                s = (short)(s + 2);
                s = (short)(s + entry.pairs.size() * 6);
            }
            arrayList.add(s);
        }
        return arrayList;
    }

    public class Entry {
        public byte[] iv;
        public List<Pair> pairs = new LinkedList<Pair>();

        public int getSize() {
            int n = 0;
            n = AbstractSampleEncryptionBox.this.isOverrideTrackEncryptionBoxParameters() ? AbstractSampleEncryptionBox.this.ivSize : this.iv.length;
            if (AbstractSampleEncryptionBox.this.isSubSampleEncryption()) {
                n += 2;
                for (Pair pair : this.pairs) {
                    n += 6;
                }
            }
            return n;
        }

        public Pair createPair(int n, long l) {
            return new Pair(n, l);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (!new BigInteger(this.iv).equals(new BigInteger(entry.iv))) {
                return false;
            }
            return !(this.pairs != null ? !this.pairs.equals(entry.pairs) : entry.pairs != null);
        }

        public int hashCode() {
            int n = this.iv != null ? Arrays.hashCode(this.iv) : 0;
            n = 31 * n + (this.pairs != null ? this.pairs.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Entry{iv=" + Hex.encodeHex(this.iv) + ", pairs=" + this.pairs + '}';
        }

        public class Pair {
            public int clear;
            public long encrypted;

            public Pair(int n, long l) {
                this.clear = n;
                this.encrypted = l;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Pair pair = (Pair)object;
                if (this.clear != pair.clear) {
                    return false;
                }
                return this.encrypted == pair.encrypted;
            }

            public int hashCode() {
                int n = this.clear;
                n = 31 * n + (int)(this.encrypted ^ this.encrypted >>> 32);
                return n;
            }

            public String toString() {
                return "clr:" + this.clear + " enc:" + this.encrypted;
            }
        }
    }
}

