/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import java.nio.ByteBuffer;

public class AC3SpecificBox
extends AbstractBox {
    public static final String TYPE = "dac3";
    int fscod;
    int bsid;
    int bsmod;
    int acmod;
    int lfeon;
    int bitRateCode;
    int reserved;

    public AC3SpecificBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 3L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(byteBuffer);
        this.fscod = bitReaderBuffer.readBits(2);
        this.bsid = bitReaderBuffer.readBits(5);
        this.bsmod = bitReaderBuffer.readBits(3);
        this.acmod = bitReaderBuffer.readBits(3);
        this.lfeon = bitReaderBuffer.readBits(1);
        this.bitRateCode = bitReaderBuffer.readBits(5);
        this.reserved = bitReaderBuffer.readBits(5);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        BitWriterBuffer bitWriterBuffer = new BitWriterBuffer(byteBuffer);
        bitWriterBuffer.writeBits(this.fscod, 2);
        bitWriterBuffer.writeBits(this.bsid, 5);
        bitWriterBuffer.writeBits(this.bsmod, 3);
        bitWriterBuffer.writeBits(this.acmod, 3);
        bitWriterBuffer.writeBits(this.lfeon, 1);
        bitWriterBuffer.writeBits(this.bitRateCode, 5);
        bitWriterBuffer.writeBits(this.reserved, 5);
    }

    public int getFscod() {
        return this.fscod;
    }

    public void setFscod(int n) {
        this.fscod = n;
    }

    public int getBsid() {
        return this.bsid;
    }

    public void setBsid(int n) {
        this.bsid = n;
    }

    public int getBsmod() {
        return this.bsmod;
    }

    public void setBsmod(int n) {
        this.bsmod = n;
    }

    public int getAcmod() {
        return this.acmod;
    }

    public void setAcmod(int n) {
        this.acmod = n;
    }

    public int getLfeon() {
        return this.lfeon;
    }

    public void setLfeon(int n) {
        this.lfeon = n;
    }

    public int getBitRateCode() {
        return this.bitRateCode;
    }

    public void setBitRateCode(int n) {
        this.bitRateCode = n;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int n) {
        this.reserved = n;
    }

    public String toString() {
        return "AC3SpecificBox{fscod=" + this.fscod + ", bsid=" + this.bsid + ", bsmod=" + this.bsmod + ", acmod=" + this.acmod + ", lfeon=" + this.lfeon + ", bitRateCode=" + this.bitRateCode + ", reserved=" + this.reserved + '}';
    }
}

