/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.SampleList;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.DateHelper;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Mp4TrackImpl
extends AbstractTrack {
    private List<ByteBuffer> samples;
    private SampleDescriptionBox sampleDescriptionBox;
    private List<TimeToSampleBox.Entry> decodingTimeEntries;
    private List<CompositionTimeToSample.Entry> compositionTimeEntries;
    private long[] syncSamples = new long[0];
    private List<SampleDependencyTypeBox.Entry> sampleDependencies;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private String handler;
    private AbstractMediaHeaderBox mihd;

    public Mp4TrackImpl(TrackBox trackBox) {
        long l = trackBox.getTrackHeaderBox().getTrackId();
        this.samples = new SampleList(trackBox);
        SampleTableBox sampleTableBox = trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        this.handler = trackBox.getMediaBox().getHandlerBox().getHandlerType();
        this.mihd = trackBox.getMediaBox().getMediaInformationBox().getMediaHeaderBox();
        this.decodingTimeEntries = new ArrayList<TimeToSampleBox.Entry>();
        this.compositionTimeEntries = new ArrayList<CompositionTimeToSample.Entry>();
        this.sampleDependencies = new ArrayList<SampleDependencyTypeBox.Entry>();
        this.decodingTimeEntries.addAll(sampleTableBox.getTimeToSampleBox().getEntries());
        if (sampleTableBox.getCompositionTimeToSample() != null) {
            this.compositionTimeEntries.addAll(sampleTableBox.getCompositionTimeToSample().getEntries());
        }
        if (sampleTableBox.getSampleDependencyTypeBox() != null) {
            this.sampleDependencies.addAll(sampleTableBox.getSampleDependencyTypeBox().getEntries());
        }
        if (sampleTableBox.getSyncSampleBox() != null) {
            this.syncSamples = sampleTableBox.getSyncSampleBox().getSampleNumber();
        }
        this.sampleDescriptionBox = sampleTableBox.getSampleDescriptionBox();
        List<MovieExtendsBox> list = trackBox.getParent().getBoxes(MovieExtendsBox.class);
        if (list.size() > 0) {
            for (MovieExtendsBox abstractBox2 : list) {
                List<TrackExtendsBox> list2 = abstractBox2.getBoxes(TrackExtendsBox.class);
                for (TrackExtendsBox trackExtendsBox : list2) {
                    if (trackExtendsBox.getTrackId() != l) continue;
                    LinkedList<Long> linkedList = new LinkedList<Long>();
                    long l2 = 1L;
                    for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                        List<TrackFragmentBox> list3 = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                        for (TrackFragmentBox trackFragmentBox : list3) {
                            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != l) continue;
                            List<TrackRunBox> list4 = trackFragmentBox.getBoxes(TrackRunBox.class);
                            for (TrackRunBox trackRunBox : list4) {
                                TrackFragmentHeaderBox trackFragmentHeaderBox = ((TrackFragmentBox)trackRunBox.getParent()).getTrackFragmentHeaderBox();
                                boolean bl = true;
                                for (TrackRunBox.Entry entry : trackRunBox.getEntries()) {
                                    Object object;
                                    if (trackRunBox.isSampleDurationPresent()) {
                                        if (this.decodingTimeEntries.size() == 0 || this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1).getDelta() != entry.getSampleDuration()) {
                                            this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, entry.getSampleDuration()));
                                        } else {
                                            object = this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1);
                                            ((TimeToSampleBox.Entry)object).setCount(((TimeToSampleBox.Entry)object).getCount() + 1L);
                                        }
                                    } else if (trackFragmentHeaderBox.hasDefaultSampleDuration()) {
                                        this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, trackFragmentHeaderBox.getDefaultSampleDuration()));
                                    } else {
                                        this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, trackExtendsBox.getDefaultSampleDuration()));
                                    }
                                    if (trackRunBox.isSampleCompositionTimeOffsetPresent()) {
                                        if (this.compositionTimeEntries.size() == 0 || this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1).getOffset() != entry.getSampleCompositionTimeOffset()) {
                                            this.compositionTimeEntries.add(new CompositionTimeToSample.Entry(1, CastUtils.l2i(entry.getSampleCompositionTimeOffset())));
                                        } else {
                                            object = this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1);
                                            ((CompositionTimeToSample.Entry)object).setCount(((CompositionTimeToSample.Entry)object).getCount() + 1);
                                        }
                                    }
                                    if ((object = trackRunBox.isSampleFlagsPresent() ? entry.getSampleFlags() : (bl && trackRunBox.isFirstSampleFlagsPresent() ? trackRunBox.getFirstSampleFlags() : (trackFragmentHeaderBox.hasDefaultSampleFlags() ? trackFragmentHeaderBox.getDefaultSampleFlags() : trackExtendsBox.getDefaultSampleFlags()))) != null && !((SampleFlags)object).isSampleIsDifferenceSample()) {
                                        linkedList.add(l2);
                                    }
                                    ++l2;
                                    bl = false;
                                }
                            }
                        }
                    }
                    Object object = this.syncSamples;
                    this.syncSamples = new long[this.syncSamples.length + linkedList.size()];
                    System.arraycopy(object, 0, this.syncSamples, 0, ((Object)object).length);
                    Iterator iterator = linkedList.iterator();
                    int n = ((Object)object).length;
                    while (iterator.hasNext()) {
                        Long l3 = (Long)iterator.next();
                        this.syncSamples[n++] = l3;
                    }
                }
            }
        }
        MediaHeaderBox mediaHeaderBox = trackBox.getMediaBox().getMediaHeaderBox();
        TrackHeaderBox trackHeaderBox = trackBox.getTrackHeaderBox();
        this.setEnabled(trackHeaderBox.isEnabled());
        this.setInMovie(trackHeaderBox.isInMovie());
        this.setInPoster(trackHeaderBox.isInPoster());
        this.setInPreview(trackHeaderBox.isInPreview());
        this.trackMetaData.setTrackId(trackHeaderBox.getTrackId());
        this.trackMetaData.setCreationTime(DateHelper.convert(mediaHeaderBox.getCreationTime()));
        this.trackMetaData.setLanguage(mediaHeaderBox.getLanguage());
        this.trackMetaData.setModificationTime(DateHelper.convert(mediaHeaderBox.getModificationTime()));
        this.trackMetaData.setTimescale(mediaHeaderBox.getTimescale());
        this.trackMetaData.setHeight(trackHeaderBox.getHeight());
        this.trackMetaData.setWidth(trackHeaderBox.getWidth());
        this.trackMetaData.setLayer(trackHeaderBox.getLayer());
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.decodingTimeEntries;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.compositionTimeEntries;
    }

    @Override
    public long[] getSyncSamples() {
        return this.syncSamples;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sampleDependencies;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.mihd;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    public String toString() {
        return "Mp4TrackImpl{handler='" + this.handler + '\'' + '}';
    }
}

