/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;

public abstract class AbstractBox
implements Box {
    private static Logger LOG = Logger.getLogger(AbstractBox.class.getName());
    protected String type;
    private byte[] userType;
    private ContainerBox parent;
    boolean isParsed;
    boolean isRead;
    private ByteBuffer content;
    long memMapStartPosition = -1L;
    long memMapSize = -1L;
    FileChannel memMapFileChannel;
    private ByteBuffer deadBytes = null;

    private synchronized void readContent() {
        if (!this.isRead) {
            try {
                this.content = this.memMapFileChannel.map(FileChannel.MapMode.READ_ONLY, this.memMapStartPosition, this.memMapSize);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.isRead = true;
        }
    }

    protected AbstractBox(String string) {
        this.type = string;
        this.isRead = true;
        this.isParsed = true;
    }

    protected AbstractBox(String string, byte[] byArray) {
        this.type = string;
        this.userType = byArray;
        this.isRead = true;
        this.isParsed = true;
    }

    protected abstract long getContentSize();

    protected abstract void getContent(ByteBuffer var1);

    protected abstract void _parseDetails(ByteBuffer var1);

    @Override
    @DoNotParseDetail
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        if (readableByteChannel instanceof FileChannel) {
            this.memMapStartPosition = ((FileChannel)readableByteChannel).position();
            this.memMapSize = l;
            this.memMapFileChannel = (FileChannel)readableByteChannel;
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + l);
            this.isRead = false;
            this.isParsed = false;
        } else {
            assert (l < Integer.MAX_VALUE);
            this.content = ChannelHelper.readFully(readableByteChannel, l);
            this.isRead = true;
            this.isParsed = false;
        }
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        if (this.isRead) {
            if (this.isParsed) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(CastUtils.l2i(this.getSize()));
                this.getHeader(byteBuffer);
                this.getContent(byteBuffer);
                if (this.deadBytes != null) {
                    this.deadBytes.rewind();
                    while (this.deadBytes.remaining() > 0) {
                        byteBuffer.put(this.deadBytes);
                    }
                }
                writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate((this.isSmallBox() ? 8 : 16) + ("uuid".equals(this.getType()) ? 16 : 0));
                this.getHeader(byteBuffer);
                writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
                writableByteChannel.write((ByteBuffer)this.content.rewind());
            }
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.isSmallBox() ? 8 : 16);
            this.getHeader(byteBuffer);
            writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
            this.memMapFileChannel.transferTo(this.memMapStartPosition, this.memMapSize, writableByteChannel);
        }
    }

    public final synchronized void parseDetails() {
        this.readContent();
        if (this.content != null) {
            ByteBuffer byteBuffer = this.content;
            this.content = null;
            byteBuffer.rewind();
            this._parseDetails(byteBuffer);
            if (byteBuffer.remaining() > 0) {
                this.deadBytes = byteBuffer.slice();
            }
            this.isParsed = true;
            assert (this.verify(byteBuffer));
        }
    }

    protected void setDeadBytes(ByteBuffer byteBuffer) {
        this.deadBytes = byteBuffer;
    }

    @Override
    public long getSize() {
        long l = this.isRead ? (this.isParsed ? this.getContentSize() : (long)this.content.limit()) : this.memMapSize;
        l += (long)(8 + (l >= 0xFFFFFFF8L ? 8 : 0) + ("uuid".equals(this.getType()) ? 16 : 0));
        return l += (long)(this.deadBytes == null ? 0 : this.deadBytes.limit());
    }

    @Override
    @DoNotParseDetail
    public String getType() {
        return this.type;
    }

    @DoNotParseDetail
    public byte[] getUserType() {
        return this.userType;
    }

    @Override
    @DoNotParseDetail
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    @DoNotParseDetail
    public void setParent(ContainerBox containerBox) {
        this.parent = containerBox;
    }

    @DoNotParseDetail
    public IsoFile getIsoFile() {
        return this.parent.getIsoFile();
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    private boolean verify(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(CastUtils.l2i(this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0)));
        this.getContent(byteBuffer2);
        if (this.deadBytes != null) {
            this.deadBytes.rewind();
            while (this.deadBytes.remaining() > 0) {
                byteBuffer2.put(this.deadBytes);
            }
        }
        byteBuffer.rewind();
        byteBuffer2.rewind();
        if (byteBuffer.remaining() != byteBuffer2.remaining()) {
            LOG.severe(this.getType() + ": remaining differs " + byteBuffer.remaining() + " vs. " + byteBuffer2.remaining());
            return false;
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit() - 1;
        int n3 = byteBuffer2.limit() - 1;
        while (n2 >= n) {
            byte by;
            byte by2 = byteBuffer.get(n2);
            if (by2 != (by = byteBuffer2.get(n3))) {
                LOG.severe(String.format("%s: buffers differ at %d: %2X/%2X", this.getType(), n2, by2, by));
                byte[] byArray = new byte[byteBuffer.remaining()];
                byte[] byArray2 = new byte[byteBuffer2.remaining()];
                byteBuffer.get(byArray);
                byteBuffer2.get(byArray2);
                System.err.println("original      : " + Hex.encodeHex(byArray, 4));
                System.err.println("reconstructed : " + Hex.encodeHex(byArray2, 4));
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    private boolean isSmallBox() {
        int n = 8;
        if ("uuid".equals(this.getType())) {
            n += 16;
        }
        if (this.isRead) {
            if (this.isParsed) {
                return this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0) + (long)n < 0x100000000L;
            }
            return (long)(this.content.limit() + n) < 0x100000000L;
        }
        return this.memMapSize + (long)n < 0x100000000L;
    }

    private void getHeader(ByteBuffer byteBuffer) {
        if (this.isSmallBox()) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSize());
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, 1L);
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
            IsoTypeWriter.writeUInt64(byteBuffer, this.getSize());
        }
        if ("uuid".equals(this.getType())) {
            byteBuffer.put(this.getUserType());
        }
    }
}

