/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.nio.ByteBuffer;

public class TextSampleEntry
extends SampleEntry {
    public static final String TYPE1 = "tx3g";
    public static final String TYPE_ENCRYPTED = "enct";
    private long displayFlags;
    private int horizontalJustification;
    private int verticalJustification;
    private int[] backgroundColorRgba = new int[4];
    private BoxRecord boxRecord = new BoxRecord();
    private StyleRecord styleRecord = new StyleRecord();

    public TextSampleEntry(String string) {
        super(string);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this._parseReservedAndDataReferenceIndex(byteBuffer);
        this.displayFlags = IsoTypeReader.readUInt32(byteBuffer);
        this.horizontalJustification = IsoTypeReader.readUInt8(byteBuffer);
        this.verticalJustification = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba = new int[4];
        this.backgroundColorRgba[0] = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba[1] = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba[2] = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba[3] = IsoTypeReader.readUInt8(byteBuffer);
        this.boxRecord = new BoxRecord();
        this.boxRecord.parse(byteBuffer);
        this.styleRecord = new StyleRecord();
        this.styleRecord.parse(byteBuffer);
        this._parseChildBoxes(byteBuffer);
    }

    @Override
    protected long getContentSize() {
        long l = 18L;
        l += (long)this.boxRecord.getSize();
        l += (long)this.styleRecord.getSize();
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return l;
    }

    public String toString() {
        return "TextSampleEntry";
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this._writeReservedAndDataReferenceIndex(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.displayFlags);
        IsoTypeWriter.writeUInt8(byteBuffer, this.horizontalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.verticalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[0]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[1]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[2]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[3]);
        this.boxRecord.getContent(byteBuffer);
        this.styleRecord.getContent(byteBuffer);
        this._writeChildBoxes(byteBuffer);
    }

    public BoxRecord getBoxRecord() {
        return this.boxRecord;
    }

    public void setBoxRecord(BoxRecord boxRecord) {
        this.boxRecord = boxRecord;
    }

    public StyleRecord getStyleRecord() {
        return this.styleRecord;
    }

    public void setStyleRecord(StyleRecord styleRecord) {
        this.styleRecord = styleRecord;
    }

    public boolean isScrollIn() {
        return (this.displayFlags & 0x20L) == 32L;
    }

    public void setScrollIn(boolean bl) {
        this.displayFlags = bl ? (this.displayFlags |= 0x20L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFDFL);
    }

    public boolean isScrollOut() {
        return (this.displayFlags & 0x40L) == 64L;
    }

    public void setScrollOut(boolean bl) {
        this.displayFlags = bl ? (this.displayFlags |= 0x40L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFBFL);
    }

    public boolean isScrollDirection() {
        return (this.displayFlags & 0x180L) == 384L;
    }

    public void setScrollDirection(boolean bl) {
        this.displayFlags = bl ? (this.displayFlags |= 0x180L) : (this.displayFlags &= 0xFFFFFFFFFFFFFE7FL);
    }

    public boolean isContinuousKaraoke() {
        return (this.displayFlags & 0x800L) == 2048L;
    }

    public void setContinuousKaraoke(boolean bl) {
        this.displayFlags = bl ? (this.displayFlags |= 0x800L) : (this.displayFlags &= 0xFFFFFFFFFFFFF7FFL);
    }

    public boolean isWriteTextVertically() {
        return (this.displayFlags & 0x20000L) == 131072L;
    }

    public void setWriteTextVertically(boolean bl) {
        this.displayFlags = bl ? (this.displayFlags |= 0x20000L) : (this.displayFlags &= 0xFFFFFFFFFFFDFFFFL);
    }

    public boolean isFillTextRegion() {
        return (this.displayFlags & 0x40000L) == 262144L;
    }

    public void setFillTextRegion(boolean bl) {
        this.displayFlags = bl ? (this.displayFlags |= 0x40000L) : (this.displayFlags &= 0xFFFFFFFFFFFBFFFFL);
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public void setHorizontalJustification(int n) {
        this.horizontalJustification = n;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    public void setVerticalJustification(int n) {
        this.verticalJustification = n;
    }

    public int[] getBackgroundColorRgba() {
        return this.backgroundColorRgba;
    }

    public void setBackgroundColorRgba(int[] nArray) {
        this.backgroundColorRgba = nArray;
    }

    public static class StyleRecord {
        int startChar;
        int endChar;
        int fontId;
        int faceStyleFlags;
        int fontSize;
        int[] textColor = new int[]{255, 255, 255, 255};

        public void parse(ByteBuffer byteBuffer) {
            this.startChar = IsoTypeReader.readUInt16(byteBuffer);
            this.endChar = IsoTypeReader.readUInt16(byteBuffer);
            this.fontId = IsoTypeReader.readUInt16(byteBuffer);
            this.faceStyleFlags = IsoTypeReader.readUInt8(byteBuffer);
            this.fontSize = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor = new int[4];
            this.textColor[0] = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor[1] = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor[2] = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor[3] = IsoTypeReader.readUInt8(byteBuffer);
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.startChar);
            IsoTypeWriter.writeUInt16(byteBuffer, this.endChar);
            IsoTypeWriter.writeUInt16(byteBuffer, this.fontId);
            IsoTypeWriter.writeUInt8(byteBuffer, this.faceStyleFlags);
            IsoTypeWriter.writeUInt8(byteBuffer, this.fontSize);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[0]);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[1]);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[2]);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[3]);
        }

        public int getSize() {
            return 12;
        }
    }

    public static class BoxRecord {
        int top;
        int left;
        int bottom;
        int right;

        public void parse(ByteBuffer byteBuffer) {
            this.top = IsoTypeReader.readUInt16(byteBuffer);
            this.left = IsoTypeReader.readUInt16(byteBuffer);
            this.bottom = IsoTypeReader.readUInt16(byteBuffer);
            this.right = IsoTypeReader.readUInt16(byteBuffer);
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.top);
            IsoTypeWriter.writeUInt16(byteBuffer, this.left);
            IsoTypeWriter.writeUInt16(byteBuffer, this.bottom);
            IsoTypeWriter.writeUInt16(byteBuffer, this.right);
        }

        public int getSize() {
            return 8;
        }
    }
}

