/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.util.ByteBufferByteChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class SampleEntry
extends AbstractBox
implements ContainerBox {
    private int dataReferenceIndex = 1;
    protected List<Box> boxes = new LinkedList<Box>();
    private BoxParser boxParser;

    protected SampleEntry(String string) {
        super(string);
    }

    public void setType(String string) {
        this.type = string;
    }

    public int getDataReferenceIndex() {
        return this.dataReferenceIndex;
    }

    public void setDataReferenceIndex(int n) {
        this.dataReferenceIndex = n;
    }

    @Override
    public void setBoxes(List<Box> list) {
        this.boxes = new LinkedList<Box>(list);
    }

    public void addBox(Box box) {
        box.setParent(this);
        this.boxes.add(box);
    }

    public boolean removeBox(Box box) {
        box.setParent(this);
        return this.boxes.remove(box);
    }

    @Override
    public List<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean bl) {
        ArrayList<Box> arrayList = new ArrayList<Box>(2);
        for (Box box : this.boxes) {
            if (clazz == box.getClass()) {
                arrayList.add(box);
            }
            if (!bl || !(box instanceof ContainerBox)) continue;
            arrayList.addAll(((ContainerBox)box).getBoxes(clazz, bl));
        }
        return arrayList;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        super.parse(readableByteChannel, byteBuffer, l, boxParser);
        this.boxParser = boxParser;
    }

    public void _parseReservedAndDataReferenceIndex(ByteBuffer byteBuffer) {
        byteBuffer.get(new byte[6]);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
    }

    public void _parseChildBoxes(ByteBuffer byteBuffer) {
        while (byteBuffer.remaining() > 8) {
            try {
                this.boxes.add(this.boxParser.parseBox(new ByteBufferByteChannel(byteBuffer), this));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.setDeadBytes(byteBuffer.slice());
    }

    public void _writeReservedAndDataReferenceIndex(ByteBuffer byteBuffer) {
        byteBuffer.put(new byte[6]);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
    }

    public void _writeChildBoxes(ByteBuffer byteBuffer) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        WritableByteChannel writableByteChannel = Channels.newChannel(byteArrayOutputStream);
        try {
            for (Box box : this.boxes) {
                box.getBox(writableByteChannel);
            }
            writableByteChannel.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot happen. Everything should be in memory and therefore no exceptions.");
        }
        byteBuffer.put(byteArrayOutputStream.toByteArray());
    }

    public long getNumOfBytesToFirstChild() {
        long l = 0L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return this.getSize() - l;
    }
}

