/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ProgressiveDownloadInformationBox
extends AbstractFullBox {
    List<Entry> entries = Collections.emptyList();

    public ProgressiveDownloadInformationBox() {
        super("pdin");
    }

    @Override
    protected long getContentSize() {
        return 4 + this.entries.size() * 8;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getRate());
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getInitialDelay());
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.entries = new LinkedList<Entry>();
        while (byteBuffer.remaining() >= 8) {
            Entry entry = new Entry(IsoTypeReader.readUInt32(byteBuffer), IsoTypeReader.readUInt32(byteBuffer));
            this.entries.add(entry);
        }
    }

    public String toString() {
        return "ProgressiveDownloadInfoBox{entries=" + this.entries + '}';
    }

    public static class Entry {
        long rate;
        long initialDelay;

        public Entry(long l, long l2) {
            this.rate = l;
            this.initialDelay = l2;
        }

        public long getRate() {
            return this.rate;
        }

        public void setRate(long l) {
            this.rate = l;
        }

        public long getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(long l) {
            this.initialDelay = l;
        }

        public String toString() {
            return "Entry{rate=" + this.rate + ", initialDelay=" + this.initialDelay + '}';
        }
    }
}

