/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class KeywordsBox
extends AbstractFullBox {
    public static final String TYPE = "kywd";
    private String language;
    private String[] keywords;

    public KeywordsBox() {
        super(TYPE);
    }

    public String getLanguage() {
        return this.language;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setKeywords(String[] stringArray) {
        this.keywords = stringArray;
    }

    @Override
    protected long getContentSize() {
        long l = 7L;
        for (String string : this.keywords) {
            l += (long)(1 + Utf8.utf8StringLengthInBytes(string) + 1);
        }
        return l;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.language = IsoTypeReader.readIso639(byteBuffer);
        int n = IsoTypeReader.readUInt8(byteBuffer);
        this.keywords = new String[n];
        for (int i = 0; i < n; ++i) {
            IsoTypeReader.readUInt8(byteBuffer);
            this.keywords[i] = IsoTypeReader.readString(byteBuffer);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        IsoTypeWriter.writeUInt8(byteBuffer, this.keywords.length);
        for (String string : this.keywords) {
            IsoTypeWriter.writeUInt8(byteBuffer, Utf8.utf8StringLengthInBytes(string) + 1);
            byteBuffer.put(Utf8.convert(string));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("KeywordsBox[language=").append(this.getLanguage());
        for (int i = 0; i < this.keywords.length; ++i) {
            stringBuffer.append(";keyword").append(i).append("=").append(this.keywords[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

