/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;

public class FreeBox
implements Box {
    public static final String TYPE = "free";
    ByteBuffer data;
    List<Box> replacers = new LinkedList<Box>();
    private ContainerBox parent;

    public FreeBox() {
    }

    public FreeBox(int n) {
        this.data = ByteBuffer.allocate(n);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        for (Box box : this.replacers) {
            box.getBox(writableByteChannel);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        IsoTypeWriter.writeUInt32(byteBuffer, 8 + this.data.limit());
        byteBuffer.put(TYPE.getBytes());
        byteBuffer.rewind();
        writableByteChannel.write(byteBuffer);
        this.data.rewind();
        writableByteChannel.write(this.data);
    }

    @Override
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerBox containerBox) {
        this.parent = containerBox;
    }

    @Override
    public long getSize() {
        long l = 8L;
        for (Box box : this.replacers) {
            l += box.getSize();
        }
        return l += (long)this.data.limit();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        if (readableByteChannel instanceof FileChannel && l > 0x100000L) {
            this.data = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)readableByteChannel).position(), l);
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + l);
        } else {
            assert (l < Integer.MAX_VALUE);
            this.data = ChannelHelper.readFully(readableByteChannel, l);
        }
    }

    public void addAndReplace(Box box) {
        this.data.position(CastUtils.l2i(box.getSize()));
        this.data = this.data.slice();
        this.replacers.add(box);
    }
}

