/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.PropertyBoxParserImpl;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MovieBox;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.util.LazyList;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

@DoNotParseDetail
public class IsoFile
implements Closeable,
Iterator<Box>,
ContainerBox {
    protected BoxParser boxParser = this.createBoxParser();
    ReadableByteChannel byteChannel;
    long position = 0L;
    List<Box> boxes = new LinkedList<Box>();
    Box lookahead = null;

    public IsoFile() {
    }

    public IsoFile(String string) throws IOException {
        this(new FileInputStream(string).getChannel());
    }

    public IsoFile(FileChannel fileChannel) throws IOException {
        this((ReadableByteChannel)fileChannel);
    }

    public IsoFile(ReadableByteChannel readableByteChannel) throws IOException {
        this.byteChannel = readableByteChannel;
    }

    public IsoFile(ReadableByteChannel readableByteChannel, BoxParser boxParser) throws IOException {
        this.byteChannel = readableByteChannel;
        this.boxParser = boxParser;
    }

    protected BoxParser createBoxParser() {
        return new PropertyBoxParserImpl(new String[0]);
    }

    @Override
    public List<Box> getBoxes() {
        if (this.byteChannel != null) {
            return new LazyList<Box>(this.boxes, this);
        }
        return this.boxes;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.lookahead != null) {
            return true;
        }
        try {
            this.lookahead = this.next();
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    @Override
    public synchronized Box next() {
        if (this.lookahead != null) {
            Box box = this.lookahead;
            this.lookahead = null;
            return box;
        }
        if (this.byteChannel == null) {
            throw new NoSuchElementException();
        }
        try {
            if (this.byteChannel instanceof FileChannel) {
                ((FileChannel)this.byteChannel).position(this.position);
            }
            Box box = this.boxParser.parseBox(this.byteChannel, this);
            if (this.byteChannel instanceof FileChannel) {
                this.position = ((FileChannel)this.byteChannel).position();
            }
            return box;
        }
        catch (EOFException eOFException) {
            throw new NoSuchElementException();
        }
        catch (IOException iOException) {
            throw new NoSuchElementException();
        }
    }

    @DoNotParseDetail
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IsoFile[");
        if (this.boxes == null) {
            stringBuilder.append("unparsed");
        } else {
            for (int i = 0; i < this.boxes.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(this.boxes.get(i).toString());
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @DoNotParseDetail
    public static byte[] fourCCtoBytes(String string) {
        byte[] byArray = new byte[4];
        if (string != null) {
            for (int i = 0; i < Math.min(4, string.length()); ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
        }
        return byArray;
    }

    @DoNotParseDetail
    public static String bytesToFourCC(byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 4));
        }
        try {
            return new String(byArray2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Required character encoding is missing", unsupportedEncodingException);
        }
    }

    @Override
    public long getSize() {
        long l = 0L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return l;
    }

    @Override
    public IsoFile getIsoFile() {
        return this;
    }

    @DoNotParseDetail
    public MovieBox getMovieBox() {
        for (Box box : this.getBoxes()) {
            if (!(box instanceof MovieBox)) continue;
            return (MovieBox)box;
        }
        return null;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        for (Box box : this.getBoxes()) {
            if (writableByteChannel instanceof FileChannel) {
                long l = ((FileChannel)writableByteChannel).position();
                box.getBox(writableByteChannel);
                long l2 = ((FileChannel)writableByteChannel).position() - l;
                assert (l2 == box.getSize()) : box.getType() + " Size: " + l2 + " box.getSize(): " + box.getSize();
                continue;
            }
            box.getBox(writableByteChannel);
        }
    }

    @Override
    public void close() throws IOException {
        this.byteChannel.close();
    }

    @Override
    public void setBoxes(List<Box> list) {
        this.byteChannel = null;
        this.boxes = list;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean bl) {
        ArrayList<Box> arrayList = new ArrayList<Box>(2);
        for (Box box : this.getBoxes()) {
            if (clazz.isInstance(box)) {
                arrayList.add(box);
            }
            if (!bl || !(box instanceof ContainerBox)) continue;
            arrayList.addAll(((ContainerBox)box).getBoxes(clazz, bl));
        }
        return arrayList;
    }

    @Override
    public ContainerBox getParent() {
        return null;
    }

    @Override
    public void setParent(ContainerBox containerBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void addBox(Box box) {
        while (this.hasNext()) {
            this.boxes.add(this.next());
        }
        this.boxes.add(box);
        box.setParent(this);
    }
}

