/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.packagizer;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import jd.controlling.IOEQ;
import jd.controlling.linkcollector.PackagizerInterface;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.PackageInfo;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeEventSender;
import org.appwork.utils.logging.Log;
import org.jdownloader.controlling.FileCreationEvent;
import org.jdownloader.controlling.FileCreationListener;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.filter.NoDownloadLinkException;
import org.jdownloader.controlling.packagizer.PackagizerReplacer;
import org.jdownloader.controlling.packagizer.PackagizerRule;
import org.jdownloader.controlling.packagizer.PackagizerRuleWrapper;
import org.jdownloader.controlling.packagizer.PackagizerSettings;

public class PackagizerController
implements PackagizerInterface,
FileCreationListener {
    private PackagizerSettings config;
    private ArrayList<PackagizerRule> list;
    private ChangeEventSender eventSender;
    private ArrayList<PackagizerRuleWrapper> fileFilter;
    private ArrayList<PackagizerRuleWrapper> urlFilter;
    public static final String ORGFILENAME = "orgfilename";
    public static final String HOSTER = "hoster";
    public static final String SOURCE = "source";
    public static final String PACKAGENAME = "packagename";
    public static final String SIMPLEDATE = "simpledate";
    private static final PackagizerController INSTANCE = new PackagizerController(false);
    private HashMap<String, PackagizerReplacer> replacers = new HashMap();

    public static PackagizerController getInstance() {
        return INSTANCE;
    }

    public static PackagizerController createEmptyTestInstance() {
        return new PackagizerController(true);
    }

    private PackagizerController(boolean bl) {
        this.config = JsonConfig.create(PackagizerSettings.class);
        this.eventSender = new ChangeEventSender();
        if (!bl) {
            try {
                this.list = this.config.getRuleList();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.update();
        if (!bl) {
            ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PackagizerController packagizerController = PackagizerController.this;
                    synchronized (packagizerController) {
                        PackagizerController.this.config.setRuleList(PackagizerController.this.list);
                    }
                }

                @Override
                public String toString() {
                    return "save packagizer...";
                }
            });
            FileCreationManager.getInstance().getEventSender().addListener(this);
        }
        this.addReplacer(new PackagizerReplacer(){

            @Override
            public String getID() {
                return PackagizerController.SIMPLEDATE;
            }

            @Override
            public String replace(String string, CrawledLink crawledLink, String string2, PackagizerRuleWrapper packagizerRuleWrapper) {
                if (string == null) {
                    return string2;
                }
                String string3 = string;
                String string4 = new SimpleDateFormat(string3).format(new Date());
                return Pattern.compile("<jd:simpledate:" + string3 + "/?>").matcher(string2).replaceAll(string4);
            }
        });
        this.addReplacer(new PackagizerReplacer(){

            @Override
            public String getID() {
                return PackagizerController.SOURCE;
            }

            @Override
            public String replace(String string, CrawledLink crawledLink, String string2, PackagizerRuleWrapper packagizerRuleWrapper) {
                if (string == null) {
                    return string2;
                }
                int n = Integer.parseInt(string);
                CrawledLink crawledLink2 = crawledLink;
                String string3 = string2;
                while ((crawledLink2 = crawledLink2.getSourceLink()) != null) {
                    Regex regex = new Regex(crawledLink2.getURL(), packagizerRuleWrapper.getSourceRule().getPattern());
                    if (!regex.matches()) continue;
                    String[] stringArray = regex.getRow(0);
                    string3 = Pattern.compile("<jd:source:" + n + "/?>").matcher(string3).replaceAll(stringArray[n - 1]);
                }
                return string3;
            }
        });
        this.addReplacer(new PackagizerReplacer(){
            private Pattern pat = Pattern.compile("<jd:orgfilename/?>");

            @Override
            public String replace(String string, CrawledLink crawledLink, String string2, PackagizerRuleWrapper packagizerRuleWrapper) {
                if (string != null) {
                    return Pattern.compile("<jd:orgfilename:" + string + "/?>").matcher(string2).replaceAll(new Regex(crawledLink.getName(), packagizerRuleWrapper.getFileNameRule().getPattern()).getRow(0)[Integer.parseInt(string) - 1]);
                }
                return this.pat.matcher(string2).replaceAll(crawledLink.getName());
            }

            @Override
            public String getID() {
                return PackagizerController.ORGFILENAME;
            }
        });
        this.addReplacer(new PackagizerReplacer(){

            @Override
            public String replace(String string, CrawledLink crawledLink, String string2, PackagizerRuleWrapper packagizerRuleWrapper) {
                if (string == null) {
                    return string2;
                }
                int n = Integer.parseInt(string);
                Regex regex = new Regex(crawledLink.getURL(), packagizerRuleWrapper.getHosterRule().getPattern());
                if (regex.matches()) {
                    String[] stringArray = regex.getRow(0);
                    return Pattern.compile("<jd:hoster:" + n + "/?>").matcher(string2).replaceAll(stringArray[n - 1]);
                }
                return string2;
            }

            @Override
            public String getID() {
                return PackagizerController.HOSTER;
            }
        });
    }

    private void addReplacer(PackagizerReplacer packagizerReplacer) {
        this.replacers.put(packagizerReplacer.getID().toLowerCase(Locale.ENGLISH), packagizerReplacer);
    }

    public ChangeEventSender getEventSender() {
        return this.eventSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PackagizerRule> list() {
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            return new ArrayList<PackagizerRule>(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PackagizerRule packagizerRule) {
        if (packagizerRule == null) {
            return;
        }
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            this.list.add(packagizerRule);
            this.config.setRuleList(this.list);
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(ArrayList<PackagizerRule> arrayList) {
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            this.list.clear();
            this.list.addAll(arrayList);
            this.config.setRuleList(this.list);
            this.update();
        }
    }

    public void update() {
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                PackagizerController.this.updateInternal();
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInternal() {
        ArrayList<PackagizerRuleWrapper> arrayList = new ArrayList<PackagizerRuleWrapper>();
        ArrayList<PackagizerRuleWrapper> arrayList2 = new ArrayList<PackagizerRuleWrapper>();
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            for (PackagizerRule packagizerRule : this.list) {
                if (!packagizerRule.isEnabled() || !packagizerRule.isValid()) continue;
                PackagizerRuleWrapper packagizerRuleWrapper = packagizerRule.compile();
                if (!packagizerRuleWrapper.isRequiresLinkcheck()) {
                    arrayList.add(packagizerRuleWrapper);
                    arrayList2.add(packagizerRuleWrapper);
                    continue;
                }
                arrayList2.add(packagizerRuleWrapper);
            }
        }
        arrayList2.trimToSize();
        this.fileFilter = arrayList2;
        arrayList.trimToSize();
        this.urlFilter = arrayList;
        this.getEventSender().fireEvent(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(ArrayList<PackagizerRule> arrayList) {
        if (arrayList == null) {
            return;
        }
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            this.list.addAll(arrayList);
            this.config.setRuleList(this.list);
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(PackagizerRule packagizerRule) {
        if (packagizerRule == null) {
            return;
        }
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            this.list.remove(packagizerRule);
            this.config.setRuleList(this.list);
            this.update();
        }
    }

    @Override
    public void runByFile(CrawledLink crawledLink) {
        ArrayList<PackagizerRuleWrapper> arrayList = this.fileFilter;
        for (PackagizerRuleWrapper packagizerRuleWrapper : arrayList) {
            try {
                if (!packagizerRuleWrapper.checkHoster(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                throw new WTFException();
            }
            try {
                if (!packagizerRuleWrapper.checkPluginStatus(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                throw new WTFException();
            }
            if (!packagizerRuleWrapper.checkSource(crawledLink) || packagizerRuleWrapper.isRequiresLinkcheck() && (!packagizerRuleWrapper.checkOnlineStatus(crawledLink) || !packagizerRuleWrapper.checkFileName(crawledLink) || !packagizerRuleWrapper.checkFileSize(crawledLink) || !packagizerRuleWrapper.checkFileType(crawledLink))) continue;
            this.set(crawledLink, packagizerRuleWrapper);
        }
    }

    @Override
    public void runByUrl(CrawledLink crawledLink) {
        ArrayList<PackagizerRuleWrapper> arrayList = this.urlFilter;
        for (PackagizerRuleWrapper packagizerRuleWrapper : arrayList) {
            try {
                if (!packagizerRuleWrapper.checkHoster(crawledLink)) {
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {}
            continue;
            try {
                if (!packagizerRuleWrapper.checkPluginStatus(crawledLink)) {
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {}
            continue;
            if (!packagizerRuleWrapper.checkSource(crawledLink)) continue;
            this.set(crawledLink, packagizerRuleWrapper);
        }
    }

    private void set(CrawledLink crawledLink, PackagizerRuleWrapper packagizerRuleWrapper) {
        Object object;
        PackageInfo packageInfo = crawledLink.getDesiredPackageInfo();
        if (packageInfo == null) {
            packageInfo = new PackageInfo();
        }
        boolean bl = false;
        if (((PackagizerRule)packagizerRuleWrapper.getRule()).getChunks() >= 0) {
            crawledLink.setChunks(((PackagizerRule)packagizerRuleWrapper.getRule()).getChunks());
        }
        if (!StringUtils.isEmpty(((PackagizerRule)packagizerRuleWrapper.getRule()).getDownloadDestination())) {
            object = this.replaceVariables(((PackagizerRule)packagizerRuleWrapper.getRule()).getDownloadDestination(), crawledLink, packagizerRuleWrapper);
            bl = true;
            packageInfo.setDestinationFolder((String)object);
        }
        if (!StringUtils.isEmpty(((PackagizerRule)packagizerRuleWrapper.getRule()).getPackageName())) {
            object = this.replaceVariables(((PackagizerRule)packagizerRuleWrapper.getRule()).getPackageName(), crawledLink, packagizerRuleWrapper);
            bl = true;
            packageInfo.setName((String)object);
        }
        if (((PackagizerRule)packagizerRuleWrapper.getRule()).getPriority() != null) {
            crawledLink.setPriority(((PackagizerRule)packagizerRuleWrapper.getRule()).getPriority());
        }
        if (!StringUtils.isEmpty(((PackagizerRule)packagizerRuleWrapper.getRule()).getFilename())) {
            crawledLink.setName(this.replaceVariables(((PackagizerRule)packagizerRuleWrapper.getRule()).getFilename(), crawledLink, packagizerRuleWrapper));
        }
        object = null;
        object = ((PackagizerRule)packagizerRuleWrapper.getRule()).isAutoExtractionEnabled();
        if (object != null && ((Boolean)object).booleanValue()) {
            bl = true;
            packageInfo.setAutoExtractionEnabled((Boolean)object);
        }
        if ((object = ((PackagizerRule)packagizerRuleWrapper.getRule()).isAutoAddEnabled()) != null && ((Boolean)object).booleanValue()) {
            crawledLink.setAutoConfirmEnabled((Boolean)object);
        }
        if ((object = ((PackagizerRule)packagizerRuleWrapper.getRule()).isAutoStartEnabled()) != null && ((Boolean)object).booleanValue()) {
            crawledLink.setAutoStartEnabled((Boolean)object);
        }
        if (bl && crawledLink.getDesiredPackageInfo() == null) {
            crawledLink.setDesiredPackageInfo(packageInfo);
        }
    }

    private String replaceVariables(String string, CrawledLink crawledLink, PackagizerRuleWrapper packagizerRuleWrapper) {
        String[][] stringArray = new Regex(string, "<jd:(.*?)(:(.+?))?>").getMatches();
        if (stringArray != null) {
            try {
                for (String[] stringArray2 : stringArray) {
                    PackagizerReplacer packagizerReplacer = this.replacers.get(stringArray2[0].toLowerCase(Locale.ENGLISH));
                    if (packagizerReplacer == null) continue;
                    string = packagizerReplacer.replace(stringArray2[2], crawledLink, string, packagizerRuleWrapper);
                }
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
        return string;
    }

    @Override
    public void onNewFile(Object object, File[] fileArray) {
    }

    private void runAfterExtraction(File file, CrawledLink crawledLink) {
        ArrayList<PackagizerRuleWrapper> arrayList = this.fileFilter;
        for (PackagizerRuleWrapper packagizerRuleWrapper : arrayList) {
            Object object;
            if (StringUtils.isEmpty(((PackagizerRule)packagizerRuleWrapper.getRule()).getFilename()) && StringUtils.isEmpty(((PackagizerRule)packagizerRuleWrapper.getRule()).getDownloadDestination())) continue;
            try {
                if (!packagizerRuleWrapper.checkHoster(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                throw new WTFException();
            }
            try {
                if (!packagizerRuleWrapper.checkPluginStatus(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                throw new WTFException();
            }
            if (!packagizerRuleWrapper.checkSource(crawledLink) || packagizerRuleWrapper.isRequiresLinkcheck() && (!packagizerRuleWrapper.checkOnlineStatus(crawledLink) || !packagizerRuleWrapper.checkFileName(crawledLink) || !packagizerRuleWrapper.checkFileSize(crawledLink) || !packagizerRuleWrapper.checkFileType(crawledLink))) continue;
            Object object2 = file.getParent();
            String string = file.getName();
            if (!StringUtils.isEmpty(((PackagizerRule)packagizerRuleWrapper.getRule()).getDownloadDestination())) {
                object = this.replaceVariables(((PackagizerRule)packagizerRuleWrapper.getRule()).getDownloadDestination(), crawledLink, packagizerRuleWrapper);
                object2 = new File((String)object).isAbsolute() ? object : new File((String)object2, (String)object).getAbsolutePath();
            }
            if (!StringUtils.isEmpty(((PackagizerRule)packagizerRuleWrapper.getRule()).getFilename())) {
                string = this.replaceVariables(((PackagizerRule)packagizerRuleWrapper.getRule()).getFilename(), crawledLink, packagizerRuleWrapper);
            }
            object = new File((String)object2, string);
            ((File)object).getParentFile().mkdirs();
            if (!file.equals(object) && file.renameTo((File)object)) {
                Log.L.info("Packagizer Renamed " + file + " to " + object);
                FileCreationManager.getInstance().getEventSender().fireEvent(new FileCreationEvent(this, FileCreationEvent.Type.NEW_FILES, new File[]{object}));
                continue;
            }
            Log.L.warning("Packagizer could not rename " + file + " to " + object + " already exists?:" + ((File)object).exists());
        }
    }
}

