/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.regex.Pattern;
import jd.controlling.linkcrawler.CrawledLink;
import org.appwork.utils.Files;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.controlling.filter.CompiledRegexFilter;
import org.jdownloader.controlling.filter.FilterRule;
import org.jdownloader.controlling.filter.NoDownloadLinkException;

public class RuleWrapper<T extends FilterRule> {
    protected CompiledRegexFilter fileNameRule;
    protected boolean requiresLinkcheck = false;
    protected boolean requiresHoster = false;
    protected CompiledRegexFilter hosterRule;
    protected CompiledRegexFilter sourceRule;
    protected CompiledFiletypeFilter filetypeFilter;
    protected T rule;

    public RuleWrapper(T t) {
        this.rule = t;
        if (((FilterRule)this.rule).getFilenameFilter().isEnabled()) {
            this.fileNameRule = new CompiledRegexFilter(((FilterRule)this.rule).getFilenameFilter());
            this.requiresLinkcheck = true;
        }
        if (((FilterRule)this.rule).getFilesizeFilter().isEnabled()) {
            this.requiresLinkcheck = true;
        }
        if (((FilterRule)this.rule).getFiletypeFilter().isEnabled()) {
            this.filetypeFilter = new CompiledFiletypeFilter(((FilterRule)this.rule).getFiletypeFilter());
            this.requiresLinkcheck = true;
        }
        if (((FilterRule)this.rule).getHosterURLFilter().isEnabled()) {
            this.hosterRule = new CompiledRegexFilter(((FilterRule)this.rule).getHosterURLFilter());
            this.requiresHoster = true;
        }
        if (((FilterRule)this.rule).getSourceURLFilter().isEnabled()) {
            this.sourceRule = new CompiledRegexFilter(((FilterRule)this.rule).getSourceURLFilter());
        }
    }

    public CompiledRegexFilter getFileNameRule() {
        return this.fileNameRule;
    }

    public boolean isRequiresLinkcheck() {
        return this.requiresLinkcheck;
    }

    public boolean isRequiresHoster() {
        return this.requiresHoster;
    }

    public CompiledRegexFilter getHosterRule() {
        return this.hosterRule;
    }

    public CompiledRegexFilter getSourceRule() {
        return this.sourceRule;
    }

    public CompiledFiletypeFilter getFiletypeFilter() {
        return this.filetypeFilter;
    }

    public T getRule() {
        return this.rule;
    }

    public static void main(String[] stringArray) {
        RuleWrapper.test("(.*)\\QBauer7\\E(.*?)\\Q.part\\E(.*)", "*Bauer7*.part*");
        RuleWrapper.test("\\QBauer7\\E(.*?)\\Q.part\\E", "Bauer7*.part");
        RuleWrapper.test("\\QBauer7\\E(.*?)\\Q.part\\E", "Bauer7*.part");
        RuleWrapper.test("\\QBauer7\\E", "Bauer7");
        RuleWrapper.test("\\QBauer7\\E", "");
    }

    private static void test(String string, String string2) {
        System.out.println("Test compile " + string2 + ": " + string.equals(RuleWrapper.createPattern(string2, false).toString()));
    }

    public static Pattern createPattern(String string, boolean bl) {
        if (bl) {
            return Pattern.compile(string, 34);
        }
        String[] stringArray = string.split("\\*+");
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith("*")) {
            stringBuilder.append("(.*)");
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            if (n > 0) {
                stringBuilder.append("(.*?)");
            }
            stringBuilder.append(Pattern.quote(stringArray[i]));
            ++n;
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("(.*?)");
        } else if (string.endsWith("*")) {
            stringBuilder.append("(.*)");
        }
        return Pattern.compile(stringBuilder.toString(), 34);
    }

    public boolean checkFileType(CrawledLink crawledLink) {
        if (this.getFiletypeFilter() != null) {
            if (crawledLink.getLinkState() != CrawledLink.LinkState.ONLINE) {
                return false;
            }
            String string = Files.getExtension(crawledLink.getName());
            if (string == null) {
                return true;
            }
            return this.getFiletypeFilter().matches(string);
        }
        return true;
    }

    public boolean checkFileSize(CrawledLink crawledLink) {
        return true;
    }

    public boolean checkFileName(CrawledLink crawledLink) {
        if (this.getFileNameRule() != null) {
            if (crawledLink.getLinkState() != CrawledLink.LinkState.ONLINE) {
                return false;
            }
            return this.getFileNameRule().matches(crawledLink.getName());
        }
        return true;
    }

    public boolean checkHoster(CrawledLink crawledLink) throws NoDownloadLinkException {
        if (this.getHosterRule() != null) {
            if (crawledLink.getDownloadLink() == null) {
                throw new NoDownloadLinkException();
            }
            return this.getHosterRule().matches(crawledLink.getURL());
        }
        return true;
    }

    public boolean checkSource(CrawledLink crawledLink) {
        CrawledLink crawledLink2 = crawledLink;
        if (this.getSourceRule() != null) {
            do {
                if (!this.getSourceRule().matches(crawledLink2.getURL())) continue;
                return true;
            } while ((crawledLink2 = crawledLink2.getSourceLink()) != null);
            return false;
        }
        return true;
    }

    public boolean checkOnlineStatus(CrawledLink crawledLink) {
        return true;
    }

    public boolean checkPluginStatus(CrawledLink crawledLink) throws NoDownloadLinkException {
        return true;
    }

    public String getName() {
        return ((FilterRule)this.rule).getName();
    }

    public boolean isEnabled() {
        return ((FilterRule)this.rule).isEnabled();
    }
}

