/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.ArrayList;
import jd.controlling.linkcrawler.CrawledLink;
import org.appwork.storage.Storable;
import org.appwork.utils.Files;
import org.jdownloader.controlling.filter.FilesizeFilter;
import org.jdownloader.controlling.filter.FiletypeFilter;
import org.jdownloader.controlling.filter.RegexFilter;

public abstract class FilterRule
implements Storable {
    private FilesizeFilter filesizeFilter;
    private RegexFilter hosterURLFilter;
    private RegexFilter sourceURLFilter;
    private String iconKey;
    private String testUrl;
    private FiletypeFilter filetypeFilter;
    private RegexFilter filenameFilter;
    private boolean enabled;
    private String name;

    public String getTestUrl() {
        return this.testUrl;
    }

    public void setTestUrl(String string) {
        this.testUrl = string;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public void setIconKey(String string) {
        this.iconKey = string;
    }

    public FilesizeFilter getFilesizeFilter() {
        if (this.filesizeFilter == null) {
            this.filesizeFilter = new FilesizeFilter();
        }
        return this.filesizeFilter;
    }

    public void setFilesizeFilter(FilesizeFilter filesizeFilter) {
        this.filesizeFilter = filesizeFilter;
    }

    public boolean isValid() {
        return this.getFilenameFilter().isEnabled() || this.getFilesizeFilter().isEnabled() || this.getFiletypeFilter().isEnabled() || this.getHosterURLFilter().isEnabled() || this.getSourceURLFilter().isEnabled();
    }

    public String toString(CrawledLink crawledLink) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getFilenameFilter().isEnabled()) {
            if (crawledLink != null && crawledLink.getName() != null) {
                arrayList.add("_GUI._.FilterRule_toString_name2(link.getName(), filenameFilter.toString())");
            } else {
                arrayList.add("_GUI._.FilterRule_toString_name(filenameFilter.toString())");
            }
        }
        if (this.getFilesizeFilter().isEnabled()) {
            if (crawledLink != null && crawledLink.getSize() > 0L) {
                arrayList.add("_GUI._.FilterRule_toString_size2(SizeFormatter.formatBytes(link.getSize()), filesizeFilter.toString())");
            } else {
                arrayList.add("_GUI._.FilterRule_toString_size(filesizeFilter.toString())");
            }
        }
        if (this.getFiletypeFilter().isEnabled()) {
            if (crawledLink != null && crawledLink.getName() != null && Files.getExtension(crawledLink.getName()) != null) {
                String string = Files.getExtension(crawledLink.getName());
                arrayList.add("_GUI._.FilterRule_toString_type2(ext, filetypeFilter.toString())");
            } else {
                arrayList.add("_GUI._.FilterRule_toString_type(filetypeFilter.toString())");
            }
        }
        if (this.getHosterURLFilter().isEnabled()) {
            if (crawledLink != null) {
                arrayList.add("_GUI._.FilterRule_toString_hoster2(link.getURL(), hosterURLFilter.toString())");
            } else {
                arrayList.add("_GUI._.FilterRule_toString_hoster(hosterURLFilter.toString())");
            }
        }
        if (this.getSourceURLFilter().isEnabled()) {
            arrayList.add("_GUI._.FilterRule_toString_source(sourceURLFilter.toString())");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                if (i < arrayList.size() - 1) {
                    stringBuilder.append("_GUI._.FilterRule_toString_comma(cond.get(i))");
                    continue;
                }
                stringBuilder.append("_GUI._.FilterRule_toString_and(cond.get(i))");
                continue;
            }
            stringBuilder.append((String)arrayList.get(i));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public RegexFilter getHosterURLFilter() {
        if (this.hosterURLFilter == null) {
            this.hosterURLFilter = new RegexFilter();
        }
        return this.hosterURLFilter;
    }

    public void setHosterURLFilter(RegexFilter regexFilter) {
        this.hosterURLFilter = regexFilter;
    }

    public RegexFilter getSourceURLFilter() {
        if (this.sourceURLFilter == null) {
            this.sourceURLFilter = new RegexFilter();
        }
        return this.sourceURLFilter;
    }

    public void setSourceURLFilter(RegexFilter regexFilter) {
        this.sourceURLFilter = regexFilter;
    }

    public FiletypeFilter getFiletypeFilter() {
        if (this.filetypeFilter == null) {
            this.filetypeFilter = new FiletypeFilter();
        }
        return this.filetypeFilter;
    }

    public void setFiletypeFilter(FiletypeFilter filetypeFilter) {
        this.filetypeFilter = filetypeFilter;
    }

    public RegexFilter getFilenameFilter() {
        if (this.filenameFilter == null) {
            this.filenameFilter = new RegexFilter();
        }
        return this.filenameFilter;
    }

    public void setFilenameFilter(RegexFilter regexFilter) {
        this.filenameFilter = regexFilter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isEnabled() {
        return this.enabled && this.isValid();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

