/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.IOException;
import java.io.OutputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;

public class ThrottledOutputStream
extends OutputStream
implements ThrottledConnection {
    private ThrottledConnectionHandler handler;
    private final OutputStream out;
    protected volatile long transferedCounter = 0L;
    protected volatile long transferedCounter2 = 0L;
    private volatile int limitCurrent = 0;
    private int limitCounter = 0;
    private int offset;
    private int todo;
    private int rest;
    private long slotTimeLeft = 0L;
    private long lastTimeWrite = 0L;

    public ThrottledOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            this.handler.removeThrottledConnection(this);
            this.handler = null;
        }
        ThrottledOutputStream throttledOutputStream = this;
        synchronized (throttledOutputStream) {
            this.notify();
        }
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public ThrottledConnectionHandler getHandler() {
        return this.handler;
    }

    @Override
    public int getLimit() {
        return this.limitCurrent;
    }

    @Override
    public void setHandler(ThrottledConnectionHandler throttledConnectionHandler) {
        if (this.handler != null && this.handler != throttledConnectionHandler) {
            this.handler.removeThrottledConnection(this);
        }
        this.handler = throttledConnectionHandler;
        if (this.handler != null) {
            this.handler.addThrottledConnection(this);
        }
    }

    @Override
    public void setLimit(int n) {
        if (n == this.limitCurrent) {
            return;
        }
        this.limitCurrent = Math.max(0, n);
    }

    @Override
    public long transfered() {
        return this.transferedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.limitCurrent == 0) {
            this.out.write(byArray, n, n2);
            this.transferedCounter += (long)n2;
        } else {
            this.offset = n;
            this.rest = n2;
            while (this.rest > 0) {
                this.slotTimeLeft = 0L;
                if (this.limitCounter <= 0 && (this.slotTimeLeft = System.currentTimeMillis() - this.lastTimeWrite) < 1000L) {
                    ThrottledOutputStream throttledOutputStream = this;
                    synchronized (throttledOutputStream) {
                        try {
                            this.wait(1000L - this.slotTimeLeft);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new IOException("throttle interrupted");
                        }
                    }
                    this.limitCounter = this.limitCurrent;
                    if (this.limitCounter <= 0) {
                        this.limitCounter = this.rest;
                    }
                } else if (this.slotTimeLeft > 1000L) {
                    this.limitCounter = this.limitCurrent;
                    if (this.limitCounter <= 0) {
                        this.limitCounter = this.rest;
                    }
                }
                this.todo = Math.min(this.limitCounter, this.rest);
                this.out.write(byArray, this.offset, this.todo);
                this.offset += this.todo;
                this.rest -= this.todo;
                this.transferedCounter += (long)this.todo;
                this.limitCounter -= this.todo;
                this.lastTimeWrite = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        ++this.transferedCounter;
        if (this.limitCurrent != 0) {
            --this.limitCounter;
            this.slotTimeLeft = 0L;
            if (this.limitCounter <= 0 && (this.slotTimeLeft = System.currentTimeMillis() - this.lastTimeWrite) < 1000L) {
                ThrottledOutputStream throttledOutputStream = this;
                synchronized (throttledOutputStream) {
                    try {
                        this.wait(1000L - this.slotTimeLeft);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("throttle interrupted");
                    }
                }
                this.limitCounter = this.limitCurrent;
            } else if (this.slotTimeLeft > 1000L) {
                this.limitCounter = this.limitCurrent;
            }
            this.lastTimeWrite = System.currentTimeMillis();
        }
    }
}

