/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyException;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.SocksHTTPconnection;

public class Socks5HTTPConnectionImpl
extends SocksHTTPconnection {
    public Socks5HTTPConnectionImpl(URL uRL, HTTPProxy hTTPProxy) {
        super(uRL, hTTPProxy);
    }

    @Override
    protected void authenticateProxyPlain() throws IOException {
        try {
            String string = this.proxy.getUser() == null ? "" : this.proxy.getUser();
            String string2 = this.proxy.getPass() == null ? "" : this.proxy.getPass();
            this.proxyRequest.append("->AUTH user:pass\r\n");
            byte[] byArray = string.getBytes("ISO-8859-1");
            byte[] byArray2 = string2.getBytes("ISO-8859-1");
            this.socksoutputstream.write(1);
            this.socksoutputstream.write((byte)byArray.length);
            this.socksoutputstream.write(byArray);
            this.socksoutputstream.write((byte)byArray2.length);
            this.socksoutputstream.write(byArray2);
            byte[] byArray3 = this.readResponse(2);
            if (byArray3[0] != 1) {
                throw new ProxyConnectException(this.proxy);
            }
            if (byArray3[1] != 0) {
                this.proxyRequest.append("<-AUTH Invalid!\r\n");
                throw new ProxyAuthException(this.proxy);
            }
            this.proxyRequest.append("<-AUTH Valid!\r\n");
        }
        catch (IOException iOException) {
            try {
                this.sockssocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (iOException instanceof HTTPProxyException) {
                throw iOException;
            }
            throw new ProxyConnectException(iOException, this.proxy);
        }
    }

    @Override
    protected Socket establishConnection() throws IOException {
        try {
            this.socksoutputstream.write(5);
            this.socksoutputstream.write(1);
            this.socksoutputstream.write(0);
            this.socksoutputstream.write(3);
            this.proxyRequest.append("->SEND tcp connect request by domain\r\n");
            byte[] byArray = this.httpHost.getBytes("ISO-8859-1");
            this.socksoutputstream.write((byte)byArray.length);
            this.socksoutputstream.write(byArray);
            this.socksoutputstream.write(this.httpPort >> 8 & 0xFF);
            this.socksoutputstream.write(this.httpPort & 0xFF);
            this.socksoutputstream.flush();
            byte[] byArray2 = this.readResponse(4);
            if (byArray2[0] != 5) {
                throw new ProxyConnectException("Socks5HTTPConnection: invalid Socks5 response", this.proxy);
            }
            switch (byArray2[1]) {
                case 0: {
                    break;
                }
                case 3: {
                    throw new SocketException("Network is unreachable");
                }
                case 4: {
                    throw new SocketException("Host is unreachable");
                }
                case 5: {
                    throw new ConnectException("Connection refused");
                }
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 8: {
                    throw new ProxyConnectException("Socks5HTTPConnection: could not establish connection, status=" + byArray2[1], this.proxy);
                }
            }
            if (byArray2[3] == 1) {
                this.readResponse(6);
                this.proxyRequest.append("<-CONNECT IP\r\n");
            } else if (byArray2[3] == 3) {
                this.readResponse(1 + byArray.length + 2);
                this.proxyRequest.append("<-CONNECT Domain\r\n");
            } else {
                throw new ProxyConnectException("Socks5HTTPConnection: unsupported address Type " + byArray2[3], this.proxy);
            }
            return this.sockssocket;
        }
        catch (IOException iOException) {
            try {
                this.sockssocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (iOException instanceof HTTPProxyException) {
                throw iOException;
            }
            throw new ProxyConnectException(iOException, this.proxy);
        }
    }

    @Override
    protected String getRequestInfo() {
        if (this.proxyRequest != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("-->Socks5Proxy:").append(this.proxy.getHost() + ":" + this.proxy.getPort()).append("\r\n");
            if (this.proxyInetSocketAddress != null && this.proxyInetSocketAddress.getAddress() != null) {
                stringBuilder.append("-->Socks5ProxyIP:").append(this.proxyInetSocketAddress.getAddress().getHostAddress()).append("\r\n");
            }
            stringBuilder.append("----------------CONNECTRequest(SOCKS5)----------\r\n");
            stringBuilder.append(this.proxyRequest.toString());
            stringBuilder.append("------------------------------------------------\r\n");
            stringBuilder.append(super.getRequestInfo());
            return stringBuilder.toString();
        }
        return super.getRequestInfo();
    }

    @Override
    protected SocksHTTPconnection.AUTH sayHello() throws IOException {
        try {
            this.proxyRequest.append("->SOCKS5 Hello\r\n");
            this.socksoutputstream.write(5);
            this.socksoutputstream.write(2);
            this.proxyRequest.append("->SOCKS5 Offer None&Plain Authentication\r\n");
            this.socksoutputstream.write(2);
            this.socksoutputstream.write(0);
            this.socksoutputstream.flush();
            byte[] byArray = this.readResponse(2);
            if (byArray[0] != 5) {
                throw new ProxyConnectException("Socks5HTTPConnection: invalid Socks5 response", this.proxy);
            }
            if (byArray[1] == 255) {
                this.proxyRequest.append("<-SOCKS5 Authentication Denied\r\n");
                throw new ProxyConnectException("Socks5HTTPConnection: no acceptable authentication method found", this.proxy);
            }
            if (byArray[1] == 2) {
                return SocksHTTPconnection.AUTH.PLAIN;
            }
            if (byArray[1] == 0) {
                return SocksHTTPconnection.AUTH.NONE;
            }
            throw new IOException("Unsupported auth " + byArray[1]);
        }
        catch (IOException iOException) {
            try {
                this.sockssocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (iOException instanceof HTTPProxyException) {
                throw iOException;
            }
            throw new ProxyConnectException(iOException, this.proxy);
        }
    }

    @Override
    protected void validateProxy() throws IOException {
        if (this.proxy == null || !this.proxy.getType().equals((Object)HTTPProxy.TYPE.SOCKS5)) {
            throw new IOException("Socks5HTTPConnection: invalid Socks5 Proxy!");
        }
    }
}

