/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.locale.Loc;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.DownloadProgress;
import org.appwork.utils.net.HTTPException;

public class SimpleHTTP {
    private static final Object CALL_LOCK = new Object();
    private final HashMap<String, String> requestHeader = new HashMap();
    private HttpURLConnection connection;
    private int connectTimeout = 15000;
    private int readTimeout = 30000;
    private boolean followRedirects = true;
    private boolean headerDebug = false;

    public void clearRequestHeader() {
        this.requestHeader.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL uRL, DownloadProgress downloadProgress, File file) throws IOException, InterruptedException {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                this.download(uRL, downloadProgress, 0L, filterOutputStream);
            }
            catch (IOException iOException) {
                try {
                    filterOutputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (file.length() > 0L) {
                    HTTPException hTTPException = new HTTPException(this.connection, IO.readFileToString(file), iOException);
                    file.delete();
                    throw hTTPException;
                }
            }
        }
        finally {
            try {
                filterOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public byte[] download(URL uRL, DownloadProgress downloadProgress, long l) throws IOException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream;
        block4: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this.download(uRL, downloadProgress, l, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                if (byteArrayOutputStream.size() <= 0) break block4;
                throw new HTTPException(this.connection, new String(byteArrayOutputStream.toByteArray()), iOException);
            }
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL uRL, DownloadProgress downloadProgress, long l, OutputStream outputStream) throws IOException, InterruptedException {
        BufferedInputStream bufferedInputStream = null;
        GZIPInputStream gZIPInputStream = null;
        try {
            int n;
            Object object2;
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setInstanceFollowRedirects(this.followRedirects);
            this.connection.setConnectTimeout(this.connectTimeout);
            this.connection.setReadTimeout(this.readTimeout);
            try {
                object2 = Loc.getLocale().split("_")[0];
                this.connection.setRequestProperty("Accept-Language", (String)object2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
            this.connection.setRequestProperty("Connection", "Close");
            for (Map.Entry object3 : this.requestHeader.entrySet()) {
                this.connection.setRequestProperty((String)object3.getKey(), (String)object3.getValue());
            }
            this.connection.connect();
            object2 = null;
            try {
                if (this.connection.getHeaderField("Content-Encoding") != null && this.connection.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
                    gZIPInputStream = new GZIPInputStream(this.connection.getInputStream());
                    bufferedInputStream = new BufferedInputStream(gZIPInputStream);
                } else {
                    bufferedInputStream = new BufferedInputStream(this.connection.getInputStream());
                }
            }
            catch (IOException iOException) {
                object2 = iOException;
                if (this.connection.getHeaderField("Content-Encoding") != null && this.connection.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
                    gZIPInputStream = new GZIPInputStream(this.connection.getErrorStream());
                    bufferedInputStream = new BufferedInputStream(gZIPInputStream);
                }
                bufferedInputStream = new BufferedInputStream(this.connection.getErrorStream());
            }
            if (l > 0L && (long)this.connection.getContentLength() > l) {
                throw new IOException("Max size exeeded!");
            }
            if (downloadProgress != null) {
                downloadProgress.setTotal(this.connection.getContentLength());
            }
            byte[] byArray = new byte[Short.MAX_VALUE];
            long l2 = 0L;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (n > 0) {
                    outputStream.write(byArray, 0, n);
                    if (l > 0L && (l2 += (long)n) > l) {
                        throw new IOException("Max size exeeded!");
                    }
                }
                if (downloadProgress == null) continue;
                downloadProgress.increaseLoaded(n);
            }
            if (object2 != null) {
                throw object2;
            }
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {}
            try {
                gZIPInputStream.close();
            }
            catch (Exception exception) {}
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPage(URL uRL) throws IOException, InterruptedException {
        Object object = CALL_LOCK;
        synchronized (object) {
            String string;
            BufferedReader bufferedReader = null;
            InputStreamReader inputStreamReader = null;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                String string2;
                this.connection = (HttpURLConnection)uRL.openConnection();
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setReadTimeout(this.readTimeout);
                try {
                    Iterator<Map.Entry<String, List<String>>> iterator = Loc.getLocale().split("_")[0];
                    this.connection.setRequestProperty("Accept-Language", (String)((Object)iterator));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                this.connection.setRequestProperty("Accept-Charset", "UTF-8");
                for (Map.Entry object32 : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty((String)object32.getKey(), (String)object32.getValue());
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getRequestProperties().entrySet()) {
                        for (String string3 : entry.getValue()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\r\n");
                            }
                            stringBuilder.append("REQUEST: " + entry.getKey() + " = " + string3);
                        }
                    }
                }
                int n = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++n > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                inputStreamReader = new InputStreamReader(this.connection.getInputStream(), "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder stringBuilder2 = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append("\r\n");
                    }
                    stringBuilder2.append(string2);
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getHeaderFields().entrySet()) {
                        for (String string4 : entry.getValue()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\r\n");
                            }
                            stringBuilder.append("RESPONSE: " + entry.getKey() + " = " + string4);
                        }
                    }
                    Log.L.info(stringBuilder.toString());
                }
                string = stringBuilder2.toString();
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                try {
                    this.connection.disconnect();
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                inputStreamReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return string;
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HashMap<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    public String getRequestHeader(String string) {
        return this.requestHeader.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseHeader(String string) {
        Object object = CALL_LOCK;
        synchronized (object) {
            if (this.connection == null) {
                return null;
            }
            return this.connection.getHeaderField(string);
        }
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isHeaderDebug() {
        return this.headerDebug;
    }

    public HttpURLConnection openGetConnection(URL uRL) throws IOException, InterruptedException {
        return this.openGetConnection(uRL, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection openGetConnection(URL uRL, int n) throws IOException, InterruptedException {
        boolean bl = true;
        Object object = CALL_LOCK;
        synchronized (object) {
            HttpURLConnection httpURLConnection;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                this.connection = (HttpURLConnection)uRL.openConnection();
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setReadTimeout(n < 0 ? n : n);
                try {
                    Iterator<Map.Entry<String, List<String>>> iterator2 = Loc.getLocale().split("_")[0];
                    this.connection.setRequestProperty("Accept-Language", (String)((Object)iterator2));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                this.connection.setRequestProperty("Accept-Charset", "UTF-8");
                for (Map.Entry iterator3 : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty((String)iterator3.getKey(), (String)iterator3.getValue());
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getRequestProperties().entrySet()) {
                        for (String string : entry.getValue()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\r\n");
                            }
                            stringBuilder.append("REQUEST: " + entry.getKey() + " = " + string);
                        }
                    }
                }
                int n2 = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++n2 > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                bl = false;
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getHeaderFields().entrySet()) {
                        for (String string : entry.getValue()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\r\n");
                            }
                            stringBuilder.append("RESPONSE: " + entry.getKey() + " = " + string);
                        }
                    }
                    Log.L.info(stringBuilder.toString());
                }
                httpURLConnection = this.connection;
            }
            catch (Throwable throwable) {
                try {
                    if (bl) {
                        this.connection.disconnect();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (bl) {
                    this.connection.disconnect();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return httpURLConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection openPostConnection(URL uRL, String string, HashMap<String, String> hashMap) throws IOException, InterruptedException {
        boolean bl = true;
        Object object = CALL_LOCK;
        synchronized (object) {
            HttpURLConnection httpURLConnection;
            OutputStreamWriter outputStreamWriter = null;
            OutputStream outputStream = null;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                this.connection = (HttpURLConnection)uRL.openConnection();
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setReadTimeout(this.readTimeout);
                this.connection.setRequestMethod("POST");
                this.connection.setDoInput(true);
                this.connection.setUseCaches(false);
                this.connection.setDoOutput(true);
                if (Loc.getLocale() != null) {
                    try {
                        Iterator<Map.Entry<String, Object>> iterator2 = Loc.getLocale().split("_")[0];
                        this.connection.setRequestProperty("Accept-Language", (String)((Object)iterator2));
                    }
                    catch (Throwable throwable) {
                        Log.exception(Level.WARNING, throwable);
                    }
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                if (hashMap != null) {
                    for (Map.Entry<String, String> iterator3 : hashMap.entrySet()) {
                        this.connection.setRequestProperty(iterator3.getKey(), iterator3.getValue());
                    }
                }
                for (Map.Entry<String, String> entry : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, Object> entry : this.connection.getRequestProperties().entrySet()) {
                        for (Object object2 : (List)entry.getValue()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\r\n");
                            }
                            stringBuilder.append("REQUEST: " + entry.getKey() + " = " + (String)object2);
                        }
                    }
                }
                int n = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++n > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                outputStream = this.connection.getOutputStream();
                outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
                bl = false;
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getHeaderFields().entrySet()) {
                        for (String string2 : entry.getValue()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\r\n");
                            }
                            stringBuilder.append("RESPONSE: " + entry.getKey() + " = " + string2);
                        }
                    }
                    Log.L.info(stringBuilder.toString());
                }
                httpURLConnection = this.connection;
            }
            catch (Throwable throwable) {
                try {
                    if (bl) {
                        this.connection.disconnect();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (bl) {
                    this.connection.disconnect();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                outputStreamWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return httpURLConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postPage(URL uRL, String string) throws IOException, InterruptedException {
        Object object = CALL_LOCK;
        synchronized (object) {
            String string2;
            OutputStreamWriter outputStreamWriter = null;
            BufferedReader bufferedReader = null;
            OutputStream outputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                String string3;
                this.connection = (HttpURLConnection)uRL.openConnection();
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setReadTimeout(this.readTimeout);
                this.connection.setRequestMethod("POST");
                this.connection.setDoInput(true);
                this.connection.setUseCaches(false);
                this.connection.setDoOutput(true);
                try {
                    String string4 = Loc.getLocale().split("_")[0];
                    this.connection.setRequestProperty("Accept-Language", string4);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                for (Map.Entry object22 : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty((String)object22.getKey(), (String)object22.getValue());
                }
                int n = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++n > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                outputStream = this.connection.getOutputStream();
                outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
                inputStreamReader = new InputStreamReader(this.connection.getInputStream(), "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder stringBuilder = new StringBuilder();
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\r\n");
                    }
                    stringBuilder.append(string3);
                }
                string2 = stringBuilder.toString();
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable5) {
                    // empty catch block
                }
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable6) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.connection.disconnect();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                inputStreamReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                outputStreamWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return string2;
        }
    }

    public void putRequestHeader(String string, String string2) {
        this.requestHeader.put(string, string2);
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public void setHeaderDebug(boolean bl) {
        this.headerDebug = bl;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }
}

