/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.appwork.utils.net.HTTPHeader;

public class HeaderCollection
implements Iterable<HTTPHeader> {
    private final LinkedList<HTTPHeader> headers = new LinkedList();
    private final HashMap<String, HTTPHeader> headersMap = new HashMap();
    private static HashMap<String, Boolean> DUPES_ALLOWED = new HashMap();

    public String toString() {
        return this.headers.toString();
    }

    public void add(HTTPHeader hTTPHeader) {
        if (!DUPES_ALLOWED.containsKey(hTTPHeader.getKey()) && this.headersMap.containsKey(hTTPHeader.getKey())) {
            Iterator iterator = this.headers.iterator();
            while (iterator.hasNext()) {
                HTTPHeader hTTPHeader2 = (HTTPHeader)iterator.next();
                if (!hTTPHeader2.getKey().equalsIgnoreCase(hTTPHeader.getKey())) continue;
                if (hTTPHeader2.isAllowOverwrite()) {
                    iterator.remove();
                    break;
                }
                return;
            }
        }
        this.headers.add(hTTPHeader);
        this.headersMap.put(hTTPHeader.getKey(), hTTPHeader);
    }

    public HTTPHeader get(String string) {
        for (HTTPHeader hTTPHeader : this.headers) {
            if (!hTTPHeader.getKey().equalsIgnoreCase(string)) continue;
            return hTTPHeader;
        }
        return null;
    }

    public String getValue(String string) {
        HTTPHeader hTTPHeader = this.get(string);
        if (hTTPHeader != null) {
            return hTTPHeader.getValue();
        }
        return null;
    }

    @Override
    public Iterator<HTTPHeader> iterator() {
        return this.headers.iterator();
    }

    static {
        DUPES_ALLOWED.put("Set-Cookies", true);
    }
}

