/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging.Log;

public abstract class Queue
extends Thread {
    protected boolean debugFlag = false;
    protected QueuePriority[] prios;
    protected HashMap<QueuePriority, ArrayList<QueueAction<?, ? extends Throwable>>> queue = new HashMap();
    protected final Object queueLock = new Object();
    protected ArrayList<QueueAction<?, ? extends Throwable>> queueThreadHistory = new ArrayList(20);
    protected Thread thread = null;
    protected boolean waitFlag = true;
    private QueueAction<?, ? extends Throwable> sourceItem = null;
    private QueueAction<?, ?> currentJob;
    protected static AtomicInteger QUEUELOOPPREVENTION = new AtomicInteger(0);

    protected QueueAction<?, ?> getCurrentJob() {
        return this.currentJob;
    }

    public Queue(String string) {
        super(string);
        QUEUELOOPPREVENTION.incrementAndGet();
        for (QueuePriority queuePriority : this.prios = QueuePriority.values()) {
            this.queue.put(queuePriority, new ArrayList());
        }
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<QueueAction<?, ?>> getEntries() {
        ArrayList arrayList = new ArrayList();
        Object object = this.queueLock;
        synchronized (object) {
            if (this.currentJob != null) {
                arrayList.add(this.currentJob);
            }
            for (QueuePriority queuePriority : this.prios) {
                ListIterator<QueueAction<?, Throwable>> listIterator = this.queue.get((Object)queuePriority).listIterator();
                while (listIterator.hasNext()) {
                    QueueAction<?, ? extends Throwable> queueAction = listIterator.next();
                    arrayList.add(queueAction);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.currentJob != null) {
                ++n;
            }
            for (QueuePriority queuePriority : this.prios) {
                ListIterator<QueueAction<?, Throwable>> listIterator = this.queue.get((Object)queuePriority).listIterator();
                while (listIterator.hasNext()) {
                    QueueAction<?, ? extends Throwable> queueAction = listIterator.next();
                    ++n;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(QueueAction<?, ?> queueAction) {
        Object object = this.queueLock;
        synchronized (object) {
            ArrayList<QueueAction<?, Throwable>> arrayList = this.queue.get((Object)queueAction.getQueuePrio());
            if (arrayList.remove(queueAction)) {
                queueAction.kill();
                QueueAction<?, ?> queueAction2 = queueAction;
                synchronized (queueAction2) {
                    queueAction.notify();
                }
                return true;
            }
            if (queueAction == this.currentJob) {
                queueAction.kill();
                QueueAction<?, ?> queueAction3 = queueAction;
                synchronized (queueAction3) {
                    queueAction.notify();
                }
                return true;
            }
            return false;
        }
    }

    public <E, T extends Throwable> void add(QueueAction<?, T> queueAction) throws T {
        queueAction.reset();
        queueAction.setCallerThread(this, Thread.currentThread());
        if (this.isQueueThread(queueAction)) {
            QueueAction<?, Throwable> queueAction2 = ((Queue)Thread.currentThread()).getSourceQueueAction();
            if (queueAction2 != null) {
                queueAction.setQueuePrio(queueAction2.getQueuePrio());
            }
            this.startItem(queueAction, false);
        } else {
            this.internalAdd(queueAction);
        }
    }

    public <E, T extends Throwable> void addAsynch(QueueAction<?, T> queueAction) {
        if (!queueAction.allowAsync() && this.isQueueThread(queueAction)) {
            throw new RuntimeException("called addAsynch from the queue itself");
        }
        queueAction.reset();
        queueAction.setCallerThread(this, Thread.currentThread());
        this.internalAdd(queueAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E, T extends Throwable> E addWait(QueueAction<E, T> queueAction) throws T {
        queueAction.reset();
        queueAction.setCallerThread(this, Thread.currentThread());
        if (this.isQueueThread(queueAction)) {
            QueueAction<?, Throwable> queueAction2 = ((Queue)Thread.currentThread()).getSourceQueueAction();
            if (queueAction2 != null) {
                queueAction.setQueuePrio(queueAction2.getQueuePrio());
            }
            this.startItem(queueAction, false);
            return queueAction.getResult();
        }
        this.internalAdd(queueAction);
        try {
            while (!queueAction.isFinished()) {
                QueueAction<E, T> queueAction3 = queueAction;
                synchronized (queueAction3) {
                    queueAction.wait(1000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            queueAction.handleException(interruptedException);
        }
        if (queueAction.getExeption() != null && !queueAction.callExceptionHandler()) {
            if (!(queueAction.getExeption() instanceof RuntimeException)) throw queueAction.getExeption();
            throw (RuntimeException)queueAction.getExeption();
        }
        if (!queueAction.gotKilled()) return queueAction.getResult();
        if (queueAction.gotStarted()) return queueAction.getResult();
        queueAction.handleException(new InterruptedException("Queue got killed!"));
        return queueAction.getResult();
    }

    public void enqueue(QueueAction<?, ?> queueAction) {
        queueAction.reset();
        queueAction.setCallerThread(this, Thread.currentThread());
        this.internalAdd(queueAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueueAction<?, ? extends Throwable> getLastHistoryItem() {
        ArrayList<QueueAction<?, ? extends Throwable>> arrayList = this.queueThreadHistory;
        synchronized (arrayList) {
            if (this.queueThreadHistory.size() == 0) {
                return null;
            }
            return this.queueThreadHistory.get(this.queueThreadHistory.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQueueSize(QueuePriority queuePriority) {
        if (queuePriority == null) {
            return -1L;
        }
        Object object = this.queueLock;
        synchronized (object) {
            ArrayList<QueueAction<?, Throwable>> arrayList = this.queue.get((Object)queuePriority);
            if (arrayList == null) {
                return -1L;
            }
            return arrayList.size();
        }
    }

    protected QueueAction<?, ? extends Throwable> getSourceQueueAction() {
        return this.sourceItem;
    }

    protected void handlePreRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalAdd(QueueAction<?, ?> queueAction) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.get((Object)queueAction.getQueuePrio()).add(queueAction);
        }
        object = this;
        synchronized (object) {
            if (this.waitFlag) {
                this.waitFlag = false;
                this.notify();
            }
        }
    }

    public boolean isDebug() {
        return this.debugFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.queueLock;
        synchronized (object) {
            for (QueuePriority queuePriority : this.prios) {
                if (this.queue.get((Object)queuePriority).isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isQueueThread(QueueAction<?, ? extends Throwable> queueAction) {
        if (Thread.currentThread() == this.thread) {
            return true;
        }
        QueueAction<?, Throwable> queueAction2 = queueAction;
        Thread thread = null;
        int n = 0;
        while (queueAction2 != null && (thread = queueAction2.getCallerThread()) != null && thread != null && thread instanceof Queue) {
            if (thread == this.thread) {
                if (this.debugFlag) {
                    Log.L.warning("Multiple queues detected-> external synchronization may be required! " + queueAction);
                }
                return true;
            }
            queueAction2 = ((Queue)thread).getLastHistoryItem();
            if (n > QUEUELOOPPREVENTION.get()) {
                if (!this.debugFlag) break;
                Log.L.warning("QueueLoopPrevention!");
                break;
            }
            ++n;
        }
        return false;
    }

    public boolean isWaiting() {
        return this.waitFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            System.out.println(this.queue);
            for (QueuePriority queuePriority : this.prios) {
                for (QueueAction<?, Throwable> queueAction : this.queue.get((Object)queuePriority)) {
                    System.out.println("K");
                    queueAction.kill();
                    QueueAction<?, Throwable> queueAction2 = queueAction;
                    synchronized (queueAction2) {
                        queueAction.notify();
                    }
                }
                this.queue.get((Object)queuePriority).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.thread != null) {
            return;
        }
        this.thread = this;
        QueueAction<?, ? extends Throwable> queueAction = null;
        while (true) {
            try {
                while (true) {
                    this.handlePreRun();
                    Object object = this;
                    synchronized (object) {
                        while (this.waitFlag) {
                            try {
                                this.wait();
                            }
                            catch (Exception exception) {
                                Log.exception(exception);
                            }
                        }
                    }
                    object = this.queueLock;
                    synchronized (object) {
                        queueAction = null;
                        for (QueuePriority queuePriority : this.prios) {
                            if (this.queue.get((Object)queuePriority).size() <= 0) continue;
                            queueAction = this.queue.get((Object)queuePriority).remove(0);
                            break;
                        }
                        if (queueAction == null) {
                            this.waitFlag = true;
                        }
                    }
                    if (queueAction == null || this.waitFlag) continue;
                    try {
                        this.sourceItem = queueAction;
                        this.startItem(queueAction, true);
                    }
                    catch (Throwable throwable) {}
                    continue;
                    finally {
                        this.sourceItem = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Log.L.info("Queue rescued!");
                Log.exception(throwable);
                continue;
            }
            break;
        }
    }

    public void setDebug(boolean bl) {
        this.debugFlag = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Throwable> void startItem(QueueAction<?, T> queueAction, boolean bl) throws T {
        ArrayList<QueueAction<?, ? extends Throwable>> arrayList;
        try {
            this.currentJob = queueAction;
            if (this.thread != queueAction.getCallerThread()) {
                arrayList = this.queueThreadHistory;
                synchronized (arrayList) {
                    this.queueThreadHistory.add(queueAction);
                }
            }
            queueAction.start(this);
        }
        catch (Throwable throwable) {
            if (!bl || !queueAction.callExceptionHandler()) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw throwable;
            }
        }
        finally {
            queueAction.setFinished(true);
            if (this.thread != queueAction.getCallerThread()) {
                arrayList = this.queueThreadHistory;
                synchronized (arrayList) {
                    if (this.queueThreadHistory.size() != 0) {
                        this.queueThreadHistory.remove(this.queueThreadHistory.size() - 1);
                    }
                }
            }
            arrayList = queueAction;
            synchronized (arrayList) {
                queueAction.notify();
            }
            this.currentJob = null;
        }
    }

    public static enum QueuePriority {
        HIGH,
        LOW,
        NORM;

    }
}

