/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.appwork.utils.Files;
import org.appwork.utils.ReusableByteArrayOutputStreamPool;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.CrossSystem;

public class IO {
    public static void moveTo(File file, File file2, FileFilter fileFilter) throws IOException {
        ArrayList<File> arrayList = Files.getFiles(fileFilter, file);
        for (File file3 : arrayList) {
            String string = Files.getRelativePath(file, file3);
            File file4 = new File(file2, string);
            if (file3.isDirectory()) {
                file4.mkdirs();
                continue;
            }
            file4.getParentFile().mkdirs();
            System.out.println(file3 + " -> " + file4);
            if (file3.renameTo(file4)) continue;
            throw new IOException("Could not move file " + file3 + " to " + file4);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        if (Log.L.isLoggable(Level.FINEST)) {
            Log.L.finest("Copy " + file + " to " + file2);
        }
        try {
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(file2);
            abstractInterruptibleChannel = fileOutputStream.getChannel();
            if (CrossSystem.isWindows()) {
                long l = fileChannel.size();
                for (long i = 0L; i < l; i += fileChannel.transferTo(i, 67076096L, (WritableByteChannel)((Object)abstractInterruptibleChannel))) {
                }
            } else {
                fileChannel.transferTo(0L, fileChannel.size(), (WritableByteChannel)((Object)abstractInterruptibleChannel));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                abstractInterruptibleChannel.close();
            }
            catch (Throwable throwable) {}
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                fileChannel.close();
            }
            catch (Throwable throwable) {}
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String importFileToString(File file) throws IOException {
        return IO.importFileToString(file, -1);
    }

    public static String importFileToString(File file, int n) throws IOException {
        byte[] byArray = IO.readFile(file, n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF-8");
    }

    public static byte[] readFile(File file) throws IOException {
        return IO.readFile(file, -1);
    }

    public static byte[] readFile(File file, int n) throws IOException {
        return IO.readURL(file.toURI().toURL(), n);
    }

    public static String readFileToString(File file) throws IOException {
        return IO.readURLToString(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStreamToString(InputStream inputStream) throws UnsupportedEncodingException, IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = System.getProperty("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(string);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String readLine(BufferedInputStream bufferedInputStream, byte[] byArray) throws IOException {
        Arrays.fill(byArray, 0, byArray.length, (byte)0);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (true) {
            if ((n = bufferedInputStream.read()) == -1 && n2 == 0) {
                return null;
            }
            if (n == 13 || n == 10) {
                bl = true;
                bufferedInputStream.mark(1024);
            } else {
                if (bl) {
                    bufferedInputStream.reset();
                    --n2;
                    break;
                }
                if (n2 < byArray.length) {
                    byArray[n3++] = (byte)n;
                }
            }
            ++n2;
        }
        return new String(byArray, 0, n3, "UTF-8");
    }

    public static byte[] readStream(int n, InputStream inputStream) throws IOException {
        return IO.readStream(n, inputStream, new ByteArrayOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(int n, InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ReusableByteArrayOutputStreamPool.ReusableByteArrayOutputStream reusableByteArrayOutputStream = null;
        try {
            int n2;
            reusableByteArrayOutputStream = ReusableByteArrayOutputStreamPool.getReusableByteArrayOutputStream(Short.MAX_VALUE);
            while ((n2 = inputStream.read(reusableByteArrayOutputStream.getInternalBuffer())) != -1) {
                if (n2 <= 0) continue;
                byteArrayOutputStream.write(reusableByteArrayOutputStream.getInternalBuffer(), 0, n2);
                if (n <= 0 || byteArrayOutputStream.size() <= n) continue;
                throw new IOException("Max size exeeded!");
            }
        }
        finally {
            try {
                ReusableByteArrayOutputStreamPool.reuseReusableByteArrayOutputStream(reusableByteArrayOutputStream);
            }
            catch (Throwable throwable) {}
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readURL(URL uRL) throws IOException {
        return IO.readURL(uRL, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readURL(URL uRL, int n) throws IOException {
        InputStream inputStream = null;
        try {
            if (Log.L.isLoggable(Level.FINEST)) {
                Log.L.finest("Read " + uRL + " max size: " + n);
            }
            inputStream = uRL.openStream();
            byte[] byArray = IO.readStream(n, inputStream);
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURLToString(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            if (Log.L.isLoggable(Level.FINEST)) {
                Log.L.finest("Read " + uRL);
            }
            inputStream = uRL.openStream();
            String string = IO.readInputStreamToString(inputStream);
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String string) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        file.createNewFile();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        FileWriter fileWriter = null;
        if (Log.L.isLoggable(Level.FINEST)) {
            Log.L.finest("Write " + file);
        }
        fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            bufferedWriter.write(string);
        }
        finally {
            try {
                ((Writer)bufferedWriter).flush();
            }
            catch (Throwable throwable) {}
            try {
                fileWriter.flush();
            }
            catch (Throwable throwable) {}
            try {
                ((Writer)bufferedWriter).close();
            }
            catch (Throwable throwable) {}
            try {
                fileWriter.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, byte[] byArray) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        file.createNewFile();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        if (Log.L.isLoggable(Level.FINEST)) {
            Log.L.finest("Write " + file);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

