/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.appwork.utils.formatter.HexFormatter;

public class Hash {
    public static final String HASH_TYPE_SHA256 = "SHA-256";
    public static String HASH_TYPE_MD5 = "md5";
    public static String HASH_TYPE_SHA1 = "SHA-1";

    public static String getBytesHash(byte[] byArray, String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = messageDigest.digest(byArray);
            return HexFormatter.byteArrayToHex(byArray2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(byte[] byArray) throws IOException {
        FilterInputStream filterInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new CheckedInputStream(byteArrayInputStream, new CRC32());
            byte[] byArray2 = new byte[Short.MAX_VALUE];
            while (filterInputStream.read(byArray2) >= 0) {
            }
            long l = ((CheckedInputStream)filterInputStream).getChecksum().getValue();
            return l;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                byteArrayInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File file) throws IOException {
        FileInputStream fileInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            filterInputStream = new CheckedInputStream(fileInputStream, new CRC32());
            byte[] byArray = new byte[Short.MAX_VALUE];
            while (filterInputStream.read(byArray) >= 0) {
            }
            long l = ((CheckedInputStream)filterInputStream).getChecksum().getValue();
            return l;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileHash(File file, String string) {
        byte[] byArray;
        if (file == null) return null;
        if (!file.exists()) return null;
        if (file.isDirectory()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
            byArray = new byte[Short.MAX_VALUE];
            fileInputStream = new FileInputStream(file);
            int n = 0;
            while ((n = fileInputStream.read(byArray)) >= 0) {
                if (n <= 0) continue;
                messageDigest.update(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                String string2 = null;
                return string2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Throwable throwable) {}
        byArray = messageDigest.digest();
        return HexFormatter.byteArrayToHex(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileHash(File file, String string, long l) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (file.isDirectory()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
            int n = Short.MAX_VALUE;
            if (l < (long)n) {
                n = (int)l;
            }
            byte[] byArray = new byte[n];
            fileInputStream = new FileInputStream(file);
            int n2 = 0;
            long l2 = l;
            while ((n2 = fileInputStream.read(byArray, 0, n)) >= 0) {
                if (n2 > 0) {
                    messageDigest.update(byArray, 0, n2);
                }
                if (l <= 0L || n2 <= 0) continue;
                if ((l2 -= (long)n2) != 0L) {
                    if (l2 >= (long)n) continue;
                    n = (int)l2;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                String string2 = null;
                return string2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Throwable throwable) {}
        byte[] byArray = messageDigest.digest();
        return HexFormatter.byteArrayToHex(byArray);
    }

    public static String getMD5(File file) {
        return Hash.getFileHash(file, HASH_TYPE_MD5);
    }

    public static String getMD5(String string) {
        return Hash.getStringHash(string, HASH_TYPE_MD5);
    }

    public static String getSHA1(File file) {
        return Hash.getFileHash(file, HASH_TYPE_SHA1);
    }

    public static String getSHA1(String string) {
        return Hash.getStringHash(string, HASH_TYPE_SHA1);
    }

    public static String getSHA256(byte[] byArray) {
        return Hash.getBytesHash(byArray, HASH_TYPE_SHA256);
    }

    public static String getSHA256(File file) {
        return Hash.getFileHash(file, HASH_TYPE_SHA256);
    }

    public static String getSHA256(String string) {
        return Hash.getStringHash(string, HASH_TYPE_SHA256);
    }

    public static String getStringHash(String string, String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            return HexFormatter.byteArrayToHex(byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }
}

